/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.kit;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.kit.Kit;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.util.ModUtils;
import com.maciej916.maessentials.common.util.TimeUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;

public class KitCommand
extends BaseCommand {
    public KitCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)this.builder.then(Commands.func_197056_a((String)"kitName", (ArgumentType)StringArgumentType.string()).suggests(ModUtils.KIT_SUGGEST).executes(context -> this.execute((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"kitName"))));
    }

    private int execute(CommandSource source, String kitName) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        Kit kit = DataManager.getKit().getKit(kitName);
        if (kit == null) {
            this.sendMessage(player, "kit.maessentials.not_exist", kitName);
            return 1;
        }
        long cooldown = eslPlayer.getUsage().getKitCooldown(kitName, kit.getDuration());
        if (cooldown != 0L) {
            String displayTime = TimeUtils.formatDate(cooldown);
            this.sendMessage(player, "kit.maessentials.wait", displayTime);
            return 1;
        }
        if (ModUtils.giveKit(player, kit)) {
            eslPlayer.getUsage().setKitUssage(kitName);
            eslPlayer.saveData();
            player.field_70170_p.func_184148_a((PlayerEntity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.sendMessage(player, "kit.maessentials.received", kitName);
        }
        return 1;
    }
}

