/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.home;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.config.ModConfig;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.Location;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.util.ModUtils;
import com.maciej916.maessentials.common.util.TeleportUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;

public class HomeCommand
extends BaseCommand {
    public HomeCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)this.builder.executes(context -> this.execute((CommandSource)context.getSource()))).then(Commands.func_197056_a((String)"homeName", (ArgumentType)StringArgumentType.string()).suggests(ModUtils.HOME_SUGGEST).executes(context -> this.execute((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"homeName"))));
    }

    private int execute(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        if (eslPlayer.getHomeData().getHomes().size() == 1) {
            this.doHome(player, eslPlayer.getHomeData().getHomes().entrySet().iterator().next().getKey());
        } else if (eslPlayer.getHomeData().getHomes().size() > 1) {
            this.sendMessage(player, "home.maessentials.specify_name", new Object[0]);
        } else {
            this.sendMessage(player, "home.maessentials.no_homes", new Object[0]);
        }
        return 1;
    }

    private int execute(CommandSource source, String homeName) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        this.doHome(player, homeName);
        return 1;
    }

    private void doHome(ServerPlayerEntity player, String name) {
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        if (eslPlayer.getHomeData().getHomes().size() == 0) {
            this.sendMessage(player, "home.maessentials.no_homes", new Object[0]);
            return;
        }
        Location location = eslPlayer.getHomeData().getHome(name);
        if (location == null) {
            this.sendMessage(player, "home.maessentials.not_exist", name);
            return;
        }
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("home", ModConfig.homes_cooldown.intValue());
        if (cooldown != 0L) {
            this.sendMessage(player, "maessentials.cooldown.teleport", cooldown);
            return;
        }
        eslPlayer.getUsage().setCommandUsage("home");
        eslPlayer.saveData();
        if (TeleportUtils.simpleTeleport(player, location, "home", ModConfig.homes_delay.intValue())) {
            if (ModConfig.homes_delay == 0) {
                this.sendMessage(player, "home.maessentials.teleport", name);
            } else {
                this.sendMessage(player, "home.maessentials.teleport.wait", name, ModConfig.homes_delay);
            }
        }
    }
}

