/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.client;

import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenContainer;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.modulesclient.helper.ScreenModuleGuiBuilder;
import mcjty.rftoolsutility.modules.screen.network.PacketModuleUpdate;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GuiScreen
extends GenericGuiContainer<ScreenTileEntity, ScreenContainer> {
    public static final int SCREEN_WIDTH = 256;
    public static final int SCREEN_HEIGHT = 224;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("rftoolsutility", "textures/gui/screen.png");
    private Panel toplevel;
    private ToggleButton[] toggleButtons = new ToggleButton[11];
    private Panel[] modulePanels = new Panel[11];
    private IClientScreenModule<?>[] clientScreenModules = new IClientScreenModule[11];
    private ChoiceLabel trueType;
    private int selected = -1;

    public GuiScreen(ScreenTileEntity screenTileEntity, ScreenContainer container, PlayerInventory inventory) {
        super((ModBase)RFToolsUtility.instance, (GenericTileEntity)screenTileEntity, (Container)container, inventory, ManualHelper.create((String)"rftoolsutility:machines/screen"));
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void init() {
        super.init();
        this.toplevel = (Panel)Widgets.positional().background(BACKGROUND);
        for (int i = 0; i < 11; ++i) {
            this.toggleButtons[i] = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().hint(30, 7 + i * 18 + 1, 40, 16)).enabled(false)).tooltips(new String[]{"Open the gui for this", "module"});
            int finalI = i;
            this.toggleButtons[i].event(() -> this.selectPanel(finalI));
            this.toplevel.children(new Widget[]{this.toggleButtons[i]});
            this.modulePanels[i] = null;
            this.clientScreenModules[i] = null;
        }
        ToggleButton bright = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().name("bright")).text("Bright")).checkMarker(true).tooltips(new String[]{"Toggle full brightness"})).hint(85, 123, 55, 14);
        this.toplevel.children(new Widget[]{bright, Widgets.label((int)144, (int)123, (int)30, (int)14, (String)"Font:").horizontalAlignment(HorizontalAlignment.ALIGN_RIGHT)});
        this.trueType = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel().choices(new String[]{"Default", "Truetype", "Vanilla"}).tooltips(new String[]{"Set truetype font mode", "for the screen"})).hint(179, 123, 68, 14);
        int trueTypeMode = ((ScreenTileEntity)this.tileEntity).getTrueTypeMode();
        this.trueType.choice(trueTypeMode == 0 ? "Default" : (trueTypeMode == -1 ? "Vanilla" : "Truetype"));
        this.trueType.event(b -> this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, "screen.setTruetype", TypedMap.builder().put(ScreenTileEntity.PARAM_TRUETYPE, (Object)this.getCurrentTruetypeChoice()).build()));
        this.toplevel.children(new Widget[]{this.trueType});
        this.toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.window = new Window((Screen)this, (AbstractContainerWidget)this.toplevel);
        this.window.bind(RFToolsUtilityMessages.INSTANCE, "bright", this.tileEntity, ScreenTileEntity.VALUE_BRIGHT.getName());
        this.minecraft.field_195559_v.func_197967_a(true);
        this.selected = -1;
    }

    private int getCurrentTruetypeChoice() {
        String c = this.trueType.getCurrentChoice();
        if ("Default".equals(c)) {
            return 0;
        }
        if ("Truetype".equals(c)) {
            return 1;
        }
        return -1;
    }

    private void selectPanel(int i) {
        this.selected = this.toggleButtons[i].isPressed() ? i : -1;
    }

    private void refreshButtons() {
        ((ScreenTileEntity)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            for (int i = 0; i < 11; ++i) {
                ItemStack slot = h.getStackInSlot(i);
                if (!slot.func_190926_b() && ScreenBlock.hasModuleProvider(slot)) {
                    int finalI = i;
                    ScreenBlock.getModuleProvider(slot).ifPresent(moduleProvider -> {
                        Class clientScreenModuleClass = moduleProvider.getClientScreenModule();
                        if (!clientScreenModuleClass.isInstance(this.clientScreenModules[finalI])) {
                            this.installModuleGui(finalI, slot, (IModuleProvider)moduleProvider, clientScreenModuleClass);
                        }
                    });
                } else {
                    this.uninstallModuleGui(i);
                }
                if (this.modulePanels[i] == null) continue;
                this.modulePanels[i].visible(this.selected == i);
                this.toggleButtons[i].pressed(this.selected == i);
            }
        });
    }

    private void uninstallModuleGui(int i) {
        this.toggleButtons[i].enabled(false);
        this.toggleButtons[i].pressed(false);
        this.toggleButtons[i].text("");
        this.clientScreenModules[i] = null;
        this.toplevel.removeChild((Widget)this.modulePanels[i]);
        this.modulePanels[i] = null;
        if (this.selected == i) {
            this.selected = -1;
        }
    }

    private void installModuleGui(int i, ItemStack slot, IModuleProvider moduleProvider, Class<? extends IClientScreenModule<?>> clientScreenModuleClass) {
        this.toggleButtons[i].enabled(true);
        this.toplevel.removeChild((Widget)this.modulePanels[i]);
        try {
            IClientScreenModule<?> clientScreenModule = clientScreenModuleClass.newInstance();
            this.clientScreenModules[i] = clientScreenModule;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        CompoundNBT tagCompound = slot.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        CompoundNBT finalTagCompound = tagCompound;
        ScreenModuleGuiBuilder guiBuilder = new ScreenModuleGuiBuilder(this.minecraft, (Screen)this, tagCompound, () -> {
            slot.func_77982_d(finalTagCompound);
            ((ScreenTileEntity)this.tileEntity).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> ((IItemHandlerModifiable)h).setStackInSlot(i, slot));
            RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketModuleUpdate(((ScreenTileEntity)this.tileEntity).func_174877_v(), i, finalTagCompound));
        });
        moduleProvider.createGui((IModuleGuiBuilder)guiBuilder);
        this.modulePanels[i] = guiBuilder.build();
        this.modulePanels[i].hint(80, 8, 170, 114);
        ((Panel)this.modulePanels[i].filledRectThickness(-2)).filledBackground(-7631989);
        this.toplevel.children(new Widget[]{this.modulePanels[i]});
        this.toggleButtons[i].text(moduleProvider.getModuleName());
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.refreshButtons();
        this.drawWindow();
    }
}

