/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.varia.Logging;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class JSonTools {
    public static int get(JsonObject object, String name, int def) {
        if (object.has(name)) {
            return object.get(name).getAsInt();
        }
        return def;
    }

    public static boolean get(JsonObject object, String name, boolean def) {
        if (object.has(name)) {
            return object.get(name).getAsBoolean();
        }
        return def;
    }

    public static String get(JsonObject object, String name, String def) {
        if (object.has(name)) {
            return object.get(name).getAsString();
        }
        return def;
    }

    public static void put(JsonObject object, String name, Integer value, Integer def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        object.add(name, (JsonElement)new JsonPrimitive((Number)value));
    }

    public static void put(JsonObject object, String name, Boolean value, Boolean def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        object.add(name, (JsonElement)new JsonPrimitive(value));
    }

    public static void put(JsonObject object, String name, String value, String def) {
        if (value == null) {
            return;
        }
        if (value.equals(def)) {
            return;
        }
        object.add(name, (JsonElement)new JsonPrimitive(value));
    }

    public static void putStringList(JsonObject object, String name, @Nullable List<String> list) {
        if (list == null) {
            return;
        }
        if (list.size() == 1) {
            object.add(name, (JsonElement)new JsonPrimitive(list.get(0)));
        } else {
            JsonArray array = new JsonArray();
            for (String s : list) {
                array.add((JsonElement)new JsonPrimitive(s));
            }
            object.add(name, (JsonElement)array);
        }
    }

    @Nullable
    public static List<String> getStringList(JsonObject object, String name) {
        if (!object.has(name)) {
            return null;
        }
        if (object.get(name).isJsonArray()) {
            JsonArray array = object.getAsJsonArray(name);
            ArrayList<String> result = new ArrayList<String>();
            for (JsonElement element : array) {
                result.add(element.getAsString());
            }
            return result;
        }
        return Collections.singletonList(object.get(name).getAsString());
    }

    public static JsonObject itemStackToJson(ItemStack item) {
        JsonObject object = new JsonObject();
        object.add("item", (JsonElement)new JsonPrimitive(item.func_77973_b().getRegistryName().toString()));
        if (item.func_190916_E() != 1) {
            object.add("amount", (JsonElement)new JsonPrimitive((Number)item.func_190916_E()));
        }
        if (item.func_77942_o()) {
            String string = item.func_77978_p().toString();
            object.add("nbt", (JsonElement)new JsonPrimitive(string));
        }
        return object;
    }

    public static ItemStack jsonToItemStack(JsonObject obj) {
        String itemName = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        int amount = 1;
        if (obj.has("amount")) {
            amount = obj.get("amount").getAsInt();
        }
        ItemStack stack = new ItemStack((IItemProvider)item, amount);
        if (obj.has("nbt")) {
            try {
                CompoundNBT nbt = JsonToNBT.func_180713_a((String)obj.get("nbt").getAsString());
                stack.func_77982_d(nbt);
            }
            catch (CommandSyntaxException e) {
                Logging.logError("Parsing error", e);
            }
        }
        return stack;
    }
}

