/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.Iterator;
import javax.annotation.Nonnull;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ItemStackList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class NoDirectionItemHander
implements IItemHandlerModifiable,
INBTSerializable<ListNBT> {
    public final GenericTileEntity tileEntity;
    private final ContainerFactory containerFactory;
    private ItemStackList stacks;

    protected void onUpdate(int index) {
        this.tileEntity.markDirtyQuick();
    }

    public NoDirectionItemHander(GenericTileEntity te, ContainerFactory factory) {
        this.tileEntity = te;
        this.containerFactory = factory;
        this.stacks = ItemStackList.create(this.containerFactory.getContainerSlots());
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemInsertable(slot, stack)) {
            return stack;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.setInventorySlotContents(copy.func_77976_d(), slot, copy);
                    this.onUpdate(slot);
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.setInventorySlotContents(copy.func_77976_d(), slot, copy);
                this.onUpdate(slot);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.setInventorySlotContents(stack.func_77976_d(), slot, stack.func_77979_a(m));
                this.onUpdate(slot);
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(stack.func_77976_d(), slot, stack);
            this.onUpdate(slot);
        }
        return ItemStack.field_190927_a;
    }

    public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        if (this.containerFactory.isGhostSlot(index)) {
            if (!stack.func_190926_b()) {
                ItemStack stack1 = stack.func_77946_l();
                if (index < 9) {
                    stack1.func_190920_e(1);
                }
                this.stacks.set(index, stack1);
            } else {
                this.stacks.set(index, ItemStack.field_190927_a);
            }
        } else if (this.containerFactory.isGhostOutputSlot(index)) {
            if (!stack.func_190926_b()) {
                this.stacks.set(index, stack.func_77946_l());
            } else {
                this.stacks.set(index, ItemStack.field_190927_a);
            }
        } else {
            this.stacks.set(index, stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > stackLimit) {
                if (stackLimit <= 0) {
                    stack.func_190920_e(0);
                } else {
                    stack.func_190920_e(stackLimit);
                }
            }
            this.tileEntity.func_70296_d();
        }
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemExtractable(slot, stackInSlot)) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack decrStackSize = this.decrStackSize(slot, m);
        this.onUpdate(slot);
        return decrStackSize;
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.size()) {
            return ItemStack.field_190927_a;
        }
        if (this.containerFactory.isGhostSlot(index) || this.containerFactory.isGhostOutputSlot(index)) {
            ItemStack old = (ItemStack)this.stacks.get(index);
            this.stacks.set(index, ItemStack.field_190927_a);
            if (old.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            old.func_190920_e(0);
            return old;
        }
        if (!((ItemStack)this.stacks.get(index)).func_190926_b()) {
            if (((ItemStack)this.stacks.get(index)).func_190916_E() <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, ItemStack.field_190927_a);
                this.tileEntity.func_70296_d();
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).func_77979_a(amount);
            if (((ItemStack)this.stacks.get(index)).func_190926_b()) {
                this.stacks.set(index, ItemStack.field_190927_a);
            }
            this.tileEntity.func_70296_d();
            return its;
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.stacks.set(slot, stack);
        this.onUpdate(slot);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean isItemExtractable(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public ContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public ListNBT serializeNBT() {
        ListNBT bufferTagList = new ListNBT();
        Iterator iterator = this.stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            CompoundNBT compoundNBT = new CompoundNBT();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(compoundNBT);
            }
            bufferTagList.add((Object)compoundNBT);
        }
        return bufferTagList;
    }

    public void deserializeNBT(ListNBT nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundNBT compoundNBT = nbt.func_150305_b(i);
            if (i >= this.stacks.size()) continue;
            this.stacks.set(i, ItemStack.func_199557_a((CompoundNBT)compoundNBT));
        }
    }
}

