/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.world.gen;

import com.stal111.forbidden_arcanus.config.WorldGenConfig;
import com.stal111.forbidden_arcanus.init.ModFeatures;
import com.stal111.forbidden_arcanus.world.BiomeFeatures;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DarkForestBiome;
import net.minecraft.world.biome.DarkForestHillsBiome;
import net.minecraft.world.biome.FlowerForestBiome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldGenerator {
    public static void setupWorldGen() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (biome.func_150561_m() != Biome.TempCategory.MEDIUM || biome.func_201851_b() != Biome.RainType.RAIN) continue;
            if (biome.func_201856_r() == Biome.Category.PLAINS && ((Boolean)WorldGenConfig.GENERATE_CHERRYWOOD_TREES.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.CHERRYWOOD_TREE.getFeature().func_225566_b_((IFeatureConfig)BiomeFeatures.CHERRYWOOD_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1))));
            }
            if (biome instanceof FlowerForestBiome) {
                if (((Boolean)WorldGenConfig.GENERATE_MYSTERYWOOD_TREES.get()).booleanValue()) {
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202339_q.func_225566_b_((IFeatureConfig)BiomeFeatures.MYSTERYWOOD_TREE).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1))));
                }
                if (((Boolean)WorldGenConfig.GENERATE_YELLOW_ORCHID.get()).booleanValue()) {
                    biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)BiomeFeatures.YELLOW_ORCHID).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(17))));
                }
            }
            if ((biome instanceof DarkForestBiome || biome instanceof DarkForestHillsBiome) && ((Boolean)WorldGenConfig.GENERATE_EDELWOOD.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)BiomeFeatures.EDELWOOD).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(10))));
            }
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ModFeatures.PETRIFIED_ROOT.getFeature().func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(100))));
        }
    }
}

