/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.client.gui.SortButton;
import net.blay09.mods.cookingforblockheads.container.RecipeBookContainer;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotCraftMatrix;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlotRecipe;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.blay09.mods.cookingforblockheads.registry.RecipeType;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RecipeBookScreen
extends ContainerScreen<RecipeBookContainer> {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final ResourceLocation guiTexture = new ResourceLocation("cookingforblockheads", "textures/gui/gui.png");
    private static final int VISIBLE_ROWS = 4;
    private final RecipeBookContainer container;
    private boolean isEventHandler;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private double mouseClickY = -1.0;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private Button btnNextRecipe;
    private Button btnPrevRecipe;
    private TextFieldWidget searchBar;
    private final List<SortButton> sortButtons = Lists.newArrayList();
    private final String[] noIngredients;
    private final String[] noSelection;

    public RecipeBookScreen(RecipeBookContainer container, PlayerInventory playerInventory, ITextComponent displayName) {
        super((Container)container, playerInventory, displayName);
        this.container = container;
        this.noIngredients = I18n.func_135052_a((String)"gui.cookingforblockheads:no_ingredients", (Object[])new Object[0]).split("\\\\n");
        this.noSelection = I18n.func_135052_a((String)"gui.cookingforblockheads:no_selection", (Object[])new Object[0]).split("\\\\n");
    }

    protected void init() {
        this.field_147000_g = 174;
        super.init();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.btnPrevRecipe = new Button(this.width / 2 - 79, this.height / 2 - 51, 13, 20, "<", it -> this.container.nextSubRecipe(-1));
        this.btnPrevRecipe.visible = false;
        this.addButton((Widget)this.btnPrevRecipe);
        this.btnNextRecipe = new Button(this.width / 2 - 9, this.height / 2 - 51, 13, 20, ">", it -> this.container.nextSubRecipe(1));
        this.btnNextRecipe.visible = false;
        this.addButton((Widget)this.btnNextRecipe);
        this.searchBar = new TextFieldWidget(this.getMinecraft().field_71466_p, this.field_147003_i + this.field_146999_f - 78, this.field_147009_r - 5, 70, 10, this.searchBar, "searchbar");
        this.func_212928_a((IGuiEventListener)this.searchBar);
        int yOffset = -80;
        for (ISortButton button : CookingRegistry.getSortButtons()) {
            SortButton sortButton = new SortButton(this.width / 2 + 87, this.height / 2 + yOffset, button, it -> this.container.setSortComparator(((SortButton)it).getComparator((PlayerEntity)Minecraft.func_71410_x().field_71439_g)));
            this.addButton((Widget)sortButton);
            this.sortButtons.add(sortButton);
            yOffset += 20;
        }
        if (!this.isEventHandler) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.isEventHandler = true;
        }
        this.recalculateScrollBar();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta == 0.0) {
            return false;
        }
        if (this.container.getSelection() != null && mouseX >= (double)(this.field_147003_i + 7) && mouseY >= (double)(this.field_147009_r + 17) && mouseX < (double)(this.field_147003_i + 92) && mouseY < (double)(this.field_147009_r + 95)) {
            Slot slot = this.getSlotUnderMouse();
            if (slot instanceof FakeSlotCraftMatrix && ((FakeSlotCraftMatrix)slot).getVisibleStacks().size() > 1) {
                ((FakeSlotCraftMatrix)slot).scrollDisplayList(delta > 0.0 ? -1 : 1);
            }
        } else {
            this.setCurrentOffset(delta > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        boolean result = super.mouseReleased(mouseX, mouseY, state);
        if (state != -1 && this.mouseClickY != -1.0) {
            this.mouseClickY = -1.0;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return result;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Slot mouseSlot;
        super.mouseClicked(mouseX, mouseY, button);
        if (button == 1 && mouseX >= (double)this.searchBar.x && mouseX < (double)(this.searchBar.x + this.searchBar.getWidth()) && mouseY >= (double)this.searchBar.y && mouseY < (double)(this.searchBar.y + this.searchBar.getHeight())) {
            this.searchBar.func_146180_a("");
            this.container.search(null);
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (this.searchBar.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.currentOffset;
        }
        if ((mouseSlot = this.getSlotUnderMouse()) instanceof FakeSlotCraftMatrix) {
            if (button == 0) {
                ItemStack itemStack = mouseSlot.func_75211_c();
                FoodRecipeWithStatus recipe = this.container.findAvailableRecipe(itemStack);
                if (recipe != null) {
                    this.container.setSelectedRecipe(recipe, false);
                    this.setCurrentOffset(this.container.getSelectedRecipeIndex());
                } else if (!CookingRegistry.getFoodRecipes(itemStack).isEmpty()) {
                    this.container.setSelectedRecipe(new FoodRecipeWithStatus(itemStack, RecipeStatus.MISSING_INGREDIENTS), true);
                }
            } else if (button == 1) {
                ((FakeSlotCraftMatrix)mouseSlot).setLocked(!((FakeSlotCraftMatrix)mouseSlot).isLocked());
            }
            return true;
        }
        return false;
    }

    public boolean charTyped(char c, int keyCode) {
        boolean result = super.charTyped(c, keyCode);
        this.container.search(this.searchBar.func_146179_b());
        this.container.populateRecipeSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.getMinecraft().field_71439_g.func_71053_j();
            return true;
        }
        if (this.searchBar.keyPressed(keyCode, scanCode, modifiers) || this.searchBar.isFocused()) {
            this.container.search(this.searchBar.func_146179_b());
            this.container.populateRecipeSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int curY;
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.container.isDirty()) {
            this.setCurrentOffset(this.currentOffset);
            this.container.setDirty(false);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(guiTexture);
        this.blit(this.field_147003_i, this.field_147009_r - 10, 0, 0, this.field_146999_f, this.field_147000_g + 10);
        if (this.mouseClickY != -1.0 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)(((double)mouseY - this.mouseClickY) / (double)pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.btnPrevRecipe.visible = this.container.hasVariants();
        this.btnPrevRecipe.active = this.container.getSelectionIndex() > 0;
        this.btnNextRecipe.visible = this.container.hasVariants();
        this.btnNextRecipe.active = this.container.getSelectionIndex() < this.container.getRecipeCount() - 1;
        boolean hasRecipes = this.container.getItemListCount() > 0;
        for (Button button : this.sortButtons) {
            button.active = hasRecipes;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FontRenderer fontRenderer = this.getMinecraft().field_71466_p;
        FoodRecipeWithIngredients foodRecipeWithIngredients = this.container.getSelection();
        if (foodRecipeWithIngredients == null) {
            int n = this.noSelection.length / 2;
            fontRenderer.getClass();
            curY = this.field_147009_r + 39 - n * 9;
            for (String s : this.noSelection) {
                fontRenderer.func_175063_a(s, (float)(this.field_147003_i + 23 + 27) - (float)fontRenderer.func_78256_a(s) / 2.0f, (float)curY, -1);
                fontRenderer.getClass();
                curY += 9 + 5;
            }
        } else if (foodRecipeWithIngredients.getRecipeType() == RecipeType.SMELTING) {
            this.blit(this.field_147003_i + 23, this.field_147009_r + 19, 54, 184, 54, 54);
        } else {
            this.blit(this.field_147003_i + 23, this.field_147009_r + 19, 0, 184, 54, 54);
        }
        if (foodRecipeWithIngredients != null) {
            for (FakeSlotCraftMatrix slot : this.container.getCraftingMatrixSlots()) {
                if (!slot.isLocked() || slot.getVisibleStacks().size() <= 1) continue;
                this.blit(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 176, 60, 16, 16);
            }
        }
        RecipeBookScreen.fill((int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        if (this.container.getItemListCount() == 0) {
            RecipeBookScreen.fill((int)(this.field_147003_i + 97), (int)(this.field_147009_r + 7), (int)(this.field_147003_i + 168), (int)(this.field_147009_r + 85), (int)-1440603614);
            int n = this.noIngredients.length / 2;
            fontRenderer.getClass();
            curY = this.field_147009_r + 39 - n * 9;
            for (String s : this.noIngredients) {
                fontRenderer.func_175063_a(s, (float)(this.field_147003_i + 97 + 36) - (float)fontRenderer.func_78256_a(s) / 2.0f, (float)curY, -1);
                fontRenderer.getClass();
                curY += 9 + 5;
            }
        }
        this.searchBar.renderButton(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(guiTexture);
        if (((Boolean)CookingForBlockheadsConfig.CLIENT.showIngredientIcon.get()).booleanValue()) {
            int prevZLevel = this.getBlitOffset();
            this.setBlitOffset(300);
            for (Slot slot : this.container.field_75151_b) {
                FoodRecipeWithStatus recipe;
                if (!(slot instanceof FakeSlotRecipe)) continue;
                if (CookingRegistry.isNonFoodRecipe(slot.func_75211_c())) {
                    this.blit(slot.field_75223_e, slot.field_75221_f, 176, 76, 16, 16);
                }
                if ((recipe = ((FakeSlotRecipe)slot).getRecipe()) == null || recipe.getStatus() != RecipeStatus.MISSING_TOOLS) continue;
                this.blit(slot.field_75223_e, slot.field_75221_f, 176, 92, 16, 16);
            }
            this.setBlitOffset(prevZLevel);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        int prevZLevel = this.getBlitOffset();
        this.setBlitOffset(300);
        for (Slot slot : this.container.field_75151_b) {
            if (!(slot instanceof FakeSlotCraftMatrix) || ((FakeSlotCraftMatrix)slot).isAvailable() || slot.func_75211_c().func_190926_b()) continue;
            this.fillGradient(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, this.field_147003_i + slot.field_75223_e + 16, this.field_147009_r + slot.field_75221_f + 16, 0x77FF4444, 0x77FF5555);
        }
        this.setBlitOffset(prevZLevel);
        this.container.updateSlots(partialTicks);
        for (Button button : this.sortButtons) {
            if (!(button instanceof SortButton) || !button.isMouseOver((double)mouseX, (double)mouseY) || !button.active) continue;
            this.renderTooltip(((SortButton)button).getTooltipLines(), mouseX, mouseY);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    public void removed() {
        super.removed();
        this.getMinecraft().field_195559_v.func_197967_a(false);
        if (this.isEventHandler) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.isEventHandler = false;
        }
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.container.getItemListCount() / 3.0f)));
        this.scrollBarXPos = this.field_147003_i + this.field_146999_f - 7 - 9;
        this.scrollBarYPos = this.field_147009_r + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.container.getItemListCount() / 3.0f) - 4));
        this.container.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Slot hoverSlot = this.getSlotUnderMouse();
        if (hoverSlot instanceof FakeSlotRecipe && event.getItemStack() == hoverSlot.func_75211_c()) {
            FakeSlotRecipe slotRecipe = (FakeSlotRecipe)hoverSlot;
            if (this.container.isSelectedSlot(slotRecipe) && this.container.isAllowCrafting()) {
                FoodRecipeWithIngredients subRecipe = this.container.getSelection();
                if (subRecipe == null) {
                    return;
                }
                if (subRecipe.getRecipeType() == RecipeType.SMELTING) {
                    if (!this.container.hasOven()) {
                        event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:missing_oven", TextFormatting.RED));
                    } else if (RecipeBookScreen.hasShiftDown()) {
                        event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_smelt_stack", TextFormatting.GREEN));
                    } else {
                        event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_smelt_one", TextFormatting.GREEN));
                    }
                } else if (subRecipe.getRecipeStatus() == RecipeStatus.MISSING_TOOLS) {
                    event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:missing_tools", TextFormatting.RED));
                } else if (subRecipe.getRecipeStatus() == RecipeStatus.MISSING_INGREDIENTS) {
                    event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:missing_ingredients", TextFormatting.RED));
                } else if (RecipeBookScreen.hasShiftDown()) {
                    event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_craft_stack", TextFormatting.GREEN));
                } else {
                    event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_craft_one", TextFormatting.GREEN));
                }
            } else {
                event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_see_recipe", TextFormatting.YELLOW));
            }
        } else if (hoverSlot instanceof FakeSlotCraftMatrix && event.getItemStack() == hoverSlot.func_75211_c() && ((FakeSlotCraftMatrix)hoverSlot).getVisibleStacks().size() > 1) {
            if (((FakeSlotCraftMatrix)hoverSlot).isLocked()) {
                event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_unlock", TextFormatting.GREEN));
            } else {
                event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_lock", TextFormatting.GREEN));
            }
            event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:scroll_to_switch", TextFormatting.YELLOW));
        }
    }

    public Button[] getSortingButtons() {
        return this.sortButtons.toArray(new SortButton[0]);
    }
}

