/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.network.MessageRegister;

public class MessageParticleTrail {
    private static final int STEPS_PER_UNIT = 4;
    private final Vec3d position;
    private final Vec3d direction;
    private final double length;
    private final int time;
    private final ItemStack cad;

    public MessageParticleTrail(Vec3d position, Vec3d direction, double length, int time, ItemStack cad) {
        this.position = position;
        this.direction = direction;
        this.length = length;
        this.time = time;
        this.cad = cad;
    }

    public MessageParticleTrail(PacketBuffer buf) {
        this.position = MessageRegister.readVec3d(buf);
        this.direction = MessageRegister.readVec3d(buf);
        this.length = buf.readDouble();
        this.time = buf.func_150792_a();
        this.cad = buf.func_150791_c();
    }

    public void encode(PacketBuffer buf) {
        MessageRegister.writeVec3d(buf, this.position);
        MessageRegister.writeVec3d(buf, this.direction);
        buf.writeDouble(this.length);
        buf.func_150787_b(this.time);
        buf.func_150788_a(this.cad);
    }

    public boolean receive(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            World world = Psi.proxy.getClientWorld();
            int color = Psi.proxy.getColorForCAD(this.cad);
            float red = PsiRenderHelper.r(color);
            float green = PsiRenderHelper.g(color);
            float blue = PsiRenderHelper.b(color);
            Vec3d ray = this.direction.func_72432_b().func_186678_a(0.25);
            int steps = (int)(this.length * 4.0);
            for (int i = 0; i < steps; ++i) {
                double x = this.position.field_72450_a + ray.field_72450_a * (double)i;
                double y = this.position.field_72448_b + ray.field_72448_b * (double)i;
                double z = this.position.field_72449_c + ray.field_72449_c * (double)i;
                Psi.proxy.sparkleFX(world, x, y, z, red, green, blue, 0.0f, 0.0f, 0.0f, 1.0f, this.time);
            }
        });
        return true;
    }
}

