/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.common.item.ItemCAD;

public class ColorizerChangeRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<ColorizerChangeRecipe> SERIALIZER = new SpecialRecipeSerializer(ColorizerChangeRecipe::new);

    public ColorizerChangeRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        boolean foundColorizer = false;
        boolean foundCAD = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICAD) {
                if (foundCAD) {
                    return false;
                }
                foundCAD = true;
                continue;
            }
            if (stack.func_77973_b() instanceof ICADColorizer) {
                if (foundColorizer) {
                    return false;
                }
                foundColorizer = true;
                continue;
            }
            return false;
        }
        return foundColorizer && foundCAD;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack colorizer = ItemStack.field_190927_a;
        ItemStack cad = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ICADColorizer) {
                colorizer = stack;
                continue;
            }
            cad = stack;
        }
        if (cad.func_190926_b() || colorizer.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = cad.func_77946_l();
        ItemCAD.setComponent(copy, colorizer);
        return copy;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        int dyeIndex = -1;
        ItemStack cad = ItemStack.field_190927_a;
        for (int i = 0; i < ret.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ICAD) {
                cad = stack;
                continue;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ICADColorizer) {
                dyeIndex = i;
            }
            ret.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        if (!cad.func_190926_b() && dyeIndex != -1) {
            ICAD icad = (ICAD)cad.func_77973_b();
            ret.set(dyeIndex, (Object)icad.getComponentInSlot(cad, EnumCADComponent.DYE));
        }
        return ret;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }
}

