/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageLoopcastSync;

@Mod.EventBusSubscriber(modid="psi")
public class LoopcastTrackingHandler {
    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof PlayerEntity) {
            LoopcastTrackingHandler.syncDataFor((PlayerEntity)event.getTarget(), (ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.getPlayer(), (ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.getPlayer(), (ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        LoopcastTrackingHandler.syncDataFor(event.getPlayer(), (ServerPlayerEntity)event.getPlayer());
    }

    public static void syncDataFor(PlayerEntity player, ServerPlayerEntity receiver) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        MessageRegister.sendToPlayer(new MessageLoopcastSync(player.func_145782_y(), data.loopcasting, data.loopcastHand), (PlayerEntity)receiver);
    }

    public static void syncForTrackers(ServerPlayerEntity player) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((PlayerEntity)player);
        MessageRegister.HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageLoopcastSync(player.func_145782_y(), data.loopcasting, data.loopcastHand));
    }

    public static void syncForTrackersAndSelf(ServerPlayerEntity playerEntity) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((PlayerEntity)playerEntity);
        MessageLoopcastSync messageLoopcastSync = new MessageLoopcastSync(playerEntity.func_145782_y(), data.loopcasting, data.loopcastHand);
        MessageRegister.HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> playerEntity), (Object)messageLoopcastSync);
        MessageRegister.sendToPlayer(messageLoopcastSync, (PlayerEntity)playerEntity);
    }
}

