/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.machine;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.block.machine.BlockAlloyWire;
import com.bluepowermod.client.render.ICustomModelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockInsulatedAlloyWire
extends BlockAlloyWire
implements ICustomModelBlock {
    private final MinecraftColor color;
    public static final IntegerProperty STRAIGHT = IntegerProperty.func_177719_a((String)"straight", (int)0, (int)5);

    public BlockInsulatedAlloyWire(String type, MinecraftColor color) {
        super(type, Material.field_151576_e);
        this.color = color;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)CONNECTED_FRONT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_BACK, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)STRAIGHT, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("bluepower:wire." + type + "." + color.name().toLowerCase());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, CONNECTED_FRONT, CONNECTED_BACK, CONNECTED_LEFT, CONNECTED_RIGHT, STRAIGHT, POWERED});
    }

    public BlockState getStateForPlacement(BlockState state, Direction facing, BlockState state2, IWorld worldIn, BlockPos pos, BlockPos pos2, Hand hand) {
        Boolean connected_back = (Boolean)state.func_177229_b((IProperty)CONNECTED_BACK);
        Boolean connected_front = (Boolean)state.func_177229_b((IProperty)CONNECTED_FRONT);
        Boolean connected_left = (Boolean)state.func_177229_b((IProperty)CONNECTED_LEFT);
        Boolean connected_right = (Boolean)state.func_177229_b((IProperty)CONNECTED_RIGHT);
        int connections = 0;
        int straight = 1;
        for (Direction face : FACING.func_177700_c()) {
            switch (face) {
                case NORTH: {
                    connected_front = worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c().equals(this);
                    if (!connected_front.booleanValue()) break;
                    ++connections;
                    straight = 4;
                    break;
                }
                case SOUTH: {
                    connected_back = worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c().equals(this);
                    if (!connected_back.booleanValue()) break;
                    ++connections;
                    straight = 3;
                    break;
                }
                case WEST: {
                    connected_left = worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c().equals(this);
                    if (!connected_left.booleanValue()) break;
                    ++connections;
                    straight = 5;
                    break;
                }
                case EAST: {
                    connected_right = worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c().equals(this);
                    if (!connected_right.booleanValue()) break;
                    ++connections;
                    straight = 2;
                }
            }
        }
        if (connections > 1) {
            straight = 0;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(state, facing, state2, worldIn, pos, pos2, hand).func_206870_a((IProperty)CONNECTED_RIGHT, (Comparable)connected_right)).func_206870_a((IProperty)CONNECTED_LEFT, (Comparable)connected_left)).func_206870_a((IProperty)CONNECTED_FRONT, (Comparable)connected_front)).func_206870_a((IProperty)CONNECTED_BACK, (Comparable)connected_back)).func_206870_a((IProperty)STRAIGHT, (Comparable)Integer.valueOf(straight));
    }

    @Override
    public int getColor(IBlockReader world, BlockPos pos, int tintIndex) {
        return tintIndex == 1 ? this.color.getHex() : (tintIndex == 2 ? (RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex()) : -1);
    }

    @Override
    public int getColor(int tintIndex) {
        return tintIndex == 1 ? this.color.getHex() : (tintIndex == 2 ? (RedwireType.RED_ALLOY.getName().equals(this.type) ? MinecraftColor.RED.getHex() : MinecraftColor.BLUE.getHex()) : -1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initModel() {
    }
}

