/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import owmii.lib.energy.Energy;
import owmii.powah.block.Tier;
import owmii.powah.config.EnergyConfig;

public class PlayerTransmitterConfig
extends EnergyConfig {
    public final Map<Tier, Long> chargingSpeed = new HashMap<Tier, Long>();
    public final ForgeConfigSpec.LongValue starterChargingSpeed;
    public final ForgeConfigSpec.LongValue basicChargingSpeed;
    public final ForgeConfigSpec.LongValue hardenedChargingSpeed;
    public final ForgeConfigSpec.LongValue blazingChargingSpeed;
    public final ForgeConfigSpec.LongValue nioticChargingSpeed;
    public final ForgeConfigSpec.LongValue spiritedChargingSpeed;
    public final ForgeConfigSpec.LongValue nitroChargingSpeed;

    public PlayerTransmitterConfig(ForgeConfigSpec.Builder builder) {
        super(builder, new long[]{100000L, 1000000L, 3000000L, 5000000L, 10000000L, 15000000L, 40000000L}, new long[]{500L, 2500L, 8000L, 20000L, 50000L, 100000L, 400000L});
        builder.push("Charging_Speed");
        this.starterChargingSpeed = builder.defineInRange("starterChargingSpeed", 100L, Energy.MIN.longValue(), Energy.MAX.longValue());
        this.basicChargingSpeed = builder.defineInRange("basicChargingSpeed", 1000L, Energy.MIN.longValue(), Energy.MAX.longValue());
        this.hardenedChargingSpeed = builder.defineInRange("hardenedChargingSpeed", 3000L, Energy.MIN.longValue(), Energy.MAX.longValue());
        this.blazingChargingSpeed = builder.defineInRange("blazingChargingSpeed", 8000L, Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nioticChargingSpeed = builder.defineInRange("nioticChargingSpeed", 12000L, Energy.MIN.longValue(), Energy.MAX.longValue());
        this.spiritedChargingSpeed = builder.defineInRange("spiritedChargingSpeed", 20000L, Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nitroChargingSpeed = builder.defineInRange("nitroChargingSpeed", 50000L, Energy.MIN.longValue(), Energy.MAX.longValue());
        builder.pop();
    }

    @Override
    public void reload() {
        super.reload();
        this.chargingSpeed.put(Tier.STARTER, (Long)this.starterChargingSpeed.get());
        this.chargingSpeed.put(Tier.BASIC, (Long)this.basicChargingSpeed.get());
        this.chargingSpeed.put(Tier.HARDENED, (Long)this.hardenedChargingSpeed.get());
        this.chargingSpeed.put(Tier.BLAZING, (Long)this.blazingChargingSpeed.get());
        this.chargingSpeed.put(Tier.NIOTIC, (Long)this.nioticChargingSpeed.get());
        this.chargingSpeed.put(Tier.SPIRITED, (Long)this.spiritedChargingSpeed.get());
        this.chargingSpeed.put(Tier.NITRO, (Long)this.nitroChargingSpeed.get());
        this.chargingSpeed.put(Tier.CREATIVE, Energy.MAX);
    }

    public long getChargingSpeed(Tier variant) {
        if (this.chargingSpeed.containsKey((Object)variant)) {
            return this.chargingSpeed.get((Object)variant);
        }
        return 0L;
    }
}

