/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import owmii.lib.config.IEnergyConfig;
import owmii.lib.energy.Energy;
import owmii.powah.block.Tier;

public class EnergyConfig
implements IEnergyConfig<Tier> {
    public final Map<Tier, Long> capacities = new HashMap<Tier, Long>();
    public final Map<Tier, Long> transfer = new HashMap<Tier, Long>();
    public final ForgeConfigSpec.LongValue starterCap;
    public final ForgeConfigSpec.LongValue basicCap;
    public final ForgeConfigSpec.LongValue hardenedCap;
    public final ForgeConfigSpec.LongValue blazingCap;
    public final ForgeConfigSpec.LongValue nioticCap;
    public final ForgeConfigSpec.LongValue spiritedCap;
    public final ForgeConfigSpec.LongValue nitroCap;
    public final ForgeConfigSpec.LongValue starterTransfer;
    public final ForgeConfigSpec.LongValue basicTransfer;
    public final ForgeConfigSpec.LongValue hardenedTransfer;
    public final ForgeConfigSpec.LongValue blazingTransfer;
    public final ForgeConfigSpec.LongValue nioticTransfer;
    public final ForgeConfigSpec.LongValue spiritedTransfer;
    public final ForgeConfigSpec.LongValue nitroTransfer;

    public EnergyConfig(ForgeConfigSpec.Builder builder, long[] caps, long[] trs) {
        builder.push("Energy_Capacity");
        this.starterCap = builder.defineInRange("starterCap", caps[0], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.basicCap = builder.defineInRange("basicCap", caps[1], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.hardenedCap = builder.defineInRange("hardenedCap", caps[2], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.blazingCap = builder.defineInRange("blazingCap", caps[3], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nioticCap = builder.defineInRange("nioticCap", caps[4], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.spiritedCap = builder.defineInRange("spiritedCap", caps[5], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nitroCap = builder.defineInRange("nitroCap", caps[6], Energy.MIN.longValue(), Energy.MAX.longValue());
        builder.pop();
        builder.push("Energy_Transfer");
        this.starterTransfer = builder.defineInRange("starterTransfer", trs[0], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.basicTransfer = builder.defineInRange("basicTransfer", trs[1], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.hardenedTransfer = builder.defineInRange("hardenedTransfer", trs[2], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.blazingTransfer = builder.defineInRange("blazingTransfer", trs[3], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nioticTransfer = builder.defineInRange("nioticTransfer", trs[4], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.spiritedTransfer = builder.defineInRange("spiritedTransfer", trs[5], Energy.MIN.longValue(), Energy.MAX.longValue());
        this.nitroTransfer = builder.defineInRange("nitroTransfer", trs[6], Energy.MIN.longValue(), Energy.MAX.longValue());
        builder.pop();
    }

    public void reload() {
        this.capacities.put(Tier.STARTER, (Long)this.starterCap.get());
        this.capacities.put(Tier.BASIC, (Long)this.basicCap.get());
        this.capacities.put(Tier.HARDENED, (Long)this.hardenedCap.get());
        this.capacities.put(Tier.BLAZING, (Long)this.blazingCap.get());
        this.capacities.put(Tier.NIOTIC, (Long)this.nioticCap.get());
        this.capacities.put(Tier.SPIRITED, (Long)this.spiritedCap.get());
        this.capacities.put(Tier.NITRO, (Long)this.nitroCap.get());
        this.capacities.put(Tier.CREATIVE, Energy.MAX);
        this.transfer.put(Tier.STARTER, (Long)this.starterTransfer.get());
        this.transfer.put(Tier.BASIC, (Long)this.basicTransfer.get());
        this.transfer.put(Tier.HARDENED, (Long)this.hardenedTransfer.get());
        this.transfer.put(Tier.BLAZING, (Long)this.blazingTransfer.get());
        this.transfer.put(Tier.NIOTIC, (Long)this.nioticTransfer.get());
        this.transfer.put(Tier.SPIRITED, (Long)this.spiritedTransfer.get());
        this.transfer.put(Tier.NITRO, (Long)this.nitroTransfer.get());
        this.transfer.put(Tier.CREATIVE, Energy.MAX);
    }

    public long getCapacity(Tier variant) {
        if (this.capacities.containsKey((Object)variant)) {
            return this.capacities.get((Object)variant);
        }
        return 0L;
    }

    public long getTransfer(Tier variant) {
        if (this.transfer.containsKey((Object)variant)) {
            return this.transfer.get((Object)variant);
        }
        return 0L;
    }
}

