/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import owmii.lib.client.screen.EnergyScreen;
import owmii.lib.client.util.Draw;
import owmii.lib.inventory.EnergyContainerBase;
import owmii.lib.util.Ticker;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.inventory.ReactorContainer;

@OnlyIn(value=Dist.CLIENT)
public class ReactorScreen
extends EnergyScreen<ReactorTile, ReactorContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("powah", "textures/gui/container/reactor.png");
    private static final ResourceLocation GUI_MACHINE = new ResourceLocation("lollipop", "textures/gui/container/blank_right_gauge.png");

    public ReactorScreen(ReactorContainer container, PlayerInventory playerInventory, ITextComponent name) {
        super((EnergyContainerBase)container, playerInventory, name);
    }

    protected void configButtons(int x, int y) {
        super.configButtons(x - 19, y);
    }

    protected void drawBackground(float partialTicks, int mouseX, int mouseY) {
        FluidStack fluidStack;
        FluidAttributes fa;
        ResourceLocation still;
        super.drawBackground(partialTicks, mouseX, mouseY);
        ReactorTile reactor = (ReactorTile)((ReactorContainer)this.field_147002_h).getTile();
        FluidTank tank = ((ReactorTile)this.te).getTank();
        if (!tank.isEmpty() && (still = (fa = (fluidStack = tank.getFluid()).getFluid().getAttributes()).getStillTexture(fluidStack)) != null) {
            int color = fa.getColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.color3f((float)red, (float)green, (float)blue);
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.mc.func_228015_a_(PlayerContainer.field_226615_c_).apply(still);
            this.bindTexture(PlayerContainer.field_226615_c_);
            Draw.gaugeV((TextureAtlasSprite)sprite, (int)(this.x + 162), (int)(this.y + 4), (int)10, (int)64, (int)tank.getCapacity(), (int)tank.getFluidAmount());
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (!this.configVisible) {
            Ticker temp;
            Ticker solidCoolant;
            Ticker redstone;
            Ticker carbon;
            this.bindTexture(GUI_TEXTURE);
            Ticker fuel = reactor.getFuel();
            if (!fuel.isEmpty()) {
                Draw.gaugeV((int)(this.x + 96), (int)(this.y + 12), (int)5, (int)48, (int)176, (int)16, (double)fuel.getMax(), (double)fuel.getTicks());
            }
            if (!(carbon = reactor.getCarbon()).isEmpty()) {
                Draw.gaugeV((int)(this.x + 43), (int)(this.y + 5), (int)5, (int)16, (int)176, (int)0, (double)carbon.getMax(), (double)carbon.getTicks());
            }
            if (!(redstone = reactor.getRedstone()).isEmpty()) {
                Draw.gaugeV((int)(this.x + 43), (int)(this.y + 51), (int)5, (int)16, (int)181, (int)0, (double)redstone.getMax(), (double)redstone.getTicks());
            }
            if (!(solidCoolant = reactor.getSolidCoolant()).isEmpty()) {
                Draw.gaugeV((int)(this.x + 147), (int)(this.y + 51), (int)5, (int)16, (int)186, (int)0, (double)solidCoolant.getMax(), (double)solidCoolant.getTicks());
            }
            if (!(temp = reactor.getTemp()).isEmpty()) {
                Draw.gaugeV((int)(this.x + 107), (int)(this.y + 27), (int)4, (int)18, (int)191, (int)0, (double)temp.getMax(), (double)temp.getTicks());
            }
        }
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        FluidTank tank = ((ReactorTile)this.te).getTank();
        if (this.isMouseOver(mouseX - 161, mouseY - 3, 12, 66)) {
            ArrayList<String> list = new ArrayList<String>();
            if (!tank.isEmpty()) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.coolant", (Object[])new Object[]{TextFormatting.AQUA + tank.getFluid().getDisplayName().getString()}));
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.fluid.stored", (Object[])new Object[]{"" + TextFormatting.DARK_GRAY + tank.getFluidAmount(), tank.getCapacity()}));
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.temperature", (Object[])new Object[]{"" + TextFormatting.AQUA + PowahAPI.getCoolant(tank.getFluid().getFluid()), 100}));
            } else {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.coolant", (Object[])new Object[]{TextFormatting.DARK_GRAY + "----"}));
            }
            this.renderTooltip(list, mouseX, mouseY);
        }
        if (!this.configVisible) {
            ArrayList<String> list;
            Ticker temp = ((ReactorTile)this.te).getTemp();
            if (this.isMouseOver(mouseX - 106, mouseY - 26, 6, 20)) {
                ArrayList<String> list2 = new ArrayList<String>();
                list2.add(TextFormatting.GRAY + String.format("%.1f", temp.getTicks()) + " C");
                this.renderTooltip(list2, mouseX, mouseY);
            }
            Ticker fuel = ((ReactorTile)this.te).getFuel();
            if (this.isMouseOver(mouseX - 95, mouseY - 11, 7, 50)) {
                boolean b = fuel.isEmpty();
                list = new ArrayList<String>();
                list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"item.powah.uraninite", (Object[])new Object[0]));
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.fluid.stored", (Object[])new Object[]{TextFormatting.DARK_GRAY + String.format("%.0f", fuel.getTicks()), String.format("%.0f", fuel.getMax())}));
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.fluid.using.per.tick", (Object[])new Object[]{TextFormatting.GREEN + String.format("%.4f", ((ReactorTile)this.te).calcConsumption())}));
                this.renderTooltip(list, mouseX, mouseY);
            }
            Ticker carbon = ((ReactorTile)this.te).getCarbon();
            if (this.isMouseOver(mouseX - 42, mouseY - 4, 7, 18)) {
                list = new ArrayList();
                boolean b = carbon.isEmpty();
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.carbon", (Object[])new Object[0]));
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.fluid.stored", (Object[])new Object[]{TextFormatting.DARK_GRAY + String.format("%.1f", carbon.getTicks()), String.format("%.1f", carbon.getMax())}));
                list.add("");
                list.add(TextFormatting.DARK_GRAY + "+" + I18n.func_135052_a((String)"enchantment.minecraft.efficiency", (Object[])new Object[0]));
                list.add(TextFormatting.DARK_RED + (b ? "+0 C" : "+180 C"));
                this.renderTooltip(list, mouseX, mouseY);
            }
            Ticker redstone = ((ReactorTile)this.te).getRedstone();
            if (this.isMouseOver(mouseX - 42, mouseY - 50, 7, 18)) {
                ArrayList<String> list3 = new ArrayList<String>();
                boolean b = redstone.isEmpty();
                list3.add(TextFormatting.RED + I18n.func_135052_a((String)"info.powah.redstone", (Object[])new Object[0]));
                list3.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.fluid.stored", (Object[])new Object[]{TextFormatting.DARK_GRAY + String.format("%.1f", redstone.getTicks()), String.format("%.1f", redstone.getMax())}));
                list3.add("");
                list3.add(TextFormatting.DARK_GRAY + "+" + I18n.func_135052_a((String)"info.powah.production", (Object[])new Object[0]));
                list3.add(TextFormatting.DARK_GRAY + "+" + I18n.func_135052_a((String)"info.powah.fuel.consumption", (Object[])new Object[0]));
                list3.add(TextFormatting.DARK_RED + (b ? "+0 C" : "+120 C"));
                this.renderTooltip(list3, mouseX, mouseY);
            }
            Ticker solidCoolant = ((ReactorTile)this.te).getSolidCoolant();
            if (this.isMouseOver(mouseX - 146, mouseY - 50, 7, 18)) {
                ArrayList<String> list4 = new ArrayList<String>();
                list4.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.solid.coolant", (Object[])new Object[0]));
                list4.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.lollipop.fluid.stored", (Object[])new Object[]{TextFormatting.DARK_GRAY + String.format("%.1f", solidCoolant.getTicks()), String.format("%.1f", solidCoolant.getMax())}));
                list4.add("" + TextFormatting.AQUA + ((ReactorTile)this.te).getSolidCoolantTemp() + " C");
                this.renderTooltip(list4, mouseX, mouseY);
            }
        }
    }

    protected ResourceLocation getMachineBackGround() {
        return GUI_TEXTURE;
    }

    protected ResourceLocation getConfigBackGround() {
        return GUI_MACHINE;
    }
}

