/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energyhopper;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import owmii.lib.block.TileBase;
import owmii.lib.util.IVariant;
import owmii.lib.util.Text;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.energyhopper.EnergyHopperBlock;

public class EnergyHopperTile
extends TileBase.EnergyStorage<Tier, EnergyHopperBlock> {
    public EnergyHopperTile(Tier variant) {
        super(ITiles.ENERGY_HOPPER, (IVariant)variant);
    }

    public EnergyHopperTile() {
        this(Tier.STARTER);
    }

    protected boolean postTicks(World world) {
        int[] extracted = new int[]{0};
        if (this.doWorkingTicks(world)) {
            Direction side = (Direction)this.func_195044_w().func_177229_b((IProperty)EnergyHopperBlock.FACING);
            TileEntity tile = this.getTileEntity(this.field_174879_c.func_177972_a(side));
            long charging = ((EnergyHopperBlock)this.getBlock()).getChargingSpeed();
            if (tile instanceof IInventory) {
                IInventory inventory = (IInventory)tile;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack.func_190916_E() != 1) continue;
                    extracted[0] = (int)((long)extracted[0] + this.chargeItem(stack, charging));
                }
            } else if (tile != null) {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                    for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                        ItemStack stack = iItemHandler.getStackInSlot(i);
                        if (stack.func_190916_E() != 1) continue;
                        extracted[0] = (int)((long)extracted[0] + this.chargeItem(stack, charging));
                    }
                });
            }
        }
        return extracted[0] > 0;
    }

    public boolean keepEnergy() {
        return true;
    }

    public void getListedEnergyInfo(List<String> list) {
        super.getListedEnergyInfo(list);
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.powah.charging.speed", (Object[])new Object[]{TextFormatting.DARK_GRAY + Text.numFormat((long)((EnergyHopperBlock)this.getBlock()).getChargingSpeed())}));
    }
}

