/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Tree<NT extends Comparable<NT>, LT extends Comparable<LT>> {
    private InnerNode<NT, LT> root;

    public Tree(NT root) {
        this.root = new InnerNode(root, null, 0);
    }

    public Stream<LT> leafStream() {
        Stream.Builder b = Stream.builder();
        this.root.stream(b, true);
        return b.build().map(AbstractNode::getLeafData);
    }

    public InnerNode<NT, LT> getRoot() {
        return this.root;
    }

    public Stream<AbstractNode<NT, LT>> fullStream() {
        Stream.Builder b = Stream.builder();
        this.root.stream(b, false);
        return b.build();
    }

    public void sortAll() {
        this.root.sortChildren();
    }

    public static class Leaf<NT extends Comparable<NT>, LT extends Comparable<LT>>
    extends AbstractNode<NT, LT> {
        LT data;

        Leaf(LT data, @Nullable InnerNode<NT, LT> superNode, int weight) {
            super(superNode, weight);
            this.data = data;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public LT getLeafData() {
            return this.data;
        }

        @Override
        protected void stream(Stream.Builder<AbstractNode<NT, LT>> builder, boolean leafStream) {
            builder.accept(this);
        }
    }

    public static class InnerNode<NT extends Comparable<NT>, LT extends Comparable<LT>>
    extends AbstractNode<NT, LT> {
        private final List<AbstractNode<NT, LT>> children = new ArrayList<AbstractNode<NT, LT>>();
        private Comparator<AbstractNode<NT, LT>> compare = (n1, n2) -> {
            if (n1.isLeaf() && !n2.isLeaf()) {
                return 1;
            }
            if (!n1.isLeaf() && n2.isLeaf()) {
                return -1;
            }
            if (n1.weight != n2.weight) {
                return Integer.compare(n1.weight, n2.weight);
            }
            if (n1.isLeaf()) {
                return n1.getLeafData().compareTo(n2.getLeafData());
            }
            return n1.getNodeData().compareTo(n2.getNodeData());
        };
        private NT data;

        public InnerNode(NT data, @Nullable InnerNode<NT, LT> superNode, int weight) {
            super(superNode, weight);
            this.data = data;
        }

        @Override
        public List<AbstractNode<NT, LT>> getChildren() {
            return this.children;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public NT getNodeData() {
            return this.data;
        }

        public InnerNode<NT, LT> addNewSubnode(NT data, int weight) {
            InnerNode<NT, LT> newNode = new InnerNode<NT, LT>(data, this, weight);
            this.children.add(newNode);
            return newNode;
        }

        public InnerNode<NT, LT> getOrCreateSubnode(NT data) {
            return this.getOrCreateSubnode(data, 0);
        }

        public InnerNode<NT, LT> getOrCreateSubnode(NT data, int weight) {
            for (AbstractNode<NT, LT> child : this.children) {
                if (child.isLeaf() || !data.equals(child.getNodeData())) continue;
                return (InnerNode)child;
            }
            return this.addNewSubnode(data, weight);
        }

        public void addNewLeaf(LT data) {
            this.addNewLeaf(data, 0);
        }

        public void addNewLeaf(LT data, int weight) {
            Leaf newLeaf = new Leaf(data, this, weight);
            this.children.add(newLeaf);
        }

        public void sortChildren() {
            this.children.sort(this.compare);
            for (AbstractNode<NT, LT> c : this.children) {
                if (!(c instanceof InnerNode)) continue;
                ((InnerNode)c).sortChildren();
            }
        }

        @Override
        protected void stream(Stream.Builder<AbstractNode<NT, LT>> builder, boolean leafStream) {
            if (!leafStream) {
                builder.accept(this);
            }
            for (AbstractNode<NT, LT> child : this.getChildren()) {
                child.stream(builder, leafStream);
            }
        }
    }

    public static abstract class AbstractNode<NT extends Comparable<NT>, LT extends Comparable<LT>> {
        @Nullable
        private InnerNode<NT, LT> superNode;
        final int weight;

        AbstractNode(@Nullable InnerNode<NT, LT> superNode, int weight) {
            this.superNode = superNode;
            this.weight = weight;
        }

        public abstract boolean isLeaf();

        public NT getNodeData() {
            return null;
        }

        public LT getLeafData() {
            return null;
        }

        public List<AbstractNode<NT, LT>> getChildren() {
            return ImmutableList.of();
        }

        @Nullable
        public InnerNode<NT, LT> getSuperNode() {
            return this.superNode;
        }

        protected abstract void stream(Stream.Builder<AbstractNode<NT, LT>> var1, boolean var2);
    }
}

