/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.entities.RevolvershotFlareEntity;
import blusunrize.immersiveengineering.common.entities.RevolvershotHomingEntity;
import blusunrize.immersiveengineering.common.entities.WolfpackShotEntity;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.LingeringPotionItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SplashPotionItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BulletItem
extends IEBaseItem
implements IEItemInterfaces.ITextureOverride {
    public static final ResourceLocation CASULL = new ResourceLocation("immersiveengineering", "casull");
    public static final ResourceLocation ARMOR_PIERCING = new ResourceLocation("immersiveengineering", "armor_piercing");
    public static final ResourceLocation BUCKSHOT = new ResourceLocation("immersiveengineering", "buckshot");
    public static final ResourceLocation HIGH_EXPLOSIVE = new ResourceLocation("immersiveengineering", "he");
    public static final ResourceLocation SILVER = new ResourceLocation("immersiveengineering", "silver");
    public static final ResourceLocation DRAGONS_BREATH = new ResourceLocation("immersiveengineering", "dragons_breath");
    public static final ResourceLocation POTION = new ResourceLocation("immersiveengineering", "potion");
    public static final ResourceLocation FLARE = new ResourceLocation("immersiveengineering", "flare");
    public static final ResourceLocation FIREWORK = new ResourceLocation("immersiveengineering", "firework");
    public static final ResourceLocation WOLFPACK = new ResourceLocation("immersiveengineering", "wolfpack");
    public static final ResourceLocation WOLFPACK_PART = new ResourceLocation("immersiveengineering", "wolfpack_part");
    private final BulletHandler.IBullet type;

    public BulletItem(BulletHandler.IBullet type) {
        super(BulletItem.nameFor(type), new Item.Properties());
        this.type = type;
    }

    private static String nameFor(BulletHandler.IBullet bullet) {
        ResourceLocation name = BulletHandler.findRegistryName(bullet);
        if (name.func_110624_b().equals("immersiveengineering")) {
            return name.func_110623_a();
        }
        return name.func_110624_b() + "_" + name.func_110623_a();
    }

    public static void initBullets() {
        BulletHandler.registerBullet(CASULL, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causeCasullDamage((RevolvershotEntity)projectile, shooter), ((Double)IEConfig.TOOLS.bulletDamage_Casull.get()).floatValue(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing), new ResourceLocation("immersiveengineering:item/bullet_casull")));
        BulletHandler.registerBullet(ARMOR_PIERCING, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causePiercingDamage((RevolvershotEntity)projectile, shooter), ((Double)IEConfig.TOOLS.bulletDamage_AP.get()).floatValue(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing), new ResourceLocation("immersiveengineering:item/bullet_armor_piercing")));
        BulletHandler.registerBullet(BUCKSHOT, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causeBuckshotDamage((RevolvershotEntity)projectile, shooter), ((Double)IEConfig.TOOLS.bulletDamage_Buck.get()).floatValue(), true, false, () -> BulletHandler.emptyShell, new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_buckshot")}){

            @Override
            public int getProjectileCount(PlayerEntity shooter) {
                return 10;
            }
        });
        BulletHandler.registerBullet(HIGH_EXPLOSIVE, new BulletHandler.DamagingBullet(null, 0.0f, () -> BulletHandler.emptyCasing, new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_he")}){

            @Override
            public void onHitTarget(World world, RayTraceResult target, UUID shooterId, Entity projectile, boolean headshot) {
                PlayerEntity shooter = null;
                if (shooterId != null) {
                    shooter = world.func_217371_b(shooterId);
                }
                world.func_217385_a((Entity)shooter, projectile.func_226277_ct_(), projectile.func_226278_cu_(), projectile.func_226281_cx_(), 2.0f, Explosion.Mode.NONE);
            }

            @Override
            public Entity getProjectile(@Nullable PlayerEntity shooter, ItemStack cartridge, Entity projectile, boolean charged) {
                if (projectile instanceof RevolvershotEntity) {
                    ((RevolvershotEntity)projectile).setGravity(0.05f);
                    ((RevolvershotEntity)projectile).setMovementDecay(0.9f);
                }
                return projectile;
            }

            @Override
            public SoundEvent getSound() {
                return IESounds.revolverFireThump;
            }
        });
        BulletHandler.registerBullet(SILVER, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causeSilverDamage((RevolvershotEntity)projectile, shooter), ((Double)IEConfig.TOOLS.bulletDamage_Silver.get()).floatValue(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing), new ResourceLocation("immersiveengineering:item/bullet_silver")));
        BulletHandler.registerBullet(DRAGONS_BREATH, new BulletHandler.DamagingBullet((projectile, shooter, hit) -> IEDamageSources.causeDragonsbreathDamage((RevolvershotEntity)projectile, shooter), ((Double)IEConfig.TOOLS.bulletDamage_Dragon.get()).floatValue(), true, true, () -> BulletHandler.emptyShell, new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_dragons_breath")}){

            @Override
            public int getProjectileCount(PlayerEntity shooter) {
                return 30;
            }

            @Override
            public Entity getProjectile(PlayerEntity shooter, ItemStack cartridge, Entity projectile, boolean electro) {
                ((RevolvershotEntity)projectile).setTickLimit(10);
                projectile.func_70015_d(3);
                return projectile;
            }
        });
        BulletHandler.registerBullet(POTION, new PotionBullet());
        BulletHandler.registerBullet(FLARE, new FlareBullet());
        BulletHandler.registerBullet(FIREWORK, new FireworkBullet());
        BulletHandler.registerBullet(WOLFPACK, new WolfpackBullet());
        BulletHandler.registerBullet(WOLFPACK_PART, new WolfpackPartBullet());
    }

    @OnlyIn(value=Dist.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.itemFont;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        this.type.addTooltip(stack, world, list, flag);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        String s = "item.immersiveengineering.bullet.";
        String key = this.getRegistryName().func_110623_a();
        s = s + key;
        s = this.type.getTranslationKey(stack, s);
        return new TranslationTextComponent(s, new Object[0]);
    }

    @Override
    public boolean hasCustomItemColours() {
        return true;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        return this.type.getColour(stack, pass);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getModelCacheKey(ItemStack stack) {
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ResourceLocation> getTextures(ItemStack stack, String key) {
        return ImmutableList.copyOf((Object[])this.type.getTextures());
    }

    public BulletHandler.IBullet getType() {
        return this.type;
    }

    public static class WolfpackPartBullet
    extends BulletHandler.DamagingBullet {
        public WolfpackPartBullet() {
            super((Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causeWolfpackDamage((RevolvershotEntity)projectile, shooter), ((Double)IEConfig.TOOLS.bulletDamage_WolfpackPart.get()).floatValue(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing), new ResourceLocation("immersiveengineering:item/bullet_wolfpack"));
        }

        @Override
        public boolean isProperCartridge() {
            return false;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class WolfpackBullet
    extends BulletHandler.DamagingBullet {
        public WolfpackBullet() {
            super((Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causeWolfpackDamage((RevolvershotEntity)projectile, shooter), ((Double)IEConfig.TOOLS.bulletDamage_Wolfpack.get()).floatValue(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyShell), new ResourceLocation("immersiveengineering:item/bullet_wolfpack"));
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, UUID shooter, Entity projectile, boolean headshot) {
            super.onHitTarget(world, target, shooter, projectile, headshot);
            Vec3d v = projectile.func_213322_ci().func_186678_a(-1.0);
            int split = 6;
            for (int i = 0; i < split; ++i) {
                EntityRayTraceResult eTarget;
                float angle = (float)i * (360.0f / (float)split);
                Matrix4 matrix = new Matrix4();
                matrix.rotate(angle, v.field_72450_a, v.field_72448_b, v.field_72449_c);
                Vec3d vecDir = new Vec3d(0.0, 1.0, 0.0);
                vecDir = matrix.apply(vecDir);
                WolfpackShotEntity bullet = shooter != null ? new WolfpackShotEntity(world, (LivingEntity)world.func_217371_b(shooter), vecDir.field_72450_a * 1.5, vecDir.field_72448_b * 1.5, vecDir.field_72449_c * 1.5, this) : new WolfpackShotEntity(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this);
                if (target instanceof EntityRayTraceResult && (eTarget = (EntityRayTraceResult)target).func_216348_a() instanceof LivingEntity) {
                    bullet.targetOverride = (LivingEntity)eTarget.func_216348_a();
                }
                bullet.func_70107_b(target.func_216347_e().field_72450_a + vecDir.field_72450_a, target.func_216347_e().field_72448_b + vecDir.field_72448_b, target.func_216347_e().field_72449_c + vecDir.field_72449_c);
                bullet.func_213317_d(vecDir.func_186678_a(0.375));
                world.func_217376_c((Entity)bullet);
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class HomingBullet
    extends BulletHandler.DamagingBullet {
        public HomingBullet(float damage, ResourceLocation ... textures) {
            super((Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causeHomingDamage((RevolvershotEntity)projectile, shooter), damage, (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing), textures);
        }

        @Override
        public Entity getProjectile(PlayerEntity shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            RevolvershotHomingEntity shot = shooter != null ? new RevolvershotHomingEntity(projectile.field_70170_p, (LivingEntity)shooter, projectile.func_213322_ci().field_72450_a * 1.5, projectile.func_213322_ci().field_72448_b * 1.5, projectile.func_213322_ci().field_72449_c * 1.5, this) : new RevolvershotHomingEntity(projectile.field_70170_p, projectile.func_226277_ct_(), projectile.func_226278_cu_(), projectile.func_226281_cx_(), 0.0, 0.0, 0.0, this);
            shot.func_213317_d(projectile.func_213322_ci());
            shot.bulletElectro = electro;
            return shot;
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }
    }

    public static class FireworkBullet
    implements BulletHandler.IBullet {
        static ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_firework")};

        @Override
        public Entity getProjectile(PlayerEntity shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            ItemStack fireworkStack = new ItemStack((IItemProvider)Items.field_196152_dE);
            fireworkStack.func_77982_d(cartridge.func_77942_o() ? cartridge.func_77978_p().func_74737_b() : null);
            FireworkRocketEntity firework = new FireworkRocketEntity(projectile.field_70170_p, fireworkStack, shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() - (double)0.15f, shooter.func_226281_cx_(), true);
            Vec3d vector = projectile.func_213322_ci();
            firework.func_70186_c(vector.func_82615_a(), vector.func_82617_b(), vector.func_82616_c(), 1.6f, 1.0f);
            return firework;
        }

        @Override
        public SoundEvent getSound() {
            return IESounds.revolverFireThump;
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, UUID shooter, Entity projectile, boolean headshot) {
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return BulletHandler.emptyShell;
        }

        @Override
        public ResourceLocation[] getTextures() {
            return textures;
        }

        @Override
        public void addTooltip(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
            Items.field_196152_dE.func_77624_a(stack, world, list, flag);
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            return -1;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }
    }

    public static class FlareBullet
    implements BulletHandler.IBullet {
        static ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("immersiveengineering:item/bullet_flare"), new ResourceLocation("immersiveengineering:item/bullet_flare_layer")};

        @Override
        public Entity getProjectile(PlayerEntity shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            RevolvershotFlareEntity flare = shooter != null ? new RevolvershotFlareEntity(projectile.field_70170_p, (LivingEntity)shooter, projectile.func_213322_ci().field_72450_a * 1.5, projectile.func_213322_ci().field_72448_b * 1.5, projectile.func_213322_ci().field_72449_c * 1.5, this, cartridge) : new RevolvershotFlareEntity(projectile.field_70170_p, projectile.func_226277_ct_(), projectile.func_226278_cu_(), projectile.func_226281_cx_(), 0.0, 0.0, 0.0, this);
            flare.func_213317_d(projectile.func_213322_ci());
            flare.bulletElectro = electro;
            flare.colour = this.getColour(cartridge, 1);
            flare.setColourSynced();
            return flare;
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, UUID shooter, Entity projectile, boolean headshot) {
        }

        @Override
        public ItemStack getCasing(ItemStack stack) {
            return BulletHandler.emptyShell;
        }

        @Override
        public ResourceLocation[] getTextures() {
            return textures;
        }

        @Override
        public void addTooltip(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
            if (stack.func_77973_b() instanceof IEItemInterfaces.IColouredItem) {
                String hexCol = Integer.toHexString(((IEItemInterfaces.IColouredItem)stack.func_77973_b()).getColourForIEItem(stack, 1));
                list.add((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.bullet.flareColour", new Object[]{"<hexcol=" + hexCol + ":#" + hexCol + ">"}));
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            if (layer != 1) {
                return -1;
            }
            return ItemNBTHelper.hasKey(stack, "flareColour") ? ItemNBTHelper.getInt(stack, "flareColour") : 13381126;
        }

        @Override
        public boolean isValidForTurret() {
            return true;
        }
    }

    public static class PotionBullet
    extends BulletHandler.DamagingBullet {
        public PotionBullet() {
            super((Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causePotionDamage((RevolvershotEntity)projectile, shooter), ((Double)IEConfig.TOOLS.bulletDamage_Potion.get()).floatValue(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyCasing), new ResourceLocation("immersiveengineering:item/bullet_potion"), new ResourceLocation("immersiveengineering:item/bullet_potion_layer"));
        }

        @Override
        public String getTranslationKey(ItemStack cartridge, String baseName) {
            ItemStack pot = ItemNBTHelper.getItemStack(cartridge, "potion");
            if (!pot.func_190926_b()) {
                if (pot.func_77973_b() instanceof LingeringPotionItem) {
                    baseName = baseName + ".linger";
                } else if (pot.func_77973_b() instanceof SplashPotionItem) {
                    baseName = baseName + ".splash";
                }
            }
            return baseName;
        }

        @Override
        public Entity getProjectile(PlayerEntity shooter, ItemStack cartridge, Entity projectile, boolean electro) {
            ((RevolvershotEntity)projectile).bulletPotion = ItemNBTHelper.getItemStack(cartridge, "potion");
            return projectile;
        }

        @Override
        public void onHitTarget(World world, RayTraceResult target, UUID shooter, Entity projectile, boolean headshot) {
            super.onHitTarget(world, target, shooter, projectile, headshot);
            RevolvershotEntity bullet = (RevolvershotEntity)projectile;
            if (!bullet.bulletPotion.func_190926_b() && bullet.bulletPotion.func_77942_o()) {
                Potion potionType = PotionUtils.func_185191_c((ItemStack)bullet.bulletPotion);
                List effects = PotionUtils.func_185189_a((ItemStack)bullet.bulletPotion);
                if (effects != null) {
                    if (bullet.bulletPotion.func_77973_b() instanceof LingeringPotionItem) {
                        AreaEffectCloudEntity entityareaeffectcloud = new AreaEffectCloudEntity(bullet.field_70170_p, bullet.func_226277_ct_(), bullet.func_226278_cu_(), bullet.func_226281_cx_());
                        entityareaeffectcloud.func_184481_a((LivingEntity)world.func_217371_b(shooter));
                        entityareaeffectcloud.func_184483_a(3.0f);
                        entityareaeffectcloud.func_184495_b(-0.5f);
                        entityareaeffectcloud.func_184485_d(10);
                        entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
                        entityareaeffectcloud.func_184484_a(potionType);
                        for (EffectInstance potioneffect : effects) {
                            entityareaeffectcloud.func_184496_a(new EffectInstance(potioneffect.func_188419_a(), potioneffect.func_76459_b(), potioneffect.func_76458_c()));
                        }
                        bullet.field_70170_p.func_217376_c((Entity)entityareaeffectcloud);
                    } else if (bullet.bulletPotion.func_77973_b() instanceof SplashPotionItem) {
                        List livingEntities = bullet.field_70170_p.func_217357_a(LivingEntity.class, bullet.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0));
                        if (livingEntities != null && !livingEntities.isEmpty()) {
                            for (LivingEntity living : livingEntities) {
                                double dist;
                                if (!living.func_184603_cC() || !((dist = bullet.func_70068_e((Entity)living)) < 16.0)) continue;
                                double dist2 = 1.0 - Math.sqrt(dist) / 4.0;
                                if (living == ((EntityRayTraceResult)target).func_216348_a()) {
                                    dist2 = 1.0;
                                }
                                for (EffectInstance p : effects) {
                                    if (p.func_188419_a().func_76403_b()) {
                                        p.func_188419_a().func_180793_a((Entity)bullet, (Entity)world.func_217371_b(shooter), living, p.func_76458_c(), dist2);
                                        continue;
                                    }
                                    int j = (int)(dist2 * (double)p.func_76459_b() + 0.5);
                                    if (j <= 20) continue;
                                    living.func_195064_c(new EffectInstance(p.func_188419_a(), j, p.func_76458_c()));
                                }
                            }
                        }
                    } else if (target instanceof EntityRayTraceResult && ((EntityRayTraceResult)target).func_216348_a() instanceof LivingEntity) {
                        for (EffectInstance p : effects) {
                            if (p.func_76459_b() < 1) {
                                p = new EffectInstance(p.func_188419_a(), 1);
                            }
                            ((LivingEntity)((EntityRayTraceResult)target).func_216348_a()).func_195064_c(p);
                        }
                    }
                }
                world.func_217379_c(2002, new BlockPos((Entity)bullet), PotionUtils.func_185183_a((Potion)potionType));
            }
        }

        @Override
        public void addTooltip(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
            ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
            if (!pot.func_190926_b() && pot.func_77973_b() instanceof PotionItem) {
                PotionUtils.func_185182_a((ItemStack)pot, list, (float)1.0f);
            }
        }

        @Override
        public int getColour(ItemStack stack, int layer) {
            if (layer == 1) {
                ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
                return pot.func_190926_b() ? -13083194 : PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)pot));
            }
            return -1;
        }
    }
}

