/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchTileEntity;
import blusunrize.immersiveengineering.common.gui.BlueprintInventory;
import blusunrize.immersiveengineering.common.gui.IEBaseContainer;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.ShaderInventory;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class ModWorkbenchContainer
extends IEBaseContainer<ModWorkbenchTileEntity> {
    private final World world;
    public PlayerInventory inventoryPlayer;
    private BlueprintInventory inventoryBPoutput;
    public ShaderInventory shaderInv;

    public ModWorkbenchContainer(int id, PlayerInventory inventoryPlayer, ModWorkbenchTileEntity tile) {
        super(inventoryPlayer, tile, id);
        this.world = tile.getWorldNonnull();
        this.inventoryPlayer = inventoryPlayer;
        this.rebindSlots();
    }

    private void bindPlayerInv(PlayerInventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 87 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 145));
        }
    }

    public void rebindSlots() {
        if (this.world.field_72995_K) {
            for (Slot slot : this.field_75151_b) {
                if (!(slot instanceof IESlot.Upgrades) || !ItemStack.func_77989_b((ItemStack)((IESlot.Upgrades)slot).upgradeableTool, (ItemStack)this.inv.func_70301_a(0))) continue;
                return;
            }
        }
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.func_75146_a(new IESlot.ModWorkbench(this, this.inv, 0, 24, 22, 1));
        this.slotCount = 1;
        ItemStack tool = this.func_75139_a(0).func_75211_c();
        if (tool.func_77973_b() instanceof IUpgradeableTool) {
            tool.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                if (handler instanceof IEItemStackHandler) {
                    ((IEItemStackHandler)((Object)handler)).setTile(this.tile);
                }
            });
            Slot[] slots = ((IUpgradeableTool)tool.func_77973_b()).getWorkbenchSlots(this, tool, () -> this.world, () -> this.inventoryPlayer.field_70458_d);
            if (slots != null) {
                for (Slot s : slots) {
                    this.func_75146_a(s);
                    ++this.slotCount;
                }
            }
            tool.getCapability(CapabilityShader.SHADER_CAPABILITY, null).ifPresent(wrapper -> {
                this.shaderInv = new ShaderInventory(this, (CapabilityShader.ShaderWrapper)wrapper);
                this.func_75146_a(new IESlot.Shader(this, this.shaderInv, 0, 130, 32, tool));
                ++this.slotCount;
                this.shaderInv.shader = wrapper.getShaderItem();
            });
        } else if (!(tool.func_77973_b() instanceof IConfigurableTool)) {
            boolean blueprint = false;
            if (tool.func_77973_b() instanceof EngineersBlueprintItem) {
                blueprint = true;
                BlueprintCraftingRecipe[] recipes = ((EngineersBlueprintItem)tool.func_77973_b()).getRecipes(tool);
                this.inventoryBPoutput = new BlueprintInventory(this, recipes);
                for (int i = 0; i < recipes.length; ++i) {
                    int y = 21 + (i < 9 ? i / 3 : -(i - 6) / 3) * 18;
                    this.func_75146_a(new IESlot.BlueprintOutput(this, this.inventoryBPoutput, this.inv, i, 118 + i % 3 * 18, y, recipes[i]));
                    ++this.slotCount;
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (blueprint) {
                    this.func_75146_a(new IESlot.BlueprintInput(this, this.inv, this.inventoryBPoutput, i + 1, i % 2 == 0 ? 74 : 92, 21 + i / 2 * 18));
                } else {
                    this.func_75146_a(new Slot(this.inv, i + 1, i % 2 == 0 ? 74 : 92, 21 + i / 2 * 18));
                }
                ++this.slotCount;
            }
        }
        this.bindPlayerInv(this.inventoryPlayer);
        ImmersiveEngineering.proxy.reInitGui();
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int slot) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slot < this.slotCount) {
                if (!this.func_75135_a(stackInSlot, this.slotCount, this.slotCount + 36, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!stackInSlot.func_190926_b()) {
                if (stackInSlot.func_77973_b() instanceof EngineersBlueprintItem) {
                    if (!this.func_75135_a(stackInSlot, 0, 1, true)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (stackInSlot.func_77973_b() instanceof IUpgradeableTool && ((IUpgradeableTool)stackInSlot.func_77973_b()).canModify(stackInSlot)) {
                    if (!this.func_75135_a(stackInSlot, 0, 1, true)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (stackInSlot.func_77973_b() instanceof IConfigurableTool && ((IConfigurableTool)stackInSlot.func_77973_b()).canConfigure(stackInSlot)) {
                    if (!this.func_75135_a(stackInSlot, 0, 1, true)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (this.slotCount > 1) {
                    boolean b = true;
                    for (int i = 1; i < this.slotCount; ++i) {
                        Slot s = (Slot)this.field_75151_b.get(i);
                        if (s == null || !s.func_75214_a(stackInSlot) || !this.func_75135_a(stackInSlot, i, i + 1, true)) continue;
                        b = false;
                        break;
                    }
                    if (b) {
                        return ItemStack.field_190927_a;
                    }
                }
            }
            if (stackInSlot.func_190916_E() == 0) {
                slotObject.func_75215_d(ItemStack.field_190927_a);
            } else {
                slotObject.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slotObject.func_190901_a(player, stack);
        }
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack func_184996_a(int id, int dragType, ClickType clickType, PlayerEntity player) {
        ItemStack ret = super.func_184996_a(id, dragType, clickType, player);
        ((ModWorkbenchTileEntity)this.tile).markContainingBlockForUpdate(null);
        if (!this.world.field_72995_K) {
            this.func_75142_b();
        }
        return ret;
    }
}

