/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.data;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.models.ModelConfigurableSides;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.client.models.connection.ConnectionLoader;
import blusunrize.immersiveengineering.client.models.connection.FeedthroughLoader;
import blusunrize.immersiveengineering.client.models.multilayer.MultiLayerLoader;
import blusunrize.immersiveengineering.common.blocks.EnumMetals;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.cloth.StripCurtainBlock;
import blusunrize.immersiveengineering.common.blocks.generic.PostBlock;
import blusunrize.immersiveengineering.common.blocks.generic.WallmountBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalLadderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.plant.EnumHempGrowth;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.data.DataGenUtils;
import blusunrize.immersiveengineering.common.data.IEDataGenerator;
import blusunrize.immersiveengineering.common.data.LoadedModels;
import blusunrize.immersiveengineering.common.data.models.LoadedModelBuilder;
import blusunrize.immersiveengineering.common.util.fluids.IEFluid;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;

public class BlockStates
extends BlockStateProvider {
    private static final ResourceLocation ALU_FENCE_TEXTURE = IEDataGenerator.rl("block/metal/storage_aluminum");
    private static final ResourceLocation STEEL_FENCE_TEXTURE = IEDataGenerator.rl("block/metal/storage_steel");
    private static final ResourceLocation TREATED_FENCE_TEXTURE = IEDataGenerator.rl("block/wooden_decoration/treated_wood_horizontal");
    private final ConfiguredModel EMPTY_MODEL;
    private final LoadedModels loadedModels;
    final Map<Block, ModelFile> itemModels = new HashMap<Block, ModelFile>();
    private final ExistingFileHelper existingFileHelper;
    public ModelFile blastFurnaceOff;
    public ModelFile blastFurnaceOn;
    public ModelFile cokeOvenOff;
    public ModelFile cokeOvenOn;
    public ModelFile alloySmelterOff;
    public ModelFile alloySmelterOn;
    Map<String, Map<Map<String, ResourceLocation>, Integer>> nameCache = new HashMap<String, Map<Map<String, ResourceLocation>, Integer>>();

    public BlockStates(DataGenerator gen, ExistingFileHelper exHelper, LoadedModels loaded) {
        super(gen, "immersiveengineering", exHelper);
        this.loadedModels = loaded;
        this.existingFileHelper = exHelper;
        this.EMPTY_MODEL = new ConfiguredModel((ModelFile)new ModelFile.ExistingModelFile(this.modLoc("block/ie_empty"), this.existingFileHelper));
    }

    private String name(Block b) {
        return b.getRegistryName().func_110623_a();
    }

    private void simpleBlockItem(Block b, ModelFile model) {
        this.simpleBlockItem(b, new ConfiguredModel(model));
    }

    private void simpleBlockItem(Block b, ConfiguredModel model) {
        this.simpleBlock(b, new ConfiguredModel[]{model});
        this.itemModels.put(b, model.model);
    }

    private void cubeSideVertical(Block b, ResourceLocation side, ResourceLocation vertical) {
        this.simpleBlockItem(b, (ModelFile)this.models().cubeBottomTop(this.name(b), side, vertical, vertical));
    }

    private void cubeAll(Block b, ResourceLocation texture) {
        this.simpleBlockItem(b, (ModelFile)this.models().cubeAll(this.name(b), texture));
    }

    private void scaffold(Block b, ResourceLocation others, ResourceLocation top) {
        this.simpleBlockItem(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(b), this.modLoc("block/ie_scaffolding"))).texture("side", others)).texture("bottom", others)).texture("top", top));
    }

    private void slabFor(Block b, ResourceLocation texture) {
        this.slabFor(b, texture, texture, texture);
    }

    private void slabFor(Block b, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        this.slab(IEBlocks.toSlab.get(b), side, top, bottom);
    }

    private void slab(SlabBlock b, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        ModelBuilder mainModel = this.models().slab(this.name((Block)b) + "_bottom", side, bottom, top);
        this.slabBlock(b, (ModelFile)mainModel, (ModelFile)this.models().slabTop(this.name((Block)b) + "_top", side, bottom, top), (ModelFile)this.models().cubeBottomTop(this.name((Block)b) + "_double", side, bottom, top));
        this.itemModels.put((Block)b, (ModelFile)mainModel);
    }

    private void stairs(StairsBlock b, ResourceLocation texture) {
        this.stairs(b, texture, texture, texture);
    }

    private void stairs(StairsBlock b, ResourceLocation side, ResourceLocation top, ResourceLocation bottom) {
        String baseName = this.name((Block)b);
        ModelBuilder stairs = this.models().stairs(baseName, side, bottom, top);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", side, bottom, top);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", side, bottom, top);
        this.stairsBlock(b, (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
        this.itemModels.put((Block)b, (ModelFile)stairs);
    }

    private ResourceLocation forgeLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    private ResourceLocation addModelsPrefix(ResourceLocation in) {
        return new ResourceLocation(in.func_110624_b(), "models/" + in.func_110623_a());
    }

    private void postBlock(Block b, ResourceLocation texture) {
        ResourceLocation model = IEDataGenerator.rl("block/wooden_device/wooden_post.obj.ie");
        this.assertModelExists(model);
        LoadedModelBuilder modelFile = (LoadedModelBuilder)((LoadedModelBuilder)this.loadedModels.withExistingParent(this.name(b), this.mcLoc("block")).loader(this.modLoc("ie_obj")).additional("model", this.addModelsPrefix(model)).additional("flip-v", true).texture("texture", texture)).texture("particle", texture);
        this.getVariantBuilder(b).partialState().with((IProperty)PostBlock.POST_SLAVE, (Comparable)Integer.valueOf(0)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelFile)});
        for (int i = 1; i <= 3; ++i) {
            this.getVariantBuilder(b).partialState().with((IProperty)PostBlock.POST_SLAVE, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent("empty_" + b.getRegistryName().func_110623_a(), this.EMPTY_MODEL.model.getLocation())).texture("particle", texture))});
        }
    }

    private ModelFile cubeTwo(String name, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation front) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("ie_two_cubed"))).texture("north", front)).texture("top", top)).texture("bottom", bottom)).texture("east", side)).texture("west", side)).texture("south", side);
    }

    private ModelFile cubeThree(String name, ResourceLocation def, ResourceLocation front) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("ie_three_cubed"))).texture("north", front)).texture("top", def)).texture("bottom", def)).texture("east", def)).texture("west", def)).texture("south", def);
    }

    private ModelFile obj(String loc) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj"));
        return this.obj(loc.substring(0, loc.length() - 4), this.modLoc(loc));
    }

    private ModelFile obj(String name, ResourceLocation model) {
        return this.obj(name, model, (Map<String, ResourceLocation>)ImmutableMap.of());
    }

    private ModelFile obj(String name, ResourceLocation model, Map<String, ResourceLocation> textures) {
        this.assertModelExists(model);
        LoadedModelBuilder ret = this.loadedModels.withExistingParent(name, this.mcLoc("block")).loader(this.forgeLoc("obj")).additional("detectCullableFaces", false).additional("model", this.addModelsPrefix(model)).additional("flip-v", true);
        String particleTex = DataGenUtils.getTextureFromObj(model, this.existingFileHelper);
        if (particleTex.charAt(0) == '#') {
            particleTex = textures.get(particleTex.substring(1)).toString();
        }
        ret.texture("particle", particleTex);
        for (Map.Entry<String, ResourceLocation> e : textures.entrySet()) {
            ret.texture(e.getKey(), e.getValue());
        }
        return ret;
    }

    private LoadedModelBuilder ieObj(String loc) {
        Preconditions.checkArgument((boolean)loc.endsWith(".obj.ie"));
        return this.ieObj(loc.substring(0, loc.length() - 7), this.modLoc(loc));
    }

    private LoadedModelBuilder ieObj(String name, ResourceLocation model) {
        return (LoadedModelBuilder)this.loadedModels.withExistingParent(name, this.mcLoc("block")).loader(this.modLoc("ie_obj")).additional("model", this.addModelsPrefix(model)).additional("flip-v", true).texture("particle", DataGenUtils.getTextureFromObj(model, this.existingFileHelper));
    }

    protected void registerStatesAndModels() {
        for (EnumMetals enumMetals : EnumMetals.values()) {
            String name = enumMetals.tagName();
            if (!enumMetals.isVanillaMetal()) {
                BlockModelBuilder storageModel;
                if (enumMetals.shouldAddOre()) {
                    this.cubeAll(IEBlocks.Metals.ores.get((Object)enumMetals), this.modLoc("block/metal/ore_" + name));
                }
                ResourceLocation resourceLocation = this.modLoc("block/metal/storage_" + name);
                Block storage = IEBlocks.Metals.storage.get((Object)enumMetals);
                String storageName = this.name(storage);
                if (enumMetals == EnumMetals.URANIUM) {
                    ResourceLocation side = this.modLoc("block/metal/storage_" + name + "_side");
                    ResourceLocation top = this.modLoc("block/metal/storage_" + name + "_top");
                    storageModel = (BlockModelBuilder)this.models().cubeBottomTop(storageName, side, top, top);
                    this.slabFor(storage, side, top, top);
                } else {
                    storageModel = (BlockModelBuilder)this.models().cubeAll(storageName, resourceLocation);
                    this.slabFor(storage, resourceLocation);
                }
                this.simpleBlockItem(storage, (ModelFile)storageModel);
            }
            ResourceLocation resourceLocation = this.modLoc("block/metal/sheetmetal_" + name);
            this.cubeAll(IEBlocks.Metals.sheetmetal.get((Object)enumMetals), resourceLocation);
            this.slabFor(IEBlocks.Metals.sheetmetal.get((Object)enumMetals), resourceLocation);
        }
        this.fenceBlock(IEBlocks.WoodenDecoration.treatedFence, TREATED_FENCE_TEXTURE);
        this.fenceBlock(IEBlocks.MetalDecoration.steelFence, STEEL_FENCE_TEXTURE);
        this.fenceBlock(IEBlocks.MetalDecoration.aluFence, ALU_FENCE_TEXTURE);
        this.cubeAll(IEBlocks.StoneDecoration.cokebrick, IEDataGenerator.rl("block/stone_decoration/cokebrick"));
        this.cubeAll(IEBlocks.StoneDecoration.blastbrick, IEDataGenerator.rl("block/stone_decoration/blastbrick"));
        this.cubeAll(IEBlocks.StoneDecoration.blastbrickReinforced, IEDataGenerator.rl("block/stone_decoration/blastbrick_reinforced"));
        this.cubeAll(IEBlocks.StoneDecoration.coke, IEDataGenerator.rl("block/stone_decoration/coke"));
        this.cubeAll(IEBlocks.StoneDecoration.concrete, IEDataGenerator.rl("block/stone_decoration/concrete"));
        this.cubeAll(IEBlocks.StoneDecoration.concreteLeaded, IEDataGenerator.rl("block/stone_decoration/concrete_leaded"));
        this.cubeAll(IEBlocks.StoneDecoration.concreteTile, IEDataGenerator.rl("block/stone_decoration/concrete_tile"));
        this.cubeAll(IEBlocks.StoneDecoration.hempcrete, IEDataGenerator.rl("block/stone_decoration/hempcrete"));
        this.cubeAll(IEBlocks.StoneDecoration.insulatingGlass, IEDataGenerator.rl("block/stone_decoration/insulating_glass"));
        this.cubeAll(IEBlocks.StoneDecoration.alloybrick, IEDataGenerator.rl("block/stone_decoration/alloybrick"));
        for (Enum enum_ : TreatedWoodStyles.values()) {
            this.cubeAll(IEBlocks.WoodenDecoration.treatedWood.get(enum_), IEDataGenerator.rl("block/wooden_decoration/treated_wood_" + enum_.name().toLowerCase(Locale.ENGLISH)));
        }
        this.cubeSideVertical(IEBlocks.MetalDecoration.lvCoil, IEDataGenerator.rl("block/metal_decoration/coil_lv_side"), IEDataGenerator.rl("block/metal_decoration/coil_lv_top"));
        this.cubeSideVertical(IEBlocks.MetalDecoration.mvCoil, IEDataGenerator.rl("block/metal_decoration/coil_mv_side"), IEDataGenerator.rl("block/metal_decoration/coil_mv_top"));
        this.cubeSideVertical(IEBlocks.MetalDecoration.hvCoil, IEDataGenerator.rl("block/metal_decoration/coil_hv_side"), IEDataGenerator.rl("block/metal_decoration/coil_hv_top"));
        this.cubeAll(IEBlocks.MetalDecoration.engineeringRS, IEDataGenerator.rl("block/metal_decoration/redstone_engineering"));
        this.cubeAll(IEBlocks.MetalDecoration.engineeringHeavy, IEDataGenerator.rl("block/metal_decoration/heavy_engineering"));
        this.cubeAll(IEBlocks.MetalDecoration.engineeringLight, IEDataGenerator.rl("block/metal_decoration/light_engineering"));
        this.cubeAll(IEBlocks.MetalDecoration.generator, IEDataGenerator.rl("block/metal_decoration/generator"));
        this.cubeAll(IEBlocks.MetalDecoration.radiator, IEDataGenerator.rl("block/metal_decoration/radiator"));
        this.scaffold(IEBlocks.WoodenDecoration.treatedScaffolding, IEDataGenerator.rl("block/wooden_decoration/scaffolding"), IEDataGenerator.rl("block/wooden_decoration/scaffolding_top"));
        ResourceLocation aluSide = IEDataGenerator.rl("block/metal_decoration/aluminum_scaffolding");
        ResourceLocation steelSide = IEDataGenerator.rl("block/metal_decoration/steel_scaffolding");
        for (MetalScaffoldingType metalScaffoldingType : MetalScaffoldingType.values()) {
            String suffix = "_" + metalScaffoldingType.name().toLowerCase(Locale.ENGLISH);
            ResourceLocation aluTop = IEDataGenerator.rl("block/metal_decoration/aluminum_scaffolding_top" + suffix);
            ResourceLocation steelTop = IEDataGenerator.rl("block/metal_decoration/steel_scaffolding_top" + suffix);
            this.scaffold(IEBlocks.MetalDecoration.aluScaffolding.get((Object)metalScaffoldingType), aluSide, aluTop);
            this.scaffold(IEBlocks.MetalDecoration.steelScaffolding.get((Object)metalScaffoldingType), steelSide, steelTop);
            this.slabFor(IEBlocks.MetalDecoration.aluScaffolding.get((Object)metalScaffoldingType), aluSide, aluTop, aluSide);
            this.slabFor(IEBlocks.MetalDecoration.steelScaffolding.get((Object)metalScaffoldingType), steelSide, steelTop, steelSide);
            this.stairs(IEBlocks.MetalDecoration.aluScaffoldingStair.get((Object)metalScaffoldingType), aluSide, aluTop, aluSide);
            this.stairs(IEBlocks.MetalDecoration.steelScaffoldingStair.get((Object)metalScaffoldingType), steelSide, steelTop, steelSide);
        }
        this.slabFor(IEBlocks.StoneDecoration.cokebrick, IEDataGenerator.rl("block/stone_decoration/cokebrick"));
        this.slabFor(IEBlocks.StoneDecoration.blastbrick, IEDataGenerator.rl("block/stone_decoration/blastbrick"));
        this.slabFor(IEBlocks.StoneDecoration.blastbrickReinforced, IEDataGenerator.rl("block/stone_decoration/blastbrick_reinforced"));
        this.slabFor(IEBlocks.StoneDecoration.coke, IEDataGenerator.rl("block/stone_decoration/coke"));
        this.slabFor(IEBlocks.StoneDecoration.concrete, IEDataGenerator.rl("block/stone_decoration/concrete"));
        this.slabFor(IEBlocks.StoneDecoration.concreteTile, IEDataGenerator.rl("block/stone_decoration/concrete_tile"));
        this.slabFor(IEBlocks.StoneDecoration.concreteLeaded, IEDataGenerator.rl("block/stone_decoration/concrete_leaded"));
        this.slabFor(IEBlocks.StoneDecoration.hempcrete, IEDataGenerator.rl("block/stone_decoration/hempcrete"));
        this.slabFor(IEBlocks.StoneDecoration.insulatingGlass, IEDataGenerator.rl("block/stone_decoration/insulating_glass"));
        this.slabFor(IEBlocks.StoneDecoration.alloybrick, IEDataGenerator.rl("block/stone_decoration/alloybrick"));
        for (Enum enum_ : TreatedWoodStyles.values()) {
            this.slabFor(IEBlocks.WoodenDecoration.treatedWood.get(enum_), IEDataGenerator.rl("block/wooden_decoration/treated_wood_" + enum_.name().toLowerCase(Locale.ENGLISH)));
        }
        this.stairs(IEBlocks.StoneDecoration.hempcreteStairs, IEDataGenerator.rl("block/stone_decoration/hempcrete"));
        this.stairs(IEBlocks.StoneDecoration.concreteStairs[0], IEDataGenerator.rl("block/stone_decoration/concrete"));
        this.stairs(IEBlocks.StoneDecoration.concreteStairs[1], IEDataGenerator.rl("block/stone_decoration/concrete_tile"));
        this.stairs(IEBlocks.StoneDecoration.concreteStairs[2], IEDataGenerator.rl("block/stone_decoration/concrete_leaded"));
        for (Enum enum_ : TreatedWoodStyles.values()) {
            this.stairs(IEBlocks.WoodenDecoration.treatedStairs.get(enum_), IEDataGenerator.rl("block/wooden_decoration/treated_wood_" + enum_.name().toLowerCase(Locale.ENGLISH)));
        }
        this.postBlock(IEBlocks.WoodenDecoration.treatedPost, IEDataGenerator.rl("block/wooden_decoration/post"));
        this.postBlock(IEBlocks.MetalDecoration.steelPost, IEDataGenerator.rl("block/metal_decoration/steel_post"));
        this.postBlock(IEBlocks.MetalDecoration.aluPost, IEDataGenerator.rl("block/metal_decoration/aluminum_post"));
        this.createStoneMultiblocks();
        this.createMetalMultiblocks();
        this.createConnectors();
        this.simpleBlock(IEBlocks.Multiblocks.bucketWheel, new ConfiguredModel[]{this.EMPTY_MODEL});
        this.simpleBlock(IEBlocks.MetalDevices.fluidPipe, (ModelFile)this.ieObj("block/metal_device/fluid_pipe.obj.ie"));
        this.createMultiblock(IEBlocks.MetalDevices.cloche, (ModelFile)this.ieObj("block/metal_device/cloche.obj.ie"));
        this.createMultiblock(IEBlocks.MetalDevices.turretChem, (ModelFile)this.ieObj("block/metal_device/chem_turret.obj.ie"));
        this.createMultiblock(IEBlocks.MetalDevices.turretGun, (ModelFile)this.ieObj("block/metal_device/gun_turret.obj.ie"));
        this.createMultiblock(IEBlocks.MetalDevices.teslaCoil, this.obj("block/metal_device/teslacoil.obj"), null, (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_ALL, null, 180);
        for (Map.Entry entry : IEBlocks.MetalDevices.chutes.entrySet()) {
            ModelBuilder model = ((LoadedModelBuilder)this.ieObj("block/metal_device/chute_" + ((EnumMetals)((Object)entry.getKey())).tagName(), IEDataGenerator.rl("block/metal_device/chute.obj.ie")).texture("texture", IEDataGenerator.rl("block/metal/sheetmetal_" + ((EnumMetals)((Object)entry.getKey())).tagName()))).texture("particle", IEDataGenerator.rl("block/metal/sheetmetal_" + ((EnumMetals)((Object)entry.getKey())).tagName()));
            this.simpleBlock((Block)entry.getValue(), (ModelFile)model);
        }
        this.simpleBlockItem(IEBlocks.Misc.fakeLight, this.EMPTY_MODEL);
        this.createMultistateSingleModel(IEBlocks.WoodenDevices.windmill, this.EMPTY_MODEL);
        this.createMultistateSingleModel(IEBlocks.WoodenDevices.watermill, this.EMPTY_MODEL);
        this.createMultistateSingleModel(IEBlocks.MetalDecoration.lantern, new ConfiguredModel((ModelFile)this.ieObj("block/lantern.obj.ie")));
        ModelFile noneModel = this.createMetalLadder("metal_ladder", null, null);
        ModelFile modelFile = this.createMetalLadder("metal_ladder_alu", IEDataGenerator.rl("block/metal_decoration/aluminum_scaffolding_open"), IEDataGenerator.rl("block/metal_decoration/aluminum_scaffolding"));
        ModelFile steelModel = this.createMetalLadder("metal_ladder_steel", IEDataGenerator.rl("block/metal_decoration/steel_scaffolding_open"), IEDataGenerator.rl("block/metal_decoration/steel_scaffolding"));
        Block block = IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.STEEL);
        Block alu = IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.ALU);
        Block none = IEBlocks.MetalDecoration.metalLadder.get((Object)MetalLadderBlock.CoverType.NONE);
        this.createDirectionalBlock(none, (IProperty<Direction>)IEProperties.FACING_HORIZONTAL, noneModel);
        this.createDirectionalBlock(alu, (IProperty<Direction>)IEProperties.FACING_HORIZONTAL, modelFile);
        this.createDirectionalBlock(block, (IProperty<Direction>)IEProperties.FACING_HORIZONTAL, steelModel);
        this.itemModels.put(none, noneModel);
        this.itemModels.put(alu, modelFile);
        this.itemModels.put(block, steelModel);
        this.createWallmount(IEBlocks.WoodenDevices.treatedWallmount, IEDataGenerator.rl("block/wooden_device/wallmount"));
        ModelBuilder turntableModel = this.models().cubeBottomTop("turntable", this.modLoc("block/wooden_device/turntable"), this.modLoc("block/wooden_device/turntable_bottom"), this.modLoc("block/wooden_device/turntable_top"));
        this.createRotatedBlock(IEBlocks.WoodenDevices.turntable, arg_0 -> BlockStates.lambda$registerStatesAndModels$0((ModelFile)turntableModel, arg_0), (IProperty<Direction>)IEProperties.FACING_ALL, (List<IProperty<?>>)ImmutableList.of(), -90, 0);
        this.itemModels.put(IEBlocks.WoodenDevices.turntable, (ModelFile)turntableModel);
        this.createWallmount(IEBlocks.MetalDecoration.aluWallmount, IEDataGenerator.rl("block/metal_decoration/aluminum_wallmount"));
        this.createWallmount(IEBlocks.MetalDecoration.steelWallmount, IEDataGenerator.rl("block/metal_decoration/steel_wallmount"));
        LoadedModelBuilder steelModel2 = ((LoadedModelBuilder)((LoadedModelBuilder)this.ieObj("block/slope.obj.ie").texture("texture", this.modLoc("block/metal_decoration/steel_scaffolding"))).texture("particle", this.modLoc("block/metal_decoration/steel_scaffolding"))).transforms(this.modLoc("item/block"));
        LoadedModelBuilder loadedModelBuilder = ((LoadedModelBuilder)((LoadedModelBuilder)this.ieObj("slope_alu", this.modLoc("block/slope.obj.ie")).texture("texture", this.modLoc("block/metal_decoration/aluminum_scaffolding"))).texture("particle", this.modLoc("block/metal_decoration/aluminum_scaffolding"))).transforms(this.modLoc("item/block"));
        this.createMultistateSingleModel(IEBlocks.MetalDecoration.slopeSteel, new ConfiguredModel((ModelFile)steelModel2));
        this.itemModels.put(IEBlocks.MetalDecoration.slopeSteel, (ModelFile)steelModel2);
        this.createMultistateSingleModel(IEBlocks.MetalDecoration.slopeAlu, new ConfiguredModel((ModelFile)loadedModelBuilder));
        this.itemModels.put(IEBlocks.MetalDecoration.slopeAlu, (ModelFile)loadedModelBuilder);
        this.createRotatedBlock(IEBlocks.StoneDecoration.coresample, map -> this.obj("block/coresample.obj"), (IProperty<Direction>)IEProperties.FACING_HORIZONTAL, (List<IProperty<?>>)ImmutableList.of());
        ResourceLocation concreteTexture = IEDataGenerator.rl("block/stone_decoration/concrete");
        this.simpleBlockItem(IEBlocks.StoneDecoration.concreteSheet, (ModelFile)this.models().carpet("concrete_sheet", concreteTexture));
        this.simpleBlockItem(IEBlocks.StoneDecoration.concreteQuarter, this.quarter("concrete_quarter", concreteTexture));
        this.simpleBlockItem(IEBlocks.StoneDecoration.concreteThreeQuarter, this.threeQuarter("concrete_three_quarter", concreteTexture));
        this.simpleBlock(IEBlocks.StoneDecoration.concreteSprayed, this.obj("block/sprayed_concrete.obj"));
        this.createRotatedBlock(IEBlocks.WoodenDevices.craftingTable, state -> this.obj("block/wooden_device/craftingtable.obj"), (IProperty<Direction>)IEProperties.FACING_HORIZONTAL, (List<IProperty<?>>)ImmutableList.of());
        this.cubeAll(IEBlocks.WoodenDevices.crate, this.modLoc("block/wooden_device/crate"));
        this.cubeAll(IEBlocks.WoodenDevices.reinforcedCrate, this.modLoc("block/wooden_device/reinforced_crate"));
        ModelBuilder modelBuilder = this.models().cubeBottomTop("gunpowder_barrel", IEDataGenerator.rl("block/wooden_device/gunpowder_barrel"), IEDataGenerator.rl("block/wooden_device/barrel_up_none"), IEDataGenerator.rl("block/wooden_device/gunpowder_barrel_top"));
        this.createMultistateSingleModel(IEBlocks.WoodenDevices.gunpowderBarrel, new ConfiguredModel((ModelFile)modelBuilder));
        this.itemModels.put(IEBlocks.WoodenDevices.gunpowderBarrel, (ModelFile)modelBuilder);
        this.simpleBlockItem(IEBlocks.WoodenDevices.sorter, this.createRouterModel(IEDataGenerator.rl("block/wooden_device/sorter"), "router"));
        ModelBuilder modelBuilder2 = this.models().cubeBottomTop("item_batcher", this.modLoc("block/wooden_device/item_batcher"), this.modLoc("block/wooden_device/item_batcher_in"), this.modLoc("block/wooden_device/item_batcher_out"));
        this.createRotatedBlock(IEBlocks.WoodenDevices.itemBatcher, arg_0 -> BlockStates.lambda$registerStatesAndModels$3((ModelFile)modelBuilder2, arg_0), (IProperty<Direction>)IEProperties.FACING_ALL, (List<IProperty<?>>)ImmutableList.of(), -90, 0);
        this.itemModels.put(IEBlocks.WoodenDevices.itemBatcher, (ModelFile)modelBuilder2);
        this.simpleBlockItem(IEBlocks.WoodenDevices.fluidSorter, this.createRouterModel(IEDataGenerator.rl("block/wooden_device/fluid_sorter"), "fluid_router"));
        this.simpleBlockItem(IEBlocks.WoodenDevices.woodenBarrel, (ModelFile)this.loadedModels.getBuilder("wooden_devices/barrel").loader(ModelConfigurableSides.Loader.NAME).additional("type", "vertical").additional("base_name", this.modLoc("block/wooden_device/barrel")));
        this.createRotatedBlock(IEBlocks.Cloth.curtain, state -> new ModelFile.ExistingModelFile(IEDataGenerator.rl(state.getSetStates().get(StripCurtainBlock.CEILING_ATTACHED) == Boolean.FALSE ? "block/stripcurtain" : "block/stripcurtain_middle"), this.existingFileHelper), (IProperty<Direction>)IEProperties.FACING_HORIZONTAL, (List<IProperty<?>>)ImmutableList.of((Object)StripCurtainBlock.CEILING_ATTACHED));
        this.cubeAll(IEBlocks.Cloth.cushion, this.modLoc("block/cushion"));
        this.createMultistateSingleModel(IEBlocks.Cloth.shaderBanner, this.EMPTY_MODEL);
        this.createMultistateSingleModel(IEBlocks.Cloth.shaderBannerWall, this.EMPTY_MODEL);
        this.simpleBlockItem(IEBlocks.MetalDevices.barrel, (ModelFile)this.loadedModels.getBuilder("metal_devices/barrel").loader(ModelConfigurableSides.Loader.NAME).additional("type", "vertical").additional("base_name", this.modLoc("block/metal_device/barrel")));
        for (Map.Entry cap : ImmutableMap.of((Object)IEBlocks.MetalDevices.capacitorCreative, (Object)"creative", (Object)IEBlocks.MetalDevices.capacitorLV, (Object)"lv", (Object)IEBlocks.MetalDevices.capacitorMV, (Object)"mv", (Object)IEBlocks.MetalDevices.capacitorHV, (Object)"hv").entrySet()) {
            LoadedModelBuilder loadedModelBuilder2 = this.loadedModels.getBuilder("block/metal_device/capacitor_" + (String)cap.getValue()).loader(ModelConfigurableSides.Loader.NAME).additional("type", "side_top_bottom").additional("base_name", this.modLoc("block/metal_device/capacitor_" + (String)cap.getValue()));
            this.simpleBlockItem((Block)cap.getKey(), (ModelFile)loadedModelBuilder2);
        }
        LoadedModelBuilder loadedModelBuilder3 = this.loadedModels.getBuilder("block/metal_device/fluid_placer").loader(ModelConfigurableSides.Loader.NAME).additional("type", "all_same_texture").additional("base_name", this.modLoc("block/metal_device/fluid_placer"));
        this.simpleBlockItem(IEBlocks.MetalDevices.fluidPlacer, (ModelFile)loadedModelBuilder3);
        this.createMultiblock(IEBlocks.MetalDevices.blastFurnacePreheater, this.obj("block/metal_device/blastfurnace_preheater.obj"));
        ModelBuilder modelBuilder3 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("furnace_heater_on", IEDataGenerator.rl("block/ie_six_sides_overlay_all_but_one"))).texture("block_all", IEDataGenerator.rl("block/metal_device/furnace_heater_active"))).texture("block_north", IEDataGenerator.rl("block/metal_device/furnace_heater_socket"))).texture("overlay_all", IEDataGenerator.rl("block/metal_device/furnace_heater_active_overlay"));
        ModelBuilder furnaceHeaterOff = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("furnace_heater_off", IEDataGenerator.rl("block/ie_six_sides_overlay_all_but_one"))).texture("block_all", IEDataGenerator.rl("block/metal_device/furnace_heater"))).texture("block_north", IEDataGenerator.rl("block/metal_device/furnace_heater_socket"))).texture("overlay_all", IEDataGenerator.rl("block/metal_device/furnace_heater_overlay"));
        this.createRotatedBlock(IEBlocks.MetalDevices.furnaceHeater, arg_0 -> BlockStates.lambda$registerStatesAndModels$5((ModelFile)modelBuilder3, (ModelFile)furnaceHeaterOff, arg_0), (IProperty<Direction>)IEProperties.FACING_ALL, (List<IProperty<?>>)ImmutableList.of((Object)((Object)IEProperties.ACTIVE)), 180, 0);
        this.itemModels.put(IEBlocks.MetalDevices.furnaceHeater, (ModelFile)furnaceHeaterOff);
        this.createPump();
        ModelBuilder modelBuilder4 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("kinetic_dynamo", this.mcLoc("block/cube"))).texture("down", this.modLoc("block/metal_device/dynamo_bottom"))).texture("south", this.modLoc("block/metal_device/dynamo_bottom"))).texture("up", this.modLoc("block/metal_device/dynamo_top"))).texture("north", this.modLoc("block/metal_device/dynamo_front"))).texture("west", this.modLoc("block/metal_device/dynamo_side"))).texture("east", this.modLoc("block/metal_device/dynamo_side"));
        this.createRotatedBlock(IEBlocks.MetalDevices.dynamo, arg_0 -> BlockStates.lambda$registerStatesAndModels$6((ModelFile)modelBuilder4, arg_0), (IProperty<Direction>)IEProperties.FACING_HORIZONTAL, (List<IProperty<?>>)ImmutableList.of());
        this.itemModels.put(IEBlocks.MetalDevices.dynamo, (ModelFile)modelBuilder4);
        this.simpleBlockItem(IEBlocks.MetalDevices.thermoelectricGen, new ConfiguredModel((ModelFile)this.models().cubeBottomTop("thermoelectric_generator", this.modLoc("block/metal_device/thermoelectric_gen_side"), this.modLoc("block/metal_device/thermoelectric_gen_bottom"), this.modLoc("block/metal_device/thermoelectric_gen_top"))));
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("loader", this.forgeLoc("obj").toString());
        jsonObject.addProperty("detectCullableFaces", Boolean.valueOf(false));
        jsonObject.addProperty("flip-v", Boolean.valueOf(true));
        jsonObject.addProperty("model", this.modLoc("models/block/metal_device/charging_station.obj").toString());
        JsonObject translucent = new JsonObject();
        translucent.addProperty("loader", this.forgeLoc("obj").toString());
        translucent.addProperty("detectCullableFaces", Boolean.valueOf(false));
        translucent.addProperty("flip-v", Boolean.valueOf(true));
        translucent.addProperty("model", this.modLoc("models/block/metal_device/charging_station_glass.obj").toString());
        ModelBuilder modelBuilder5 = this.loadedModels.getBuilder("metal_device/charging_station").loader(MultiLayerLoader.LOCATION).additional("solid", (JsonElement)jsonObject).additional("translucent", (JsonElement)translucent).transforms(this.modLoc("item/block")).texture("particle", DataGenUtils.getTextureFromObj(this.modLoc("block/metal_device/charging_station.obj"), this.existingFileHelper));
        this.createRotatedBlock(IEBlocks.MetalDevices.chargingStation, arg_0 -> BlockStates.lambda$registerStatesAndModels$7((ModelFile)modelBuilder5, arg_0), (IProperty<Direction>)IEProperties.FACING_HORIZONTAL, (List<IProperty<?>>)ImmutableList.of());
        this.itemModels.put(IEBlocks.MetalDevices.chargingStation, (ModelFile)modelBuilder5);
        for (Block b : IEBlocks.MetalDevices.CONVEYORS.values()) {
            this.createMultistateSingleModel(b, new ConfiguredModel((ModelFile)this.loadedModels.getBuilder("metal_device/conveyor").loader(ModelConveyor.ConveyorLoader.LOCATION)));
        }
        this.createHemp();
        for (IEFluid f : IEFluid.IE_FLUIDS) {
            ResourceLocation resourceLocation = f.getAttributes().getStillTexture();
            ModelBuilder model2 = ((BlockModelBuilder)this.models().getBuilder("block/fluid/" + f.getRegistryName().func_110623_a())).texture("particle", resourceLocation);
            this.getVariantBuilder(f.block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model2)});
        }
        this.createRotatedBlock(IEBlocks.MetalDevices.toolbox, state -> this.obj("block/toolbox.obj"), (IProperty<Direction>)IEProperties.FACING_HORIZONTAL, (List<IProperty<?>>)ImmutableList.of());
        this.loadedModels.backupModels();
    }

    public void fenceBlock(FenceBlock b, ResourceLocation texture) {
        super.fenceBlock(b, texture);
        this.itemModels.put((Block)b, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(b.getRegistryName().func_110623_a() + "_inventory", this.mcLoc("block/fence_inventory"))).texture("texture", texture));
    }

    private ModelFile retexture(String name, ResourceLocation baseModel, ImmutableMap<String, ResourceLocation> textures) {
        LoadedModelBuilder ret = this.loadedModels.getBuilder(name).loader(this.guessLoader(baseModel).get());
        for (Map.Entry e : textures.entrySet()) {
            ret.texture((String)e.getKey(), (ResourceLocation)e.getValue());
        }
        return ret;
    }

    private void createConnectors() {
        this.createConnector(IEBlocks.MetalDevices.floodlight, IEDataGenerator.rl("block/metal_device/floodlight.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228645_f_(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("LV", false), IEDataGenerator.rl("block/connector/connector_lv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/connector_lv")), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("LV", true), IEDataGenerator.rl("block/connector/connector_lv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/relay_lv")), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("MV", false), IEDataGenerator.rl("block/connector/connector_mv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/connector_mv")), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("MV", true), IEDataGenerator.rl("block/connector/connector_mv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/connector/relay_mv")), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("HV", false), IEDataGenerator.rl("block/connector/connector_hv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.getEnergyConnector("HV", true), IEDataGenerator.rl("block/connector/relay_hv.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228645_f_());
        this.createConnector(IEBlocks.Connectors.connectorStructural, IEDataGenerator.rl("block/connector/connector_structural.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.connectorRedstone, IEDataGenerator.rl("block/connector/connector_redstone.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.connectorProbe, IEDataGenerator.rl("block/connector/connector_probe.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228643_e_(), RenderType.func_228645_f_());
        this.createConnector(IEBlocks.Connectors.connectorBundled, IEDataGenerator.rl("block/connector/connector_bundled.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228643_e_());
        this.createConnector(IEBlocks.Connectors.feedthrough, FeedthroughLoader.LOCATION, (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228661_n_().toArray(new RenderType[0]));
        this.createConnector(IEBlocks.MetalDevices.electricLantern, (VariantBlockStateBuilder.PartialBlockstate state) -> IEDataGenerator.rl("block/metal_device/e_lantern.obj"), (VariantBlockStateBuilder.PartialBlockstate state) -> {
            if (state.getSetStates().get((Object)IEProperties.ACTIVE) == Boolean.FALSE) {
                return ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/metal_device/electric_lantern"));
            }
            return ImmutableMap.of((Object)"texture", (Object)this.modLoc("block/metal_device/electric_lantern_on"));
        }, (List<IProperty<?>>)ImmutableList.of((Object)((Object)IEProperties.ACTIVE)), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.redstoneBreaker, IEDataGenerator.rl("block/connector/redstone_breaker.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.breakerswitch, (VariantBlockStateBuilder.PartialBlockstate map) -> {
            if (map.getSetStates().get((Object)IEProperties.ACTIVE) == Boolean.FALSE) {
                return IEDataGenerator.rl("block/connector/breaker_switch_off.obj.ie");
            }
            return IEDataGenerator.rl("block/connector/breaker_switch_on.obj.ie");
        }, (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), (List<IProperty<?>>)ImmutableList.of((Object)((Object)IEProperties.ACTIVE)), RenderType.func_228639_c_());
        ResourceLocation leftModel = IEDataGenerator.rl("block/connector/transformer_mv_left.obj");
        this.createConnector(IEBlocks.Connectors.transformer, (VariantBlockStateBuilder.PartialBlockstate map) -> {
            if (map.getSetStates().get((Object)IEProperties.MULTIBLOCKSLAVE) == Boolean.TRUE) {
                return this.EMPTY_MODEL.model.getLocation();
            }
            if (map.getSetStates().get((Object)IEProperties.MIRRORED) == Boolean.FALSE) {
                return leftModel;
            }
            return IEDataGenerator.rl("block/connector/transformer_mv_right.obj");
        }, (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"particle", (Object)new ResourceLocation(DataGenUtils.getTextureFromObj(leftModel, this.existingFileHelper))), (List<IProperty<?>>)ImmutableList.of((Object)((Object)IEProperties.MULTIBLOCKSLAVE), (Object)((Object)IEProperties.MIRRORED)), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Connectors.postTransformer, IEDataGenerator.rl("block/connector/transformer_post.obj"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        leftModel = IEDataGenerator.rl("block/connector/transformer_hv_left.obj");
        this.createConnector(IEBlocks.Connectors.transformerHV, (VariantBlockStateBuilder.PartialBlockstate map) -> {
            if (map.getSetStates().get((Object)IEProperties.MULTIBLOCKSLAVE) == Boolean.TRUE) {
                return this.EMPTY_MODEL.model.getLocation();
            }
            if (map.getSetStates().get((Object)IEProperties.MIRRORED) == Boolean.FALSE) {
                return leftModel;
            }
            return IEDataGenerator.rl("block/connector/transformer_hv_right.obj");
        }, (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"particle", (Object)new ResourceLocation(DataGenUtils.getTextureFromObj(leftModel, this.existingFileHelper))), (List<IProperty<?>>)ImmutableList.of((Object)((Object)IEProperties.MULTIBLOCKSLAVE), (Object)((Object)IEProperties.MIRRORED)), RenderType.func_228639_c_());
        ResourceLocation ctModel = IEDataGenerator.rl("block/connector/e_meter.obj");
        this.createConnector(IEBlocks.Connectors.currentTransformer, (VariantBlockStateBuilder.PartialBlockstate map) -> {
            if (map.getSetStates().get((Object)IEProperties.MULTIBLOCKSLAVE) == Boolean.TRUE) {
                return ctModel;
            }
            return this.EMPTY_MODEL.model.getLocation();
        }, (ImmutableMap<String, ResourceLocation>)ImmutableMap.of((Object)"particle", (Object)new ResourceLocation(DataGenUtils.getTextureFromObj(ctModel, this.existingFileHelper))), (List<IProperty<?>>)ImmutableList.of((Object)((Object)IEProperties.MULTIBLOCKSLAVE)), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.MetalDevices.razorWire, IEDataGenerator.rl("block/razor_wire.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), RenderType.func_228639_c_());
        this.createConnector(IEBlocks.Cloth.balloon, (VariantBlockStateBuilder.PartialBlockstate map) -> IEDataGenerator.rl("block/balloon.obj.ie"), (ImmutableMap<String, ResourceLocation>)ImmutableMap.of(), (List<IProperty<?>>)ImmutableList.of(), RenderType.func_228645_f_());
    }

    private void createMetalMultiblocks() {
        this.createMultiblock(IEBlocks.Multiblocks.excavator, this.obj("block/metal_multiblock/excavator.obj"), this.obj("block/metal_multiblock/excavator_mirrored.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.crusher, this.obj("block/metal_multiblock/crusher_mirrored.obj"), this.obj("block/metal_multiblock/crusher.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.metalPress, this.obj("block/metal_multiblock/metal_press.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.assembler, this.obj("block/metal_multiblock/assembler.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.arcFurnace, this.obj("block/metal_multiblock/arc_furnace.obj"), this.obj("block/metal_multiblock/arc_furnace_mirrored.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.blastFurnaceAdv, this.obj("block/blastfurnace_advanced.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.silo, this.obj("block/metal_multiblock/silo.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.tank, this.obj("block/metal_multiblock/tank.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.bottlingMachine, this.obj("block/metal_multiblock/bottling_machine.obj"), this.obj("block/metal_multiblock/bottling_machine_mirrored.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.fermenter, this.obj("block/metal_multiblock/fermenter.obj"), this.obj("block/metal_multiblock/fermenter_mirrored.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.squeezer, this.obj("block/metal_multiblock/squeezer.obj"), this.obj("block/metal_multiblock/squeezer_mirrored.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.mixer, this.obj("block/metal_multiblock/mixer.obj"), this.obj("block/metal_multiblock/mixer_mirrored.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.refinery, this.obj("block/metal_multiblock/refinery.obj"), this.obj("block/metal_multiblock/refinery_mirrored.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.dieselGenerator, this.obj("block/metal_multiblock/diesel_generator.obj"), this.obj("block/metal_multiblock/diesel_generator_mirrored.obj"));
        this.createMultiblock(IEBlocks.Multiblocks.lightningrod, this.obj("block/metal_multiblock/lightningrod.obj"));
        this.createMultiblock(IEBlocks.WoodenDevices.workbench, (ModelFile)this.ieObj("block/wooden_device/workbench.obj.ie"), null, (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, null, 180);
        this.createMultiblock(IEBlocks.MetalDevices.sampleDrill, this.obj("block/metal_device/core_drill.obj"), null, (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, null, 180);
        this.createMultiblock(IEBlocks.Multiblocks.autoWorkbench, this.obj("block/metal_multiblock/auto_workbench.obj"), this.obj("block/metal_multiblock/auto_workbench_mirrored.obj"), (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, (IProperty<Boolean>)IEProperties.MIRRORED, 180);
    }

    private void createStoneMultiblocks() {
        this.blastFurnaceOff = this.cubeThree("blast_furnace_off", this.modLoc("block/multiblocks/blast_furnace"), this.modLoc("block/multiblocks/blast_furnace_off"));
        this.blastFurnaceOn = this.cubeThree("blast_furnace_on", this.modLoc("block/multiblocks/blast_furnace"), this.modLoc("block/multiblocks/blast_furnace_on"));
        this.cokeOvenOff = this.cubeThree("coke_oven_off", this.modLoc("block/multiblocks/coke_oven"), this.modLoc("block/multiblocks/coke_oven_off"));
        this.cokeOvenOn = this.cubeThree("coke_oven_on", this.modLoc("block/multiblocks/coke_oven"), this.modLoc("block/multiblocks/coke_oven_on"));
        this.alloySmelterOff = this.cubeTwo("alloy_smelter_off", this.modLoc("block/multiblocks/alloy_smelter_top"), this.modLoc("block/multiblocks/alloy_smelter_bottom"), this.modLoc("block/multiblocks/alloy_smelter_side"), this.modLoc("block/multiblocks/alloy_smelter_off"));
        this.alloySmelterOn = this.cubeTwo("alloy_smelter_on", this.modLoc("block/multiblocks/alloy_smelter_top"), this.modLoc("block/multiblocks/alloy_smelter_bottom"), this.modLoc("block/multiblocks/alloy_smelter_side"), this.modLoc("block/multiblocks/alloy_smelter_on"));
        this.createMultiblock(IEBlocks.Multiblocks.cokeOven, this.cokeOvenOff, this.cokeOvenOn, (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, (IProperty<Boolean>)IEProperties.ACTIVE, 180, this.modLoc("block/multiblocks/coke_oven"));
        this.createMultiblock(IEBlocks.Multiblocks.alloySmelter, this.alloySmelterOff, this.alloySmelterOn, (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, (IProperty<Boolean>)IEProperties.ACTIVE, 180, this.modLoc("block/multiblocks/alloy_smelter_side"));
        this.createMultiblock(IEBlocks.Multiblocks.blastFurnace, this.blastFurnaceOff, this.blastFurnaceOn, (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, (IProperty<Boolean>)IEProperties.ACTIVE, 180, this.modLoc("block/multiblocks/blast_furnace"));
    }

    private void createMultistateSingleModel(Block block, ConfiguredModel model) {
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{model});
    }

    private void createPump() {
        VariantBlockStateBuilder builder = this.getVariantBuilder(IEBlocks.MetalDevices.fluidPump);
        builder.partialState().with((IProperty)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel(this.obj("block/metal_device/fluid_pump.obj"), 0, 0, false)});
        builder.partialState().with((IProperty)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.loadedModels.getBuilder("metal_device/pump_bottom").loader(ModelConfigurableSides.Loader.NAME).additional("type", "side_vertical").additional("base_name", this.modLoc("block/metal_device/fluid_pump")))});
    }

    private void createRotatedBlock(Block block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, IProperty<Direction> facing, List<IProperty<?>> additionalProps) {
        this.createRotatedBlock(block, model, facing, additionalProps, 0, 180);
    }

    private void createRotatedBlock(Block block, Function<VariantBlockStateBuilder.PartialBlockstate, ModelFile> model, IProperty<Direction> facing, List<IProperty<?>> additionalProps, int offsetRotX, int offsetRotY) {
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(block);
        this.forEachState(stateBuilder.partialState(), additionalProps, state -> {
            ModelFile modelLoc = (ModelFile)model.apply((VariantBlockStateBuilder.PartialBlockstate)state);
            for (Direction d : facing.func_177700_c()) {
                int y;
                int x;
                switch (d) {
                    case UP: {
                        x = 90;
                        y = 0;
                        break;
                    }
                    case DOWN: {
                        x = -90;
                        y = 0;
                        break;
                    }
                    default: {
                        y = this.getAngle(d, offsetRotY);
                        x = 0;
                    }
                }
                state.with(facing, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel(modelLoc, x + offsetRotX, y, false)});
            }
        });
    }

    private void createMultiblock(Block b, ModelFile masterModel, ModelFile mirroredModel, int rotationOffset) {
        this.createMultiblock(b, masterModel, mirroredModel, (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, (IProperty<Boolean>)IEProperties.MIRRORED, rotationOffset);
    }

    private void createMultiblock(Block b, ModelFile masterModel, ModelFile mirroredModel) {
        this.createMultiblock(b, masterModel, mirroredModel, 180);
    }

    private void createMultiblock(Block b, ModelFile masterModel) {
        this.createMultiblock(b, masterModel, null, (IProperty<Boolean>)IEProperties.MULTIBLOCKSLAVE, (EnumProperty<Direction>)IEProperties.FACING_HORIZONTAL, null, 180);
    }

    private void createMultiblock(Block b, ModelFile masterModel, @Nullable ModelFile mirroredModel, IProperty<Boolean> isSlave, EnumProperty<Direction> facing, @Nullable IProperty<Boolean> mirroredState, int rotationOffset) {
        String objLoc = ((ModelBuilder)masterModel).toJson().get("model").getAsString();
        objLoc = objLoc.substring(0, objLoc.indexOf(58) + 1) + objLoc.substring(objLoc.indexOf(47) + 1);
        this.createMultiblock(b, masterModel, mirroredModel, isSlave, facing, mirroredState, rotationOffset, new ResourceLocation(DataGenUtils.getTextureFromObj(new ResourceLocation(objLoc), this.existingFileHelper)));
    }

    private void createMultiblock(Block b, ModelFile masterModel, @Nullable ModelFile mirroredModel, IProperty<Boolean> isSlave, EnumProperty<Direction> facing, @Nullable IProperty<Boolean> mirroredState, int rotationOffset, ResourceLocation particleTex) {
        Preconditions.checkArgument((mirroredModel == null == (mirroredState == null) ? 1 : 0) != 0);
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        builder.partialState().with(isSlave, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().withExistingParent(b.getRegistryName().func_110623_a() + "_empty", this.EMPTY_MODEL.model.getLocation())).texture("particle", particleTex))});
        boolean[] possibleMirrorStates = mirroredState != null ? new boolean[]{false, true} : new boolean[1];
        for (boolean mirrored : possibleMirrorStates) {
            for (Direction dir : facing.func_177700_c()) {
                int angleY;
                int angleX;
                if (facing.func_177700_c().contains(Direction.UP)) {
                    angleX = -90 * dir.func_96559_d();
                    angleY = dir.func_176740_k() != Direction.Axis.Y ? this.getAngle(dir, rotationOffset) : 0;
                } else {
                    angleY = this.getAngle(dir, rotationOffset);
                    angleX = 0;
                }
                ModelFile model = mirrored ? mirroredModel : masterModel;
                VariantBlockStateBuilder.PartialBlockstate partialState = builder.partialState().with(isSlave, (Comparable)Boolean.valueOf(false)).with(facing, (Comparable)dir);
                if (mirroredState != null) {
                    partialState = partialState.with(mirroredState, (Comparable)Boolean.valueOf(mirrored));
                }
                partialState.setModels(new ConfiguredModel[]{new ConfiguredModel(model, angleX, angleY, true)});
            }
        }
    }

    private int getAngle(Direction dir, int offset) {
        return (int)((dir.func_185119_l() + (float)offset) % 360.0f);
    }

    public ModelFile createMetalLadder(String name, @Nullable ResourceLocation bottomTop, @Nullable ResourceLocation sides) {
        ResourceLocation parent;
        HashMap<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
        if (bottomTop != null) {
            Preconditions.checkNotNull((Object)sides);
            parent = new ResourceLocation("immersiveengineering", "block/ie_scaffoldladder");
            textures.put("top", bottomTop);
            textures.put("bottom", bottomTop);
            textures.put("side", sides);
        } else {
            parent = new ResourceLocation("immersiveengineering", "block/ie_ladder");
        }
        textures.put("ladder", new ResourceLocation("immersiveengineering", "block/metal_decoration/metal_ladder"));
        LoadedModelBuilder ret = this.loadedModels.withExistingParent(name, parent);
        if (bottomTop != null) {
            ret.transforms(IEDataGenerator.rl("item/block"));
        }
        for (Map.Entry e : textures.entrySet()) {
            ret.texture((String)e.getKey(), (ResourceLocation)e.getValue());
        }
        return ret;
    }

    private void createDirectionalBlock(Block b, IProperty<Direction> prop, ModelFile model) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        for (Direction d : Direction.field_176754_o) {
            builder.partialState().with(prop, (Comparable)d).setModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, this.getAngle(d, 180), true)});
        }
    }

    private void createWallmount(Block b, ResourceLocation texture) {
        VariantBlockStateBuilder stateBuilder = this.getVariantBuilder(b);
        for (Direction d : Direction.field_176754_o) {
            int rotation = this.getAngle(d, 0);
            for (WallmountBlock.Orientation or : WallmountBlock.Orientation.values()) {
                ResourceLocation modelLoc = IEDataGenerator.rl("block/wooden_device/wallmount" + or.modelSuffix() + ".obj");
                ModelFile model = this.obj(b.getRegistryName().func_110623_a() + or.modelSuffix(), modelLoc, (Map<String, ResourceLocation>)ImmutableMap.of((Object)"texture", (Object)texture));
                stateBuilder.partialState().with((IProperty)IEProperties.FACING_HORIZONTAL, (Comparable)d).with(WallmountBlock.ORIENTATION, (Comparable)((Object)or)).setModels(new ConfiguredModel[]{new ConfiguredModel(model, 0, rotation, true)});
            }
        }
    }

    private <T extends Comparable<T>> void forEach(VariantBlockStateBuilder.PartialBlockstate base, IProperty<T> prop, List<IProperty<?>> remaining, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        for (Comparable value : prop.func_177700_c()) {
            this.forEachState(base, remaining, map -> {
                map = map.with(prop, value);
                out.accept((VariantBlockStateBuilder.PartialBlockstate)map);
            });
        }
    }

    private void forEachState(VariantBlockStateBuilder.PartialBlockstate base, List<IProperty<?>> props, Consumer<VariantBlockStateBuilder.PartialBlockstate> out) {
        if (props.size() > 0) {
            List<IProperty<?>> remaining = props.subList(1, props.size());
            IProperty<?> main = props.get(0);
            this.forEach(base, main, remaining, out);
        } else {
            out.accept(base);
        }
    }

    private void createConnector(Block b, Function<VariantBlockStateBuilder.PartialBlockstate, ResourceLocation> model, Function<VariantBlockStateBuilder.PartialBlockstate, ImmutableMap<String, ResourceLocation>> textures, List<IProperty<?>> additional, RenderType ... layers) {
        int xForHorizontal;
        DirectionProperty facingProp;
        Preconditions.checkArgument((layers.length > 0 ? 1 : 0) != 0);
        if (b.func_176223_P().func_196959_b((IProperty)IEProperties.FACING_ALL)) {
            facingProp = IEProperties.FACING_ALL;
            xForHorizontal = 90;
        } else if (b.func_176223_P().func_196959_b((IProperty)IEProperties.FACING_TOP_DOWN)) {
            facingProp = IEProperties.FACING_TOP_DOWN;
            xForHorizontal = 90;
        } else if (b.func_176223_P().func_196959_b((IProperty)IEProperties.FACING_HORIZONTAL)) {
            facingProp = IEProperties.FACING_HORIZONTAL;
            xForHorizontal = 0;
        } else {
            facingProp = null;
            xForHorizontal = 0;
        }
        Preconditions.checkState((facingProp == null || b.func_176223_P().func_196959_b((IProperty)facingProp) ? 1 : 0) != 0, (Object)(b + " does not have " + facingProp));
        VariantBlockStateBuilder builder = this.getVariantBuilder(b);
        this.forEachState(builder.partialState(), additional, arg_0 -> this.lambda$createConnector$18(layers, (IProperty)facingProp, model, textures, builder, xForHorizontal, arg_0));
    }

    private ModelFile forConnectorModel(VariantBlockStateBuilder.PartialBlockstate state, Function<VariantBlockStateBuilder.PartialBlockstate, ResourceLocation> model, List<String> layers, Function<VariantBlockStateBuilder.PartialBlockstate, ImmutableMap<String, ResourceLocation>> textures) {
        JsonObject baseJson = new JsonObject();
        ResourceLocation modelLoc = model.apply(state);
        Optional<ResourceLocation> loader = this.guessLoader(modelLoc);
        if (!loader.isPresent()) {
            baseJson.addProperty("parent", this.EMPTY_MODEL.model.getLocation().toString());
        } else {
            baseJson.addProperty("loader", loader.get().toString());
            if (!FeedthroughLoader.LOCATION.equals((Object)loader.get())) {
                baseJson.addProperty("model", this.addModelsPrefix(modelLoc).toString());
                baseJson.addProperty("flip-v", Boolean.valueOf(true));
            }
        }
        ImmutableMap<String, ResourceLocation> texForState = textures.apply(state);
        LoadedModelBuilder ret = this.loadedModels.getBuilder(this.nameFor(state.getOwner(), modelLoc, texForState)).loader(ConnectionLoader.LOADER_NAME).additional("base_model", (JsonElement)baseJson).additional("layers", layers);
        for (Map.Entry e : texForState.entrySet()) {
            ret.texture((String)e.getKey(), (ResourceLocation)e.getValue());
        }
        if (!texForState.containsKey((Object)"particle") && loader.isPresent() && loader.get().func_110623_a().contains("obj")) {
            String particleTex = DataGenUtils.getTextureFromObj(modelLoc, this.existingFileHelper);
            if (particleTex.charAt(0) == '#') {
                particleTex = ((ResourceLocation)texForState.get((Object)particleTex.substring(1))).toString();
            }
            ret.texture("particle", particleTex);
            ret.additional("detectCullableFaces", false);
        }
        return ret;
    }

    private Optional<ResourceLocation> guessLoader(ResourceLocation modelLoc) {
        if (modelLoc.func_110623_a().endsWith(".obj")) {
            return Optional.of(this.forgeLoc("obj"));
        }
        if (modelLoc.func_110623_a().endsWith(".obj.ie")) {
            return Optional.of(this.modLoc("ie_obj"));
        }
        if (modelLoc.equals((Object)this.EMPTY_MODEL.model.getLocation())) {
            return Optional.empty();
        }
        if (modelLoc.equals((Object)FeedthroughLoader.LOCATION)) {
            return Optional.of(FeedthroughLoader.LOCATION);
        }
        throw new RuntimeException("Failed to guess loader for " + modelLoc);
    }

    private String nameFor(Block b, ResourceLocation model, ImmutableMap<String, ResourceLocation> texReplacement) {
        int index;
        Map<Map<String, ResourceLocation>, Integer> namesForModel;
        String base;
        String modelPath = model.func_110623_a();
        String blockName = b.getRegistryName().func_110623_a();
        if (modelPath.endsWith(".obj")) {
            base = modelPath.substring(0, modelPath.length() - 4);
        } else if (modelPath.endsWith(".obj.ie")) {
            base = modelPath.substring(0, modelPath.length() - 7);
        } else if (FeedthroughLoader.LOCATION.equals((Object)model)) {
            base = "feedthrough";
        } else if (this.EMPTY_MODEL.model.getLocation().equals((Object)model)) {
            base = blockName + "_empty";
        } else {
            throw new RuntimeException("Unknown model type: " + model);
        }
        if (!this.nameCache.containsKey(base)) {
            this.nameCache.put(base, new HashMap());
        }
        if ((namesForModel = this.nameCache.get(base)).containsKey(texReplacement)) {
            index = namesForModel.get(texReplacement);
        } else {
            index = namesForModel.size();
            namesForModel.put((Map<String, ResourceLocation>)texReplacement, index);
        }
        if (index == 0) {
            return base;
        }
        return base + "_" + index;
    }

    private void createConnector(Block b, Function<VariantBlockStateBuilder.PartialBlockstate, ResourceLocation> model, ImmutableMap<String, ResourceLocation> textures, List<IProperty<?>> additional, RenderType ... layers) {
        this.createConnector(b, model, (VariantBlockStateBuilder.PartialBlockstate state) -> textures, additional, layers);
    }

    private void createConnector(Block b, ResourceLocation model, ImmutableMap<String, ResourceLocation> textures, RenderType ... layers) {
        this.createConnector(b, (VariantBlockStateBuilder.PartialBlockstate map) -> model, textures, (List<IProperty<?>>)ImmutableList.of(), layers);
    }

    private ModelFile quarter(String out, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().withExistingParent(out, this.modLoc("block/ie_quarter_block"))).texture("texture", texture);
    }

    private ModelFile threeQuarter(String out, ResourceLocation texture) {
        return ((BlockModelBuilder)this.models().withExistingParent(out, this.modLoc("block/ie_three_quarter_block"))).texture("texture", texture);
    }

    private void createHemp() {
        VariantBlockStateBuilder builder = this.getVariantBuilder(IEBlocks.Misc.hempPlant);
        for (EnumHempGrowth g : EnumHempGrowth.values()) {
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("block/hemp/" + g.func_176610_l(), new ResourceLocation("block/crop"))).texture("crop", g.getTextureName());
            builder.partialState().with(HempBlock.GROWTH, (Comparable)((Object)g)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
    }

    private ModelFile createRouterModel(ResourceLocation baseTexName, String outName) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(outName, this.modLoc("block/ie_six_sides"));
        for (Direction d : Direction.field_199792_n) {
            builder.texture(d.func_176610_l(), new ResourceLocation(baseTexName.func_110624_b(), baseTexName.func_110623_a() + "_" + d.ordinal()));
        }
        builder.texture("particle", new ResourceLocation(baseTexName.func_110624_b(), baseTexName.func_110623_a() + "_0"));
        return builder;
    }

    public void assertModelExists(ResourceLocation name) {
        String suffix = name.func_110623_a().contains(".") ? "" : ".json";
        Preconditions.checkState((boolean)this.existingFileHelper.exists(name, ResourcePackType.CLIENT_RESOURCES, suffix, "models"), (Object)("Model \"" + name + "\" does not exist"));
    }

    private /* synthetic */ void lambda$createConnector$18(RenderType[] layers, IProperty facingProp, Function model, Function textures, VariantBlockStateBuilder builder, int xForHorizontal, VariantBlockStateBuilder.PartialBlockstate map) {
        List<String> layersList = Arrays.stream(layers).map(RenderType::toString).collect(Collectors.toList());
        if (facingProp != null) {
            for (Direction d : facingProp.func_177700_c()) {
                if (d == Direction.DOWN) {
                    VariantBlockStateBuilder.PartialBlockstate downState = map.with(facingProp, (Comparable)Direction.DOWN);
                    ModelFile downModel = this.forConnectorModel(downState, model, layersList, textures);
                    builder.setModels(downState, new ConfiguredModel[]{new ConfiguredModel(downModel, xForHorizontal - 90, 0, true)});
                    continue;
                }
                if (d == Direction.UP) {
                    VariantBlockStateBuilder.PartialBlockstate upState = map.with(facingProp, (Comparable)Direction.UP);
                    ModelFile upModel = this.forConnectorModel(upState, model, layersList, textures);
                    builder.setModels(upState, new ConfiguredModel[]{new ConfiguredModel(upModel, xForHorizontal + 90, 0, true)});
                    continue;
                }
                int rotation = this.getAngle(d, 0);
                VariantBlockStateBuilder.PartialBlockstate dState = map.with(facingProp, (Comparable)d);
                ModelFile connFile = this.forConnectorModel(dState, model, layersList, textures);
                builder.setModels(dState, new ConfiguredModel[]{new ConfiguredModel(connFile, xForHorizontal, rotation, true)});
            }
        } else {
            ModelFile connFile = this.forConnectorModel(map, model, layersList, textures);
            builder.setModels(map, new ConfiguredModel[]{new ConfiguredModel(connFile, 0, 0, true)});
        }
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$7(ModelFile full, VariantBlockStateBuilder.PartialBlockstate state) {
        return full;
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$6(ModelFile kineticDynamo, VariantBlockStateBuilder.PartialBlockstate state) {
        return kineticDynamo;
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$5(ModelFile furnaceHeaterOn, ModelFile furnaceHeaterOff, VariantBlockStateBuilder.PartialBlockstate props) {
        if (props.getSetStates().get((Object)IEProperties.ACTIVE) == Boolean.TRUE) {
            return furnaceHeaterOn;
        }
        return furnaceHeaterOff;
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$3(ModelFile batcherModel, VariantBlockStateBuilder.PartialBlockstate s) {
        return batcherModel;
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$0(ModelFile turntableModel, VariantBlockStateBuilder.PartialBlockstate s) {
        return turntableModel;
    }
}

