/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RGBColourationRecipe
implements ICraftingRecipe {
    private final Ingredient target;
    private final String colorKey;
    private final ResourceLocation id;

    public RGBColourationRecipe(Ingredient target, String colorKey, ResourceLocation id) {
        this.target = target;
        this.colorKey = colorKey;
        this.id = id;
    }

    public boolean matches(CraftingInventory inv, @Nonnull World world) {
        ItemStack itemToColour = ItemStack.field_190927_a;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (itemToColour.func_190926_b() && this.target.test(stackInSlot)) {
                itemToColour = stackInSlot;
                continue;
            }
            if (Utils.isDye(stackInSlot)) {
                list.add(stackInSlot);
                continue;
            }
            return false;
        }
        return !itemToColour.func_190926_b() && !list.isEmpty();
    }

    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        int[] colourArray = new int[3];
        int j = 0;
        int totalColourSets = 0;
        ItemStack itemToColour = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b()) continue;
            if (itemToColour.func_190926_b() && this.target.test(stackInSlot)) {
                itemToColour = stackInSlot;
                int colour = itemToColour.func_77942_o() && itemToColour.func_196082_o().func_150297_b(this.colorKey, 3) ? itemToColour.func_196082_o().func_74762_e(this.colorKey) : 0xFFFFFF;
                float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                float b = (float)(colour & 0xFF) / 255.0f;
                j = (int)((float)j + Math.max(r, Math.max(g, b)) * 255.0f);
                colourArray[0] = (int)((float)colourArray[0] + r * 255.0f);
                colourArray[1] = (int)((float)colourArray[1] + g * 255.0f);
                colourArray[2] = (int)((float)colourArray[2] + b * 255.0f);
                ++totalColourSets;
                continue;
            }
            if (!Utils.isDye(stackInSlot)) continue;
            float[] afloat = SheepEntity.func_175513_a((DyeColor)Utils.getDye(stackInSlot));
            int r = (int)(afloat[0] * 255.0f);
            int g = (int)(afloat[1] * 255.0f);
            int b = (int)(afloat[2] * 255.0f);
            j += Math.max(r, Math.max(g, b));
            colourArray[0] = colourArray[0] + r;
            colourArray[1] = colourArray[1] + g;
            colourArray[2] = colourArray[2] + b;
            ++totalColourSets;
        }
        if (!itemToColour.func_190926_b()) {
            ItemStack newItem = Utils.copyStackWithAmount(itemToColour, 1);
            int r = colourArray[0] / totalColourSets;
            int g = colourArray[1] / totalColourSets;
            int b = colourArray[2] / totalColourSets;
            float colourMod = (float)j / (float)totalColourSets;
            float highestColour = Math.max(r, Math.max(g, b));
            r = (int)((float)r * colourMod / highestColour);
            g = (int)((float)g * colourMod / highestColour);
            b = (int)((float)b * colourMod / highestColour);
            int newColour = (r << 8) + g;
            newColour = (newColour << 8) + b;
            newItem.func_196082_o().func_74768_a(this.colorKey, newColour);
            return newItem;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializers.RGB_SERIALIZER.get();
    }

    public Ingredient getTarget() {
        return this.target;
    }

    public String getColorKey() {
        return this.colorKey;
    }
}

