/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.crafting.MetalPressPackingRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;

public class MetalPressUnpackingRecipe
extends MetalPressRecipe {
    private final int baseEnergy;
    private HashMap<ComparableItemStack, PackedDelegate> cache = new HashMap();

    public MetalPressUnpackingRecipe(ComparableItemStack mold, int energy) {
        super(null, ItemStack.field_190927_a, new IngredientWithSize(Ingredient.field_193370_a), mold, energy);
        this.baseEnergy = energy;
    }

    @Override
    public boolean listInJEI() {
        return false;
    }

    @Override
    public boolean matches(ItemStack mold, ItemStack input, World world) {
        return this.getOutputCached(input, world) != null;
    }

    @Override
    public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input, World world) {
        return this.getOutputCached(input, world);
    }

    private PackedDelegate getOutputCached(ItemStack input, World world) {
        ComparableItemStack comp = new ComparableItemStack(input, false);
        if (this.cache.containsKey(comp)) {
            return this.cache.get(comp);
        }
        comp.copy();
        ItemStack out = MetalPressPackingRecipe.getPackedOutput(1, 1, input, world);
        int count = out.func_190916_E();
        if (count != 4 && count != 9) {
            this.cache.put(comp, null);
            return null;
        }
        ItemStack rePacked = MetalPressPackingRecipe.getPackedOutput(count == 4 ? 2 : 3, count, out, world);
        if (rePacked.func_190926_b() || !ItemStack.func_77989_b((ItemStack)input, (ItemStack)rePacked)) {
            this.cache.put(comp, null);
            return null;
        }
        PackedDelegate delegate = new PackedDelegate(comp, out, Utils.copyStackWithAmount(input, 1), this.mold, this.baseEnergy);
        this.cache.put(comp, delegate);
        return delegate;
    }

    public static class PackedDelegate
    extends MetalPressRecipe {
        private final ComparableItemStack mapKey;

        public PackedDelegate(ComparableItemStack mapKey, ItemStack output, ItemStack input, ComparableItemStack mold, int energy) {
            super(null, output, IngredientWithSize.of(input), mold, energy);
            this.mapKey = mapKey;
        }

        @Override
        public boolean listInJEI() {
            return false;
        }
    }
}

