/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.HashMap;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class MetalPressPackingRecipe
extends MetalPressRecipe {
    private final int gridSize;
    private final int totalAmount;
    private final int baseEnergy;
    private HashMap<ComparableItemStack, PackedDelegate> cache = new HashMap();

    public MetalPressPackingRecipe(ComparableItemStack mold, int energy, int gridSize) {
        super(null, ItemStack.field_190927_a, new IngredientWithSize(Ingredient.field_193370_a), mold, energy);
        this.gridSize = gridSize;
        this.totalAmount = gridSize * gridSize;
        this.baseEnergy = energy;
    }

    @Override
    public boolean listInJEI() {
        return false;
    }

    @Override
    public boolean matches(ItemStack mold, ItemStack input, World world) {
        return input.func_190916_E() >= this.totalAmount && this.getOutputCached(input, world) != null;
    }

    @Override
    public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input, World world) {
        return this.getOutputCached(input, world);
    }

    private PackedDelegate getOutputCached(ItemStack input, World world) {
        ComparableItemStack comp = new ComparableItemStack(input, false);
        if (this.cache.containsKey(comp)) {
            return this.cache.get(comp);
        }
        comp.copy();
        ItemStack out = MetalPressPackingRecipe.getPackedOutput(this.gridSize, this.totalAmount, input, world);
        if (out.func_190926_b()) {
            this.cache.put(comp, null);
            return null;
        }
        PackedDelegate delegate = new PackedDelegate(comp, out, Utils.copyStackWithAmount(input, this.totalAmount), this.mold, this.baseEnergy);
        this.cache.put(comp, delegate);
        return delegate;
    }

    public static ItemStack getPackedOutput(int gridSize, int totalAmount, ItemStack stack, World world) {
        CraftingInventory invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(gridSize, gridSize, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)totalAmount, (Object)stack.func_77946_l()));
        return world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)invC, world).map(recipe -> recipe.func_77572_b((IInventory)invC)).orElse(ItemStack.field_190927_a);
    }

    public static class PackedDelegate
    extends MetalPressRecipe {
        private final ComparableItemStack mapKey;

        public PackedDelegate(ComparableItemStack mapKey, ItemStack output, ItemStack input, ComparableItemStack mold, int energy) {
            super(null, output, IngredientWithSize.of(input), mold, energy);
            this.mapKey = mapKey;
        }

        @Override
        public boolean listInJEI() {
            return false;
        }
    }
}

