/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.models.obj.IESmartObjModel;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class BucketWheelRenderer
extends TileEntityRenderer<BucketWheelTileEntity> {
    private final DynamicModel<Void> wheel = DynamicModel.createSimple(new ResourceLocation("immersiveengineering", "block/metal_multiblock/bucket_wheel.obj.ie"), "bucket_wheel", DynamicModel.ModelType.IE_OBJ);

    public BucketWheelRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(BucketWheelTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.formed || !tile.getWorldNonnull().func_175667_e(tile.func_174877_v()) || tile.isDummy()) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockState state = tile.getWorldNonnull().func_180495_p(tile.func_174877_v());
        if (state.func_177230_c() != IEBlocks.Multiblocks.bucketWheel) {
            return;
        }
        IBakedModel model = this.wheel.get(null);
        HashMap<String, String> texMap = new HashMap<String, String>();
        ArrayList list = Lists.newArrayList((Object[])new String[]{"bucketWheel"});
        NonNullList<ItemStack> nonNullList = tile.digStacks;
        synchronized (nonNullList) {
            for (int i = 0; i < tile.digStacks.size(); ++i) {
                if (((ItemStack)tile.digStacks.get(i)).func_190926_b()) continue;
                list.add("dig" + i);
                Block b = Block.func_149634_a((Item)((ItemStack)tile.digStacks.get(i)).func_77973_b());
                BlockState digState = b != Blocks.field_150350_a ? b.func_176223_P() : Blocks.field_150347_e.func_176223_P();
                IBakedModel digModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(digState);
                digModel.func_177554_e();
                texMap.put("dig" + i, digModel.func_177554_e().func_195668_m().toString());
            }
        }
        IEProperties.IEObjState objState = new IEProperties.IEObjState(IEProperties.VisibilityList.show(list));
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        Direction facing = tile.getFacing();
        if (tile.getIsMirrored()) {
            matrixStack.func_227862_a_(facing.func_176740_k() == Direction.Axis.X ? -1.0f : 1.0f, 1.0f, facing.func_176740_k() == Direction.Axis.Z ? -1.0f : 1.0f);
        }
        float dir = tile.getFacing() == Direction.SOUTH ? 90.0f : (tile.getFacing() == Direction.NORTH ? -90.0f : (tile.getFacing() == Direction.EAST ? 180.0f : 0.0f));
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), dir, true));
        float rot = tile.rotation + (float)(tile.active ? (Double)IEConfig.MACHINES.excavator_speed.get() * (double)partialTicks : 0.0);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), rot, true));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228639_c_());
        SinglePropertyModelData<IOBJModelCallback> modelData = new SinglePropertyModelData<IOBJModelCallback>(tile, IOBJModelCallback.PROPERTY);
        List<BakedQuad> quads = model instanceof IESmartObjModel ? ((IESmartObjModel)model).getQuads(state, null, 0L, objState, texMap, true, modelData) : model.getQuads(state, null, Utils.RAND, modelData);
        ClientUtils.renderModelTESRFast(quads, builder, matrixStack, combinedLightIn);
        matrixStack.func_227865_b_();
    }
}

