/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.client.model.obj.MaterialLibrary;
import net.minecraftforge.client.model.obj.OBJModel;
import org.apache.commons.lang3.tuple.Pair;

public class OBJHelper {
    private static Field OBJModel2_parts;
    private static Field OBJModel2_texCoords;
    private static Method OBJModel2_makeQuad;
    private static Field ModelGroup_parts;
    private static Field ModelObject_meshes;
    private static Class<?> ModelMesh;
    private static Field ModelMesh_faces;
    private static Field ModelMesh_mat;

    public static Map<String, OBJModel.ModelGroup> getGroups(OBJModel model) {
        return (Map)OBJHelper.get(OBJModel2_parts, model);
    }

    public static List<Vec2f> getTexCoords(OBJModel model) {
        return (List)OBJHelper.get(OBJModel2_texCoords, model);
    }

    public static Map<String, OBJModel.ModelObject> getParts(OBJModel.ModelGroup group) {
        return (Map)OBJHelper.get(ModelGroup_parts, group);
    }

    public static List<OBJModel.ModelObject> getRecursiveParts(OBJModel model) {
        ArrayList<OBJModel.ModelObject> ret = new ArrayList<OBJModel.ModelObject>();
        ArrayDeque<OBJModel.ModelGroup> toExtract = new ArrayDeque<OBJModel.ModelGroup>(OBJHelper.getGroups(model).values());
        while (ret.size() < 1024 && !toExtract.isEmpty()) {
            OBJModel.ModelGroup next = (OBJModel.ModelGroup)toExtract.pop();
            for (OBJModel.ModelObject object : OBJHelper.getParts(next).values()) {
                if (object instanceof OBJModel.ModelGroup) {
                    toExtract.push((OBJModel.ModelGroup)object);
                    continue;
                }
                ret.add(object);
            }
        }
        return ret;
    }

    public static List<MeshWrapper> getMeshes(OBJModel.ModelObject object) {
        List meshes = (List)OBJHelper.get(ModelObject_meshes, object);
        ArrayList<MeshWrapper> ret = new ArrayList<MeshWrapper>();
        for (Object o : meshes) {
            ret.add(new MeshWrapper(o));
        }
        return ret;
    }

    public static Pair<BakedQuad, Direction> makeQuad(OBJModel model, int[][] indices, int tintIndex, Vector4f colorTint, Vector4f ambientColor, TextureAtlasSprite texture, TransformationMatrix transform) {
        return (Pair)OBJHelper.invoke(OBJModel2_makeQuad, model, new Object[]{indices, tintIndex, colorTint, ambientColor, texture, transform});
    }

    private static <T> T get(Field f, Object e) {
        try {
            return (T)f.get(e);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static <T> T invoke(Method m, Object e, Object ... args) {
        try {
            return (T)m.invoke(e, args);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            OBJModel2_parts = OBJModel.class.getDeclaredField("parts");
            OBJModel2_parts.setAccessible(true);
            OBJModel2_texCoords = OBJModel.class.getDeclaredField("texCoords");
            OBJModel2_texCoords.setAccessible(true);
            OBJModel2_makeQuad = OBJModel.class.getDeclaredMethod("makeQuad", int[][].class, Integer.TYPE, Vector4f.class, Vector4f.class, TextureAtlasSprite.class, TransformationMatrix.class);
            OBJModel2_makeQuad.setAccessible(true);
            ModelGroup_parts = OBJModel.ModelGroup.class.getDeclaredField("parts");
            ModelGroup_parts.setAccessible(true);
            ModelObject_meshes = OBJModel.ModelObject.class.getDeclaredField("meshes");
            ModelObject_meshes.setAccessible(true);
            ModelMesh = Class.forName("net.minecraftforge.client.model.obj.OBJModel$ModelMesh");
            ModelMesh_faces = ModelMesh.getDeclaredField("faces");
            ModelMesh_faces.setAccessible(true);
            ModelMesh_mat = ModelMesh.getDeclaredField("mat");
            ModelMesh_mat.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException("Incompatible Forge version!");
        }
    }

    public static class MeshWrapper {
        private final Object mesh;

        private MeshWrapper(Object mesh) {
            Preconditions.checkArgument((boolean)ModelMesh.isInstance(mesh));
            this.mesh = mesh;
        }

        public List<int[][]> getFaces() {
            return (List)OBJHelper.get(ModelMesh_faces, this.mesh);
        }

        public MaterialLibrary.Material getMaterial() {
            return (MaterialLibrary.Material)OBJHelper.get(ModelMesh_mat, this.mesh);
        }
    }
}

