/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.elements;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class GuiButtonState<E>
extends GuiButtonIE {
    public E[] states;
    private int state;
    protected final int offsetDir;
    public int[] textOffset = new int[]{0, 0};

    public GuiButtonState(int x, int y, int w, int h, String name, E[] states, int initialState, String texture, int u, int v, int offsetDir, GuiButtonIE.IIEPressable<GuiButtonState<E>> handler) {
        super(x, y, w, h, name, texture, u, v, handler);
        this.states = states;
        this.state = initialState;
        this.offsetDir = offsetDir;
        this.textOffset = new int[]{this.width + 1, this.height / 2 - 3};
    }

    protected int getNextStateInt() {
        return (this.state + 1) % this.states.length;
    }

    public E getNextState() {
        return this.states[this.getNextStateInt()];
    }

    public E getState() {
        return this.states[this.state];
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.visible) {
            ClientUtils.bindTexture(this.texture);
            FontRenderer fontrenderer = mc.field_71466_p;
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            RenderSystem.blendFunc((int)770, (int)771);
            int u = this.texU + (this.offsetDir == 0 ? this.width : (this.offsetDir == 2 ? -this.width : 0)) * this.state;
            int v = this.texV + (this.offsetDir == 1 ? this.height : (this.offsetDir == 3 ? -this.height : 0)) * this.state;
            this.blit(this.x, this.y, u, v, this.width, this.height);
            if (!this.getMessage().isEmpty()) {
                int txtCol = 0xE0E0E0;
                if (!this.active) {
                    txtCol = 0xA0A0A0;
                } else if (this.isHovered) {
                    txtCol = -557004;
                }
                this.drawString(fontrenderer, this.getMessage(), this.x + this.textOffset[0], this.y + this.textOffset[1], txtCol);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int key) {
        boolean b = super.mouseClicked(mouseX, mouseY, key);
        if (b) {
            this.state = this.getNextStateInt();
        }
        return b;
    }
}

