/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.localhandlers;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.utils.BinaryHeap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMaps;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class EnergyTransferHandler
extends LocalNetworkHandler
implements IWorldTickable {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "energy_transfer");
    private final Table<ConnectionPoint, ConnectionPoint, Path> energyPaths = HashBasedTable.create();
    private Object2DoubleMap<Connection> transferredNextTick = new Object2DoubleOpenHashMap();
    private Object2DoubleMap<Connection> transferredLastTick = new Object2DoubleOpenHashMap();
    private final Map<ConnectionPoint, EnergyConnector> sources = new HashMap<ConnectionPoint, EnergyConnector>();
    private final Map<ConnectionPoint, EnergyConnector> sinks = new HashMap<ConnectionPoint, EnergyConnector>();
    private boolean uninitialised = true;

    public EnergyTransferHandler(LocalWireNetwork net) {
        super(net);
    }

    @Override
    public LocalNetworkHandler merge(LocalNetworkHandler other) {
        this.reset();
        return this;
    }

    @Override
    public void onConnectorLoaded(ConnectionPoint p, IImmersiveConnectable iic) {
        this.reset();
    }

    @Override
    public void onConnectorUnloaded(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    @Override
    public void onConnectorRemoved(BlockPos p, IImmersiveConnectable iic) {
        this.reset();
    }

    @Override
    public void onConnectionAdded(Connection c) {
        this.reset();
    }

    @Override
    public void onConnectionRemoved(Connection c) {
        this.reset();
    }

    @Override
    public void update(World w) {
        if (this.uninitialised) {
            this.calcPaths();
        }
        this.transferPower();
        this.burnOverloaded(w);
        this.transferredLastTick = this.transferredNextTick;
        this.transferredNextTick = new Object2DoubleOpenHashMap();
    }

    public Object2DoubleMap<Connection> getTransferredNextTick() {
        return this.transferredNextTick;
    }

    public Object2DoubleMap<Connection> getTransferredLastTick() {
        return Object2DoubleMaps.unmodifiable(this.transferredLastTick);
    }

    private void reset() {
        this.energyPaths.clear();
        this.transferredNextTick.clear();
        this.transferredLastTick.clear();
        this.sinks.clear();
        this.sources.clear();
        this.uninitialised = true;
    }

    public Map<ConnectionPoint, EnergyConnector> getSources() {
        if (this.uninitialised) {
            this.calcPaths();
        }
        return this.sources;
    }

    @Nullable
    public Path getPath(ConnectionPoint source, ConnectionPoint sink) {
        if (this.uninitialised) {
            this.calcPaths();
        }
        if (this.sources.containsKey(source) && this.sinks.containsKey(sink)) {
            return (Path)this.energyPaths.get((Object)source, (Object)sink);
        }
        Path[] ret = new Path[]{null};
        this.runDijkstraWithSource(source, p -> {
            if (p.end.equals(sink)) {
                ret[0] = p;
                return true;
            }
            return false;
        });
        return ret[0];
    }

    private void calcPaths() {
        this.uninitialised = false;
        this.energyPaths.clear();
        for (ConnectionPoint cp : this.net.getConnectionPoints()) {
            IImmersiveConnectable iic = this.net.getConnector(cp);
            if (!(iic instanceof EnergyConnector)) continue;
            EnergyConnector energyIIC = (EnergyConnector)iic;
            if (energyIIC.isSink(cp)) {
                this.sinks.put(cp, energyIIC);
            }
            if (!energyIIC.isSource(cp)) continue;
            this.sources.put(cp, energyIIC);
        }
        if (this.sources.isEmpty() || this.sinks.isEmpty()) {
            return;
        }
        for (ConnectionPoint source : this.sources.keySet()) {
            this.runDijkstraWithSource(source, p -> {
                this.energyPaths.put((Object)source, (Object)p.end, p);
                return false;
            });
        }
    }

    private void runDijkstraWithSource(ConnectionPoint source, Predicate<Path> stopAfter) {
        HashMap<ConnectionPoint, Path> shortestKnown = new HashMap<ConnectionPoint, Path>();
        BinaryHeap<ConnectionPoint> heap = new BinaryHeap<ConnectionPoint>(Comparator.comparingDouble(end -> ((Path)shortestKnown.get((Object)end)).loss));
        HashMap<ConnectionPoint, BinaryHeap.HeapEntry<ConnectionPoint>> entryMap = new HashMap<ConnectionPoint, BinaryHeap.HeapEntry<ConnectionPoint>>();
        shortestKnown.put(source, new Path(source));
        entryMap.put(source, heap.insert(source));
        while (!heap.empty()) {
            ConnectionPoint endPoint = heap.extractMin();
            entryMap.remove(endPoint);
            Path shortest = (Path)shortestKnown.get(endPoint);
            if (stopAfter.test(shortest)) {
                return;
            }
            if (shortest.loss >= 1.0) break;
            for (Connection next : this.net.getConnections(endPoint)) {
                Path alternative = shortest.append(next, this.sinks.containsKey(next.getOtherEnd(shortest.end)));
                if (!shortestKnown.containsKey(alternative.end)) {
                    shortestKnown.put(alternative.end, alternative);
                    entryMap.put(alternative.end, heap.insert(alternative.end));
                    continue;
                }
                Path oldPath = (Path)shortestKnown.get(alternative.end);
                if (!(alternative.loss < oldPath.loss)) continue;
                shortestKnown.put(alternative.end, alternative);
                heap.decreaseKey((BinaryHeap.HeapEntry)entryMap.get(alternative.end));
            }
        }
    }

    private void transferPower() {
        for (ConnectionPoint sourceCp : this.energyPaths.rowKeySet()) {
            EnergyConnector source = this.sources.get(sourceCp);
            int available = source.getAvailableEnergy();
            if (available <= 0) continue;
            double maxSum = 0.0;
            Object2DoubleOpenHashMap maxOut = new Object2DoubleOpenHashMap();
            for (Path p : this.energyPaths.row((Object)sourceCp).values()) {
                EnergyConnector end;
                int requested;
                if (!p.isPathToSink || (requested = (end = this.sinks.get(p.end)).getRequestedEnergy()) <= 0) continue;
                double requiredAtSource = Math.min((double)requested / (1.0 - p.loss), (double)available);
                maxOut.put((Object)p, requiredAtSource);
                maxSum += requiredAtSource;
            }
            double allowedFactor = Math.min(1.0, (double)available / maxSum);
            for (Path p : maxOut.keySet()) {
                double atSource = allowedFactor * maxOut.getDouble((Object)p);
                double currentLoss = 0.0;
                ConnectionPoint currentPoint = sourceCp;
                for (Connection c : p.conns) {
                    IImmersiveConnectable iic;
                    currentPoint = c.getOtherEnd(currentPoint);
                    double availableAtPoint = atSource * (1.0 - (currentLoss += EnergyTransferHandler.getBasicLoss(c)));
                    double transferred = this.transferredNextTick.getDouble((Object)c);
                    this.transferredNextTick.put((Object)c, transferred + availableAtPoint);
                    if (currentPoint.equals(p.end) || !((iic = this.net.getConnector(currentPoint)) instanceof EnergyConnector)) continue;
                    ((EnergyConnector)iic).onEnergyPassedThrough(availableAtPoint);
                }
                EnergyConnector sink = this.sinks.get(p.end);
                sink.insertEnergy((int)(atSource * (1.0 - currentLoss)));
            }
            if (allowedFactor < 1.0) {
                source.extractEnergy(available);
                continue;
            }
            source.extractEnergy(MathHelper.func_76143_f((double)maxSum));
        }
    }

    private void burnOverloaded(World world) {
        ArrayList<ImmutablePair> toBurn = new ArrayList<ImmutablePair>();
        for (Connection connection : this.transferredNextTick.keySet()) {
            double transferred = this.transferredNextTick.getDouble((Object)connection);
            if (!(connection.type instanceof IEnergyWire) || !((IEnergyWire)((Object)connection.type)).shouldBurn(connection, transferred)) continue;
            toBurn.add(new ImmutablePair((Object)connection, (Object)transferred));
        }
        for (Pair pair : toBurn) {
            ((IEnergyWire)((Object)((Connection)pair.getLeft()).type)).burn((Connection)pair.getLeft(), (Double)pair.getRight(), this.net.getGlobal(), world);
        }
    }

    private static double getBasicLoss(Connection c) {
        if (c.isInternal()) {
            return 0.0;
        }
        if (c.type instanceof IEnergyWire) {
            return ((IEnergyWire)((Object)c.type)).getBasicLossRate(c);
        }
        return Double.POSITIVE_INFINITY;
    }

    public static interface EnergyConnector
    extends IImmersiveConnectable {
        public boolean isSource(ConnectionPoint var1);

        public boolean isSink(ConnectionPoint var1);

        default public int getAvailableEnergy() {
            return 0;
        }

        default public int getRequestedEnergy() {
            return 0;
        }

        default public void insertEnergy(int amount) {
        }

        default public void extractEnergy(int amount) {
        }

        default public void onEnergyPassedThrough(double amount) {
        }
    }

    public static interface IEnergyWire {
        public int getTransferRate();

        public double getBasicLossRate(Connection var1);

        public double getLossRate(Connection var1, int var2);

        default public boolean shouldBurn(Connection c, double power) {
            return power > (double)this.getTransferRate();
        }

        default public void burn(Connection c, double power, GlobalWireNetwork net, World w) {
            net.removeConnection(c);
        }
    }

    public static class Path {
        public final Connection[] conns;
        public final ConnectionPoint start;
        public final ConnectionPoint end;
        public final double loss;
        public final boolean isPathToSink;

        private Path(Connection[] conns, ConnectionPoint start, ConnectionPoint end, double loss, boolean isPathToSink) {
            this.conns = conns;
            this.start = start;
            this.end = end;
            this.loss = loss;
            this.isPathToSink = isPathToSink;
        }

        public Path(ConnectionPoint point) {
            this(new Connection[0], point, point, 0.0, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return Arrays.equals(this.conns, path.conns);
        }

        public int hashCode() {
            return Arrays.hashCode(this.conns);
        }

        public Path append(Connection next, boolean isPathToSink) {
            ConnectionPoint newEnd = next.getOtherEnd(this.end);
            double newLoss = this.loss + EnergyTransferHandler.getBasicLoss(next);
            Connection[] newPath = Arrays.copyOf(this.conns, this.conns.length + 1);
            newPath[newPath.length - 1] = next;
            return new Path(newPath, this.start, newEnd, newLoss, isPathToSink);
        }
    }
}

