/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.SafeChunkUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class NetworkSanitizer {
    private static final Map<IWorld, Set<ChunkPos>> toSanitize = new WeakHashMap<IWorld, Set<ChunkPos>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tick(IWorld w, GlobalWireNetwork global) {
        Map<IWorld, Set<ChunkPos>> map = toSanitize;
        synchronized (map) {
            Set<ChunkPos> relevant = toSanitize.get(w);
            if (relevant == null) {
                return;
            }
            Iterator<ChunkPos> iterator = relevant.iterator();
            while (iterator.hasNext()) {
                ChunkPos chunk = iterator.next();
                if (!SafeChunkUtils.isChunkSafe(w, chunk)) continue;
                ArrayList<ConnectionPoint> extraCPs = new ArrayList<ConnectionPoint>();
                HashSet<BlockPos> missingConnectors = new HashSet<BlockPos>();
                for (ConnectionPoint cp : global.getAllConnectorsIn(chunk)) {
                    if (missingConnectors.contains(cp.getPosition())) continue;
                    TileEntity inWorld = w.func_175625_s(cp.getPosition());
                    if (!(inWorld instanceof IImmersiveConnectable)) {
                        missingConnectors.add(cp.getPosition());
                        continue;
                    }
                    IImmersiveConnectable iicWorld = (IImmersiveConnectable)inWorld;
                    if (iicWorld.getConnectionPoints().contains(cp)) continue;
                    extraCPs.add(cp);
                }
                for (ConnectionPoint cp : extraCPs) {
                    global.removeCP(cp);
                }
                for (BlockPos pos : missingConnectors) {
                    global.removeConnector(pos);
                }
                if (!extraCPs.isEmpty() || !missingConnectors.isEmpty()) {
                    IELogger.logger.info("Removed {} extra connection points and {} missing connectors", (Object)extraCPs.size(), (Object)missingConnectors.size());
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void chunkLoad(ChunkEvent.Load ev) {
        Map<IWorld, Set<ChunkPos>> map = toSanitize;
        synchronized (map) {
            toSanitize.computeIfAbsent(ev.getWorld(), w -> new HashSet()).add(ev.getChunk().func_76632_l());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void chunkUnload(ChunkEvent.Unload ev) {
        Map<IWorld, Set<ChunkPos>> map = toSanitize;
        synchronized (map) {
            Set<ChunkPos> forWorld = toSanitize.get(ev.getWorld());
            if (forWorld != null) {
                forWorld.remove(ev.getChunk().func_76632_l());
            }
        }
    }
}

