/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.RegistryObject;

public class RefineryRecipe
extends MultiblockRecipe {
    public static IRecipeType<RefineryRecipe> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:refinery");
    public static RegistryObject<IERecipeSerializer<RefineryRecipe>> SERIALIZER;
    public static float energyModifier;
    public static float timeModifier;
    public final FluidStack output;
    public final FluidStack input0;
    public final FluidStack input1;
    public static Map<ResourceLocation, RefineryRecipe> recipeList;

    public RefineryRecipe(ResourceLocation id, FluidStack output, FluidStack input0, FluidStack input1, int energy) {
        super(ItemStack.field_190927_a, TYPE, id);
        this.output = output;
        this.input0 = input0;
        this.input1 = input1;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor(1.0f * timeModifier);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidStack[]{this.input0, this.input1});
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.output});
    }

    @Override
    protected IERecipeSerializer<RefineryRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public static RefineryRecipe findRecipe(FluidStack input0, FluidStack input1) {
        for (RefineryRecipe recipe : recipeList.values()) {
            if (input0 != null) {
                if (recipe.input0 != null && input0.containsFluid(recipe.input0) && (recipe.input1 == null && input1 == null || recipe.input1 != null && input1 != null && input1.containsFluid(recipe.input1))) {
                    return recipe;
                }
                if (recipe.input1 == null || !input0.containsFluid(recipe.input1) || (recipe.input0 != null || input1 != null) && (recipe.input0 == null || input1 == null || !input1.containsFluid(recipe.input0))) continue;
                return recipe;
            }
            if (input1 == null) continue;
            if (recipe.input0 != null && input1.containsFluid(recipe.input0) && recipe.input1 == null) {
                return recipe;
            }
            if (recipe.input1 == null || !input1.containsFluid(recipe.input1) || recipe.input0 != null) continue;
            return recipe;
        }
        return null;
    }

    public static Optional<RefineryRecipe> findIncompleteRefineryRecipe(@Nonnull FluidStack input0, @Nonnull FluidStack input1) {
        if (input0.isEmpty() && input1.isEmpty()) {
            return Optional.empty();
        }
        for (RefineryRecipe recipe : recipeList.values()) {
            if (!(!input0.isEmpty() && input1.isEmpty() ? input0.isFluidEqual(recipe.input0) || input0.isFluidEqual(recipe.input1) : (input0.isEmpty() && !input1.isEmpty() ? input1.isFluidEqual(recipe.input0) || input1.isFluidEqual(recipe.input1) : input0.isFluidEqual(recipe.input0) && input1.isFluidEqual(recipe.input1) || input0.isFluidEqual(recipe.input1) && input1.isFluidEqual(recipe.input0)))) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        energyModifier = 1.0f;
        timeModifier = 1.0f;
    }
}

