/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.util.ListUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class MetalPressRecipe
extends MultiblockRecipe {
    public static IRecipeType<MetalPressRecipe> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:metal_press");
    public static RegistryObject<IERecipeSerializer<MetalPressRecipe>> SERIALIZER;
    public static float energyModifier;
    public static float timeModifier;
    public IngredientWithSize input;
    public final ComparableItemStack mold;
    public final ItemStack output;
    public static Map<ResourceLocation, MetalPressRecipe> recipeList;
    private static ArrayListMultimap<ComparableItemStack, MetalPressRecipe> recipesByMold;

    public MetalPressRecipe(ResourceLocation id, ItemStack output, IngredientWithSize input, ComparableItemStack mold, int energy) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.mold = mold;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor(120.0f * timeModifier);
        this.setInputListWithSizes(Lists.newArrayList((Object[])new IngredientWithSize[]{this.input}));
        this.outputList = ListUtils.fromItem(this.output);
    }

    @Override
    protected IERecipeSerializer<MetalPressRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public MetalPressRecipe setInputSize(int size) {
        this.input = new IngredientWithSize(this.input.getBaseIngredient(), size);
        return this;
    }

    @Override
    public void setupJEI() {
        super.setupJEI();
        this.jeiItemInputList = new ArrayList[2];
        this.jeiItemInputList[0] = Lists.newArrayList((Iterable)this.jeiTotalItemInputList);
        this.jeiItemInputList[1] = Lists.newArrayList((Object[])new ItemStack[]{this.mold.stack});
        this.jeiTotalItemInputList.add(this.mold.stack);
    }

    public boolean matches(ItemStack mold, ItemStack input, World world) {
        return this.input.test(input);
    }

    public MetalPressRecipe getActualRecipe(ItemStack mold, ItemStack input, World world) {
        return this;
    }

    public static void updateRecipesByMold() {
        recipesByMold = ArrayListMultimap.create();
        recipeList.values().forEach(recipe -> recipesByMold.put((Object)recipe.mold, recipe));
    }

    public static MetalPressRecipe findRecipe(ItemStack mold, ItemStack input, World world) {
        if (mold.func_190926_b() || input.func_190926_b()) {
            return null;
        }
        ComparableItemStack comp = ApiUtils.createComparableItemStack(mold, false);
        List list = recipesByMold.get((Object)comp);
        for (MetalPressRecipe recipe : list) {
            if (!recipe.matches(mold, input, world)) continue;
            return recipe.getActualRecipe(mold, input, world);
        }
        return null;
    }

    public static List<MetalPressRecipe> removeRecipes(ItemStack output) {
        ArrayList<MetalPressRecipe> list = new ArrayList<MetalPressRecipe>();
        HashSet keySet = new HashSet(recipesByMold.keySet());
        for (ComparableItemStack mold : keySet) {
            Iterator it = recipesByMold.get((Object)mold).iterator();
            while (it.hasNext()) {
                MetalPressRecipe ir = (MetalPressRecipe)it.next();
                if (!ItemStack.func_179545_c((ItemStack)ir.output, (ItemStack)output)) continue;
                list.add(ir);
                it.remove();
            }
        }
        return list;
    }

    public static boolean isValidMold(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return recipesByMold.containsKey((Object)ApiUtils.createComparableItemStack(itemStack, false));
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        energyModifier = 1.0f;
        timeModifier = 1.0f;
    }
}

