/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughTileEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.data.ModelProperty;

public class IEProperties {
    public static final DirectionProperty FACING_ALL = DirectionProperty.func_196962_a((String)"facing", (Direction[])Direction.field_199792_n);
    public static final DirectionProperty FACING_HORIZONTAL = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final DirectionProperty FACING_TOP_DOWN = DirectionProperty.func_196962_a((String)"facing", (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    public static final PropertyBoolInverted MULTIBLOCKSLAVE = PropertyBoolInverted.create("multiblockslave");
    public static final PropertyBoolInverted ACTIVE = PropertyBoolInverted.create("active");
    public static final PropertyBoolInverted IS_SECOND_STATE = PropertyBoolInverted.create("issecondstate");
    public static final PropertyBoolInverted MIRRORED = PropertyBoolInverted.create("mirrored");
    public static final Map<Direction, PropertyBoolInverted> SIDECONNECTION = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)PropertyBoolInverted.create("sideconnection_down")).put((Object)Direction.UP, (Object)PropertyBoolInverted.create("sideconnection_up")).put((Object)Direction.NORTH, (Object)PropertyBoolInverted.create("sideconnection_north")).put((Object)Direction.SOUTH, (Object)PropertyBoolInverted.create("sideconnection_south")).put((Object)Direction.WEST, (Object)PropertyBoolInverted.create("sideconnection_west")).put((Object)Direction.EAST, (Object)PropertyBoolInverted.create("sideconnection_east")).build();
    public static final IntegerProperty INT_4 = IntegerProperty.func_177719_a((String)"int_4", (int)0, (int)3);
    public static final IntegerProperty INT_16 = IntegerProperty.func_177719_a((String)"int_16", (int)0, (int)15);

    public static class Model {
        public static final ModelProperty<IEObjState> IE_OBJ_STATE = new ModelProperty();
        public static final ModelProperty<Map<String, String>> TEXTURE_REMAP = new ModelProperty();
        public static final ModelProperty<ConnectionModelData> CONNECTIONS = new ModelProperty();
        public static final ModelProperty<ExcavatorHandler.MineralMix> MINERAL = new ModelProperty();
        public static final ModelProperty<ConveyorHandler.IConveyorBelt> CONVEYOR = new ModelProperty();
        public static final ModelProperty<FeedthroughTileEntity.FeedthroughData> FEEDTHROUGH = new ModelProperty();
        public static final ModelProperty<Map<Direction, IEEnums.IOSideConfig>> SIDECONFIG = new ModelProperty();
        public static final ModelProperty<TileEntity> TILEENTITY_PASSTHROUGH = new ModelProperty();
    }

    public static class IEObjState {
        public final VisibilityList visibility;
        public final TransformationMatrix transform;

        public IEObjState(VisibilityList visibility) {
            this(visibility, TransformationMatrix.func_227983_a_());
        }

        public IEObjState(VisibilityList visibility, TransformationMatrix transform) {
            this.visibility = visibility;
            this.transform = transform;
        }
    }

    public static class VisibilityList {
        private final Set<String> selected;
        private final boolean showSelected;

        private VisibilityList(Collection<String> selected, boolean show) {
            this.selected = new HashSet<String>(selected);
            this.showSelected = show;
        }

        public static VisibilityList show(String ... visible) {
            return VisibilityList.show(Arrays.asList(visible));
        }

        public static VisibilityList show(Collection<String> visible) {
            return new VisibilityList(visible, true);
        }

        public static VisibilityList hide(Collection<String> hidden) {
            return new VisibilityList(hidden, false);
        }

        public static VisibilityList showAll() {
            return VisibilityList.hide((Collection<String>)ImmutableSet.of());
        }

        public static VisibilityList hideAll() {
            return VisibilityList.show((Collection<String>)ImmutableList.of());
        }

        public boolean isVisible(String group) {
            return this.showSelected == this.selected.contains(group);
        }
    }

    public static class ConnectionModelData {
        public final Set<Connection> connections;
        public final BlockPos here;

        public ConnectionModelData(Set<Connection> connections, BlockPos here) {
            this.connections = connections;
            this.here = here;
        }

        public String toString() {
            return this.connections + " at " + this.here;
        }
    }

    public static class PropertyBoolInverted
    extends Property<Boolean> {
        private static final ImmutableList<Boolean> ALLOWED_VALUES = ImmutableList.of((Object)false, (Object)true);

        protected PropertyBoolInverted(String name) {
            super(name, Boolean.class);
        }

        public Collection<Boolean> func_177700_c() {
            return ALLOWED_VALUES;
        }

        public Optional<Boolean> func_185929_b(String value) {
            return Optional.of(Boolean.parseBoolean(value));
        }

        public static PropertyBoolInverted create(String name) {
            return new PropertyBoolInverted(name);
        }

        public String getName(Boolean value) {
            return value.toString();
        }
    }
}

