/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.crafting.IngredientSerializers;
import blusunrize.immersiveengineering.common.crafting.RecipeReloadListener;
import blusunrize.immersiveengineering.common.items.DrillheadItem;
import blusunrize.immersiveengineering.common.items.HammerItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.ScrewdriverItem;
import blusunrize.immersiveengineering.common.items.WirecutterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageBirthdayParty;
import blusunrize.immersiveengineering.common.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.network.MessageMaintenanceKit;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.network.MessageNoSpamChatComponents;
import blusunrize.immersiveengineering.common.network.MessageObstructedConnection;
import blusunrize.immersiveengineering.common.network.MessageRequestBlockUpdate;
import blusunrize.immersiveengineering.common.network.MessageRevolverRotate;
import blusunrize.immersiveengineering.common.network.MessageScrollwheelItem;
import blusunrize.immersiveengineering.common.network.MessageSetGhostSlots;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.immersiveengineering.common.network.MessageSkyhookSync;
import blusunrize.immersiveengineering.common.network.MessageSpeedloaderSync;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import blusunrize.immersiveengineering.common.network.MessageWireSync;
import blusunrize.immersiveengineering.common.util.IEIMCHandler;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import blusunrize.immersiveengineering.common.util.commands.CommandHandler;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.world.IEWorldGen;
import blusunrize.immersiveengineering.common.world.Villages;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonStreamParser;
import com.mojang.brigadier.CommandDispatcher;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;

@Mod(value="immersiveengineering")
public class ImmersiveEngineering {
    public static final String MODID = "immersiveengineering";
    public static final String MODNAME = "Immersive Engineering";
    public static final String VERSION = "${version}";
    public static final String NETWORK_VERSION = "1";
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new CommonProxy());
    public static final SimpleChannel packetHandler = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("immersiveengineering", "main")).networkProtocolVersion(() -> "1").serverAcceptedVersions("1"::equals).clientAcceptedVersions("1"::equals).simpleChannel();
    private int messageId = 0;
    private static final String[] alternativeCerts = new String[]{"7e11c175d1e24007afec7498a1616bef0000027d", "MavenKeyHere"};
    public static ItemGroup itemGroup = new ItemGroup("immersiveengineering"){

        @Nonnull
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER));
        }
    };

    public ImmersiveEngineering() {
        IELogger.logger = LogManager.getLogger((String)MODID);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::wrongSignature);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        RecipeSerializers.RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        Villages.Registers.POINTS_OF_INTEREST.register(FMLJavaModLoadingContext.get().getModEventBus());
        Villages.Registers.PROFESSIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, IEConfig.ALL);
        IEContent.modConstruction();
        proxy.modConstruction();
        IngredientSerializers.init();
    }

    public void setup(FMLCommonSetupEvent event) {
        proxy.preInit();
        IEAdvancements.preInit();
        for (String b : (List)IEConfig.ORES.oreDimBlacklist.get()) {
            IEWorldGen.oreDimBlacklist.add(new ResourceLocation(b));
        }
        IEApi.modPreference = (List)IEConfig.GENERAL.preferredOres.get();
        IEApi.prefixToIngotMap.put("ingots", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("nuggets", new Integer[]{1, 9});
        IEApi.prefixToIngotMap.put("storage_blocks", new Integer[]{9, 1});
        IEApi.prefixToIngotMap.put("plates", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("wires", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("gears", new Integer[]{4, 1});
        IEApi.prefixToIngotMap.put("rods", new Integer[]{1, 2});
        IEApi.prefixToIngotMap.put("fences", new Integer[]{5, 3});
        IECompatModule.doModulesPreInit();
        ArcFurnaceRecipe.allowRecipeTypeForRecycling(IRecipeType.field_222149_a);
        ArcFurnaceRecipe.allowRecipeTypeForRecycling(MetalPressRecipe.TYPE);
        ArcFurnaceRecipe.allowItemForRecycling(stack -> stack.func_77973_b() instanceof ToolItem || stack.func_77973_b() instanceof HoeItem || stack.func_77973_b() instanceof ShearsItem || stack.func_77973_b() instanceof SwordItem || stack.func_77973_b() instanceof ArmorItem || stack.func_77973_b() instanceof HorseArmorItem || stack.func_77973_b() instanceof BucketItem);
        ArcFurnaceRecipe.allowItemForRecycling(stack -> stack.func_77973_b() instanceof HammerItem || stack.func_77973_b() instanceof WirecutterItem || stack.func_77973_b() instanceof ScrewdriverItem || stack.func_77973_b() instanceof DrillheadItem);
        ArcFurnaceRecipe.allowItemForRecycling(stack -> stack.func_77973_b() == IEItems.Molds.moldPlate || stack.func_77973_b() == IEItems.Molds.moldGear || stack.func_77973_b() == IEItems.Molds.moldRod || stack.func_77973_b() == IEItems.Molds.moldBulletCasing || stack.func_77973_b() == IEItems.Molds.moldWire || stack.func_77973_b() == IEItems.Molds.moldPacking4 || stack.func_77973_b() == IEItems.Molds.moldPacking9 || stack.func_77973_b() == IEItems.Molds.moldUnpacking);
        ArcFurnaceRecipe.allowItemForRecycling(stack -> ApiUtils.isPlate(stack) || ApiUtils.isMetalComponent(stack, "rods/") || ApiUtils.isMetalComponent(stack, "wires/") || ApiUtils.isMetalComponent(stack, "gears/") || ApiUtils.isMetalComponent(stack, "scaffoldings/") || ApiUtils.isMetalComponent(stack, "fences/"));
        ArcFurnaceRecipe.makeItemInvalidRecyclingOutput(stack -> stack.func_77973_b() instanceof HammerItem || stack.func_77973_b() instanceof WirecutterItem || stack.func_77973_b() instanceof ScrewdriverItem);
        ArcFurnaceRecipe.makeItemInvalidRecyclingOutput(stack -> ApiUtils.isIngot(stack) && Objects.requireNonNull(ApiUtils.getMetalComponentTypeAndMetal(stack, "ingots"))[1].contains("brick"));
        new ThreadContributorSpecialsDownloader();
        proxy.preInitEnd();
        IEContent.init();
        IEWorldGen ieWorldGen = new IEWorldGen();
        if (((Boolean)IEConfig.ORES.ore_bauxite.retrogenEnabled.get()).booleanValue()) {
            IEWorldGen.retrogenOres.add("retrogen_bauxite");
        }
        if (((Boolean)IEConfig.ORES.ore_lead.retrogenEnabled.get()).booleanValue()) {
            IEWorldGen.retrogenOres.add("retrogen_lead");
        }
        if (((Boolean)IEConfig.ORES.ore_silver.retrogenEnabled.get()).booleanValue()) {
            IEWorldGen.retrogenOres.add("retrogen_silver");
        }
        if (((Boolean)IEConfig.ORES.ore_nickel.retrogenEnabled.get()).booleanValue()) {
            IEWorldGen.retrogenOres.add("retrogen_nickel");
        }
        if (((Boolean)IEConfig.ORES.ore_uranium.retrogenEnabled.get()).booleanValue()) {
            IEWorldGen.retrogenOres.add("retrogen_uranium");
        }
        if (((Boolean)IEConfig.ORES.ore_copper.retrogenEnabled.get()).booleanValue()) {
            IEWorldGen.retrogenOres.add("retrogen_copper");
        }
        MinecraftForge.EVENT_BUS.register((Object)ieWorldGen);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        proxy.init();
        IECompatModule.doModulesInit();
        proxy.initEnd();
        this.registerMessage(MessageTileSync.class, MessageTileSync::new);
        this.registerMessage(MessageTileSync.class, MessageTileSync::new);
        this.registerMessage(MessageSpeedloaderSync.class, MessageSpeedloaderSync::new);
        this.registerMessage(MessageSkyhookSync.class, MessageSkyhookSync::new);
        this.registerMessage(MessageMinecartShaderSync.class, MessageMinecartShaderSync::new);
        this.registerMessage(MessageMinecartShaderSync.class, MessageMinecartShaderSync::new);
        this.registerMessage(MessageRequestBlockUpdate.class, MessageRequestBlockUpdate::new);
        this.registerMessage(MessageNoSpamChatComponents.class, MessageNoSpamChatComponents::new);
        this.registerMessage(MessageShaderManual.class, MessageShaderManual::new);
        this.registerMessage(MessageShaderManual.class, MessageShaderManual::new);
        this.registerMessage(MessageBirthdayParty.class, MessageBirthdayParty::new);
        this.registerMessage(MessageMagnetEquip.class, MessageMagnetEquip::new);
        this.registerMessage(MessageScrollwheelItem.class, MessageScrollwheelItem::new);
        this.registerMessage(MessageObstructedConnection.class, MessageObstructedConnection::new);
        this.registerMessage(MessageSetGhostSlots.class, MessageSetGhostSlots::new);
        this.registerMessage(MessageWireSync.class, MessageWireSync::new);
        this.registerMessage(MessageMaintenanceKit.class, MessageMaintenanceKit::new);
        this.registerMessage(MessageRevolverRotate.class, MessageRevolverRotate::new);
        IEIMCHandler.init();
        IEContent.postInit();
        proxy.postInit();
        IECompatModule.doModulesPostInit();
        proxy.postInitEnd();
        ShaderRegistry.compileWeight();
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<PacketBuffer, T> decoder) {
        packetHandler.registerMessage(this.messageId++, packetType, IMessage::toBytes, decoder, (t, ctx) -> {
            t.process((Supplier<NetworkEvent.Context>)ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        IECompatModule.doModulesLoadComplete();
    }

    public void wrongSignature(FMLFingerprintViolationEvent event) {
        System.out.println("[Immersive Engineering/Error] THIS IS NOT AN OFFICIAL BUILD OF IMMERSIVE ENGINEERING! Found these fingerprints: " + event.getFingerprints());
        for (String altCert : alternativeCerts) {
            if (!event.getFingerprints().contains(altCert)) continue;
            System.out.println("[Immersive Engineering/Error] " + altCert + " is considered an alternative certificate (which may be ok to use in some cases). If you thought this was an official build you probably shouldn't use it.");
            break;
        }
    }

    public void serverStarting(FMLServerStartingEvent event) {
        proxy.serverStarting();
        CommandHandler.registerServer((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new RecipeReloadListener());
    }

    public void serverStarted(FMLServerStartedEvent event) {
        ServerWorld world = event.getServer().func_71218_a(DimensionType.field_223227_a_);
        if (!world.field_72995_K) {
            IESaveData worldData = (IESaveData)world.func_217481_x().func_215752_a(IESaveData::new, "ImmersiveEngineering-SaveData");
            IESaveData.setInstance(worldData);
        }
        IEContent.refreshFluidReferences();
    }

    public static class ThreadContributorSpecialsDownloader
    extends Thread {
        public static ThreadContributorSpecialsDownloader activeThread;

        public ThreadContributorSpecialsDownloader() {
            this.setName("Immersive Engineering Contributors Thread");
            this.setDaemon(true);
            this.start();
            activeThread = this;
        }

        @Override
        public void run() {
            Gson gson = new Gson();
            try {
                IELogger.info("Attempting to download special revolvers from GitHub");
                URL url = new URL("https://raw.githubusercontent.com/BluSunrize/ImmersiveEngineering/gh-pages/contributorRevolvers.json");
                JsonStreamParser parser = new JsonStreamParser((Reader)new InputStreamReader(url.openStream()));
                while (parser.hasNext()) {
                    try {
                        JsonElement je = parser.next();
                        RevolverItem.SpecialRevolver revolver = (RevolverItem.SpecialRevolver)gson.fromJson(je, RevolverItem.SpecialRevolver.class);
                        if (revolver == null) continue;
                        if (revolver.uuid != null) {
                            for (String uuid : revolver.uuid) {
                                RevolverItem.specialRevolvers.put((Object)uuid, (Object)revolver);
                            }
                        }
                        RevolverItem.specialRevolversByTag.put(!revolver.tag.isEmpty() ? revolver.tag : revolver.flavour, revolver);
                    }
                    catch (Exception excepParse) {
                        IELogger.warn("Error on parsing a SpecialRevolver");
                    }
                }
            }
            catch (Exception e) {
                IELogger.logger.info("Could not load contributor+special revolver list.", (Throwable)e);
            }
        }
    }
}

