/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.varia.Tools;
import net.minecraft.block.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class Palette
implements ILostCityAsset {
    private String name;
    final Map<Character, Object> palette = new HashMap<Character, Object>();
    private final Map<BlockState, BlockState> damaged = new HashMap<BlockState, BlockState>();
    private final Map<Character, String> mobIds = new HashMap<Character, String>();
    private final Map<Character, String> lootTables = new HashMap<Character, String>();
    private final Set<Character> torches = new HashSet<Character>();

    public Palette() {
    }

    public Palette(JsonObject object) {
        this.readFromJSon(object);
    }

    public Palette(String name) {
        this.name = name;
    }

    public void merge(Palette other) {
        this.palette.putAll(other.palette);
        this.damaged.putAll(other.damaged);
        this.mobIds.putAll(other.mobIds);
        this.lootTables.putAll(other.lootTables);
        this.torches.addAll(other.torches);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<BlockState, BlockState> getDamaged() {
        return this.damaged;
    }

    public Map<Character, String> getMobIds() {
        return this.mobIds;
    }

    public Map<Character, String> getLootTables() {
        return this.lootTables;
    }

    public Set<Character> getTorches() {
        return this.torches;
    }

    public Map<Character, Object> getPalette() {
        return this.palette;
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        JsonArray paletteArray = object.get("palette").getAsJsonArray();
        this.parsePaletteArray(paletteArray);
    }

    public void parsePaletteArray(JsonArray paletteArray) {
        for (JsonElement element : paletteArray) {
            JsonObject o = element.getAsJsonObject();
            String value = null;
            Character c = Character.valueOf(o.get("char").getAsCharacter());
            BlockState dmg = null;
            if (o.has("damaged")) {
                dmg = Tools.stringToState(o.get("damaged").getAsString());
            }
            if (o.has("mob")) {
                this.mobIds.put(c, o.get("mob").getAsString());
            }
            if (o.has("loot")) {
                this.lootTables.put(c, o.get("loot").getAsString());
            }
            if (o.has("facing")) {
                this.torches.add(c);
            }
            if (o.has("block")) {
                String block = o.get("block").getAsString();
                BlockState state = Tools.stringToState(block);
                this.palette.put(c, state);
                if (dmg == null) continue;
                this.damaged.put(state, dmg);
                continue;
            }
            if (o.has("frompalette")) {
                value = o.get("frompalette").getAsString();
                this.palette.put(c, value);
                continue;
            }
            if (o.has("blocks")) {
                JsonArray array = o.get("blocks").getAsJsonArray();
                ArrayList<Pair> blocks = new ArrayList<Pair>();
                for (JsonElement el : array) {
                    JsonObject ob = el.getAsJsonObject();
                    Integer f = ob.get("random").getAsInt();
                    String block = ob.get("block").getAsString();
                    BlockState state = Tools.stringToState(block);
                    blocks.add(Pair.of((Object)f, (Object)state));
                    if (dmg == null) continue;
                    this.damaged.put(state, dmg);
                }
                this.addMappingViaState(c.charValue(), blocks.toArray(new Pair[blocks.size()]));
                continue;
            }
            throw new RuntimeException("Illegal palette!");
        }
    }

    private void getOrientation(Map<String, Integer> or, JsonObject torchObj, String orientation) {
        if (torchObj.has(orientation)) {
            or.put(orientation, torchObj.get(orientation).getAsInt());
        } else {
            or.put(orientation, 0);
        }
    }

    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("palette"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        JsonArray array = new JsonArray();
        for (Map.Entry<Character, Object> entry : this.palette.entrySet()) {
            JsonObject o = new JsonObject();
            o.add("char", (JsonElement)new JsonPrimitive(entry.getKey()));
            if (entry.getValue() instanceof BlockState) {
                BlockState state = (BlockState)entry.getValue();
                o.add("block", (JsonElement)new JsonPrimitive(Tools.stateToString(state)));
                if (this.damaged.containsKey(state)) {
                    o.add("damaged", (JsonElement)new JsonPrimitive(Tools.stateToString(this.damaged.get(state))));
                }
            } else if (entry.getValue() instanceof String) {
                o.add("frompalette", (JsonElement)new JsonPrimitive((String)entry.getValue()));
            } else {
                o.add("test", (JsonElement)new JsonPrimitive("@todo"));
            }
            if (this.mobIds.containsKey(entry.getKey())) {
                o.add("mob", (JsonElement)new JsonPrimitive(this.mobIds.get(entry.getKey())));
            }
            if (this.lootTables.containsKey(entry.getKey())) {
                o.add("loot", (JsonElement)new JsonPrimitive(this.lootTables.get(entry.getKey())));
            }
            array.add((JsonElement)o);
        }
        object.add("palette", (JsonElement)array);
        return object;
    }

    public Palette addMapping(char c, BlockState state) {
        this.palette.put(Character.valueOf(c), state);
        return this;
    }

    @SafeVarargs
    private final Palette addMappingViaState(char c, Pair<Integer, BlockState> ... randomBlocks) {
        this.palette.put(Character.valueOf(c), randomBlocks);
        return this;
    }
}

