/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class Configuration {
    private final Map<String, Category> categoryMap = new HashMap<String, Category>();

    public Value getValue(String name) {
        String[] split = name.split("\\.");
        Category category = this.categoryMap.get(split[0]);
        if (category == null) {
            throw new RuntimeException("Could not find category '" + split[0] + "'!");
        }
        Value value = (Value)category.valueMap.get(split[1]);
        if (value == null) {
            throw new RuntimeException("Could not find value '" + name + "'!");
        }
        return value;
    }

    public <T> T get(String name) {
        String[] split = name.split("\\.");
        Category category = this.categoryMap.get(split[0]);
        if (category == null) {
            throw new RuntimeException("Could not find category '" + split[0] + "'!");
        }
        Value value = (Value)category.valueMap.get(split[1]);
        if (value == null) {
            throw new RuntimeException("Could not find value '" + name + "'!");
        }
        return (T)value.value;
    }

    public <T> void set(String name, T val) {
        String[] split = name.split("\\.");
        Category category = this.categoryMap.get(split[0]);
        if (category == null) {
            throw new RuntimeException("Could not find category '" + split[0] + "'!");
        }
        Value value = (Value)category.valueMap.get(split[1]);
        if (value == null) {
            throw new RuntimeException("Could not find value '" + name + "'!");
        }
        value.value = val;
    }

    public JsonObject toJson(boolean readonly) {
        JsonObject root = new JsonObject();
        for (Map.Entry<String, Category> entry : this.categoryMap.entrySet()) {
            JsonObject categoryObject = new JsonObject();
            if (readonly) {
                categoryObject.addProperty("__readonly__", "This profile is read only and cannot be modified! If you want to make a new profile based on this then you can make a copy to a new name");
            }
            Category category = entry.getValue();
            for (Map.Entry valueEntry : category.valueMap.entrySet()) {
                String key = (String)valueEntry.getKey();
                Value value = (Value)valueEntry.getValue();
                if (value.value instanceof Number) {
                    categoryObject.addProperty(key, (Number)value.value);
                    continue;
                }
                if (value.value instanceof Boolean) {
                    categoryObject.addProperty(key, (Boolean)value.value);
                    continue;
                }
                if (value.value instanceof String) {
                    categoryObject.addProperty(key, (String)value.value);
                    continue;
                }
                if (!(value.value instanceof String[])) continue;
                JsonArray array = new JsonArray();
                for (String s : (String[])value.value) {
                    array.add((JsonElement)new JsonPrimitive(s));
                }
                categoryObject.add(key, (JsonElement)array);
            }
            root.add(entry.getKey(), (JsonElement)categoryObject);
        }
        return root;
    }

    public void fromJson(JsonObject root) {
        for (Map.Entry entry : root.entrySet()) {
            String category = (String)entry.getKey();
            this.addCustomCategoryComment(category, "<none>");
            for (Map.Entry elementEntry : ((JsonElement)entry.getValue()).getAsJsonObject().entrySet()) {
                JsonElement valueEl = (JsonElement)elementEntry.getValue();
                if (valueEl.isJsonPrimitive()) {
                    if (valueEl.getAsJsonPrimitive().isNumber()) {
                        this.getFloat((String)elementEntry.getKey(), category, valueEl.getAsFloat(), 0.0f, 0.0f, "");
                        continue;
                    }
                    if (valueEl.getAsJsonPrimitive().isString()) {
                        this.getString((String)elementEntry.getKey(), category, valueEl.getAsString(), "");
                        continue;
                    }
                    if (!valueEl.getAsJsonPrimitive().isBoolean()) continue;
                    this.getBoolean((String)elementEntry.getKey(), category, valueEl.getAsBoolean(), "");
                    continue;
                }
                if (!valueEl.isJsonArray()) continue;
                ArrayList<String> list = new ArrayList<String>();
                for (JsonElement element : valueEl.getAsJsonArray()) {
                    list.add(element.getAsString());
                }
                this.getStringList((String)elementEntry.getKey(), category, list.toArray(new String[list.size()]), "");
            }
        }
    }

    public void addCustomCategoryComment(String category, String description) {
        if (!this.categoryMap.containsKey(category)) {
            this.categoryMap.put(category, new Category(category, description));
        }
    }

    private <T> Category getValueCategory(String name, String category, T defaultValue, String description, T min, T max, @Nonnull Comparator<T> comparator) {
        Category cat = this.categoryMap.get(category);
        if (cat == null) {
            throw new IllegalStateException("Missing category: " + category);
        }
        if (!cat.valueMap.containsKey(name)) {
            cat.valueMap.put(name, new Value<T>(name, description, defaultValue, min, max, comparator));
        }
        return cat;
    }

    public float getFloat(String name, String category, float defaultValue, float minValue, float maxValue, String description) {
        Category cat = this.getValueCategory(name, category, Float.valueOf(defaultValue), description, Float.valueOf(minValue), Float.valueOf(maxValue), Float::compareTo);
        Object value = ((Value)cat.valueMap.get(name)).value;
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return ((Integer)value).floatValue();
    }

    public boolean getBoolean(String name, String category, boolean defaultValue, String description) {
        Category cat = this.getValueCategory(name, category, defaultValue, description, null, null, (o1, o2) -> 0);
        return (Boolean)((Value)cat.valueMap.get(name)).value;
    }

    public int getInt(String name, String category, int defaultValue, int minValue, int maxValue, String description) {
        Category cat = this.getValueCategory(name, category, defaultValue, description, minValue, maxValue, Integer::compareTo);
        Object value = ((Value)cat.valueMap.get(name)).value;
        if (value instanceof Float) {
            return ((Float)value).intValue();
        }
        return (Integer)value;
    }

    public String getString(String name, String category, String defaultValue, String description) {
        Category cat = this.getValueCategory(name, category, defaultValue, description, null, null, (o1, o2) -> 0);
        return (String)((Value)cat.valueMap.get(name)).value;
    }

    public String getString(String name, String category, String defaultValue, String description, String[] strings) {
        Category cat = this.getValueCategory(name, category, defaultValue, description, null, null, (o1, o2) -> 0);
        return (String)((Value)cat.valueMap.get(name)).value;
    }

    public String[] getStringList(String name, String category, String[] defaultValue, String description) {
        Category cat = this.getValueCategory(name, category, defaultValue, description, null, null, (o1, o2) -> 0);
        return (String[])((Value)cat.valueMap.get(name)).value;
    }

    public boolean hasKey(String category, String name) {
        return this.categoryMap.get(category).valueMap.containsKey(name);
    }

    public Collection<Object> getCategory(String categoryGeneral) {
        return Collections.emptyList();
    }

    public static class Category {
        private final String name;
        private final String comment;
        private final Map<String, Value> valueMap = new HashMap<String, Value>();

        public Category(String name, String comment) {
            this.name = name;
            this.comment = comment;
        }
    }

    public static class Value<T> {
        private final String name;
        private final String comment;
        private T value;
        private final T min;
        private final T max;
        private final Comparator<T> comparator;

        public Value(String name, String comment, T value, T min, T max, @Nonnull Comparator<T> comparator) {
            this.name = name;
            this.comment = comment;
            this.value = value;
            this.min = min;
            this.max = max;
            this.comparator = comparator;
        }

        public void set(T val) {
            this.value = val;
        }

        public T get() {
            return this.value;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean constrain() {
            if (this.comparator.compare(this.value, this.min) < 0) {
                this.value = this.min;
                return true;
            }
            if (this.comparator.compare(this.value, this.max) > 0) {
                this.value = this.max;
                return true;
            }
            return false;
        }
    }
}

