/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets;

import me.desht.modularrouters.client.gui.IResyncableGui;
import me.desht.modularrouters.client.gui.widgets.button.ITooltipButton;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class GuiContainerBase<T extends Container>
extends ContainerScreen<T>
implements IResyncableGui {
    private TextFieldManager textFieldManager;

    public GuiContainerBase(T container, PlayerInventory inv, ITextComponent displayName) {
        super(container, inv, displayName);
    }

    protected TextFieldManager createTextFieldManager() {
        this.textFieldManager = new TextFieldManager((Screen)this);
        return this.textFieldManager;
    }

    protected TextFieldManager getOrCreateTextFieldManager() {
        if (this.textFieldManager == null) {
            this.textFieldManager = this.createTextFieldManager();
        }
        return this.textFieldManager;
    }

    public void render(int x, int y, float partialTicks) {
        this.renderBackground();
        super.render(x, y, partialTicks);
        if (this.textFieldManager != null) {
            this.textFieldManager.drawTextFields(x, y, partialTicks);
        }
        this.buttons.stream().filter(button -> button.isMouseOver((double)x, (double)y) && button instanceof ITooltipButton).forEach(button -> this.renderTooltip(((ITooltipButton)button).getTooltip(), x, y, this.font));
        this.func_191948_b(x, y);
    }

    public void tick() {
        super.tick();
        if (this.textFieldManager != null) {
            this.textFieldManager.tick();
        }
    }

    public boolean mouseScrolled(double x, double y, double dir) {
        return this.textFieldManager != null ? this.textFieldManager.mouseScrolled(dir) : super.mouseScrolled(x, y, dir);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.textFieldManager != null && this.textFieldManager.mouseClicked(x, y, button)) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.textFieldManager != null && this.textFieldManager.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int modifiers) {
        if (this.textFieldManager != null && this.textFieldManager.charTyped(c, modifiers)) {
            return true;
        }
        return super.charTyped(c, modifiers);
    }

    protected boolean isFocused() {
        return this.textFieldManager != null && this.textFieldManager.isFocused();
    }

    @Override
    public void resync(ItemStack stack) {
    }
}

