/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.additions.common.entity.EntityBalloon;
import mekanism.api.Coord4D;
import mekanism.api.Pos3D;
import mekanism.api.text.EnumColor;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ItemBalloon
extends Item {
    private final EnumColor color;

    public ItemBalloon(EnumColor color) {
        super(ItemDeferredRegister.getMekBaseProperties());
        this.color = color;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new DispenserBehavior());
    }

    public EnumColor getColor() {
        return this.color;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K) {
            Pos3D pos = new Pos3D(hand == Hand.MAIN_HAND ? -0.4 : 0.4, 0.0, 0.3).rotateYaw(player.field_70761_aq).translate((Vec3d)new Pos3D((Entity)player));
            world.func_217376_c((Entity)new EntityBalloon(world, pos.field_72450_a - 0.5, pos.field_72448_b - 0.25, pos.field_72449_c - 0.5, this.color));
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBalloon) {
            return TextComponentUtil.build((Object[])new Object[]{((ItemBalloon)item).getColor(), super.func_200295_i(stack)});
        }
        return super.func_200295_i(stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        if (player.func_225608_bj_()) {
            BlockPos pos = context.func_195995_a();
            AxisAlignedBB bound = new AxisAlignedBB(pos, pos.func_177982_a(1, 3, 1));
            List balloonsNear = player.field_70170_p.func_217357_a(EntityBalloon.class, bound);
            if (!balloonsNear.isEmpty()) {
                return ActionResultType.FAIL;
            }
            World world = context.func_195991_k();
            if (MekanismUtils.isValidReplaceableBlock((IBlockReader)world, (BlockPos)pos)) {
                pos = pos.func_177977_b();
            }
            if (!Block.func_220056_d((BlockState)world.func_180495_p(pos), (IBlockReader)world, (BlockPos)pos, (Direction)Direction.UP)) {
                return ActionResultType.FAIL;
            }
            if (MekanismUtils.isValidReplaceableBlock((IBlockReader)world, (BlockPos)pos.func_177984_a()) && MekanismUtils.isValidReplaceableBlock((IBlockReader)world, (BlockPos)pos.func_177981_b(2))) {
                world.func_217377_a(pos.func_177984_a(), false);
                world.func_217377_a(pos.func_177981_b(2), false);
                if (!world.field_72995_K) {
                    world.func_217376_c((Entity)new EntityBalloon(world, pos, this.color));
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        if (player.func_225608_bj_()) {
            if (!player.field_70170_p.field_72995_K) {
                AxisAlignedBB bound = new AxisAlignedBB(entity.func_226277_ct_() - 0.2, entity.func_226278_cu_() - 0.5, entity.func_226281_cx_() - 0.2, entity.func_226277_ct_() + 0.2, entity.func_226278_cu_() + (double)entity.func_213305_a((Pose)entity.func_213283_Z()).field_220316_b + 4.0, entity.func_226281_cx_() + 0.2);
                List balloonsNear = player.field_70170_p.func_217357_a(EntityBalloon.class, bound);
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    return true;
                }
                player.field_70170_p.func_217376_c((Entity)new EntityBalloon(entity, this.color));
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public class DispenserBehavior
    extends DefaultDispenseItemBehavior {
        @Nonnull
        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Coord4D coord = new Coord4D(source.func_82615_a(), source.func_82617_b(), source.func_82616_c(), source.func_197524_h().func_201675_m().func_186058_p());
            Direction side = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
            List entities = source.func_197524_h().func_217357_a(LivingEntity.class, coord.offset(side).getBoundingBox());
            boolean latched = false;
            for (LivingEntity entity : entities) {
                AxisAlignedBB bound = new AxisAlignedBB(entity.func_226277_ct_() - 0.2, entity.func_226278_cu_() - 0.5, entity.func_226281_cx_() - 0.2, entity.func_226277_ct_() + 0.2, entity.func_226278_cu_() + (double)entity.func_213305_a((Pose)entity.func_213283_Z()).field_220316_b + 4.0, entity.func_226281_cx_() + 0.2);
                List balloonsNear = source.func_197524_h().func_217357_a(EntityBalloon.class, bound);
                boolean hasBalloon = false;
                for (EntityBalloon balloon : balloonsNear) {
                    if (balloon.latchedEntity != entity) continue;
                    hasBalloon = true;
                    break;
                }
                if (hasBalloon) continue;
                source.func_197524_h().func_217376_c((Entity)new EntityBalloon(entity, ItemBalloon.this.color));
                latched = true;
            }
            if (!latched) {
                Pos3D pos = new Pos3D(coord).translate(0.0, -0.5, 0.0);
                switch (side) {
                    case DOWN: {
                        pos = pos.translate(0.0, -2.5, 0.0);
                        break;
                    }
                    case UP: {
                        pos = pos.translate(0.0, 0.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        pos = pos.translate(0.0, -1.0, -0.5);
                        break;
                    }
                    case SOUTH: {
                        pos = pos.translate(0.0, -1.0, 0.5);
                        break;
                    }
                    case WEST: {
                        pos = pos.translate(-0.5, -1.0, 0.0);
                        break;
                    }
                    case EAST: {
                        pos = pos.translate(0.5, -1.0, 0.0);
                        break;
                    }
                }
                if (!source.func_197524_h().field_72995_K) {
                    source.func_197524_h().func_217376_c((Entity)new EntityBalloon(source.func_197524_h(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, ItemBalloon.this.color));
                }
            }
            stack.func_190918_g(1);
            return stack;
        }
    }
}

