/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.client.emote;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.tweaks.client.emote.EmoteBase;
import vazkii.quark.tweaks.client.emote.ModelAccessor;

@OnlyIn(value=Dist.CLIENT)
public class EmoteState {
    private float[] states = new float[0];
    private final EmoteBase emote;

    public EmoteState(EmoteBase emote) {
        this.emote = emote;
    }

    public void save(BipedModel<?> model) {
        float[] values = new float[1];
        for (int i = 0; i < 21; ++i) {
            ModelAccessor.INSTANCE.getValues(model, i, values);
            this.states[i] = values[0];
        }
    }

    public void load(BipedModel<?> model) {
        if (this.states.length == 0) {
            this.states = new float[21];
        } else {
            float[] values = new float[1];
            for (int i = 0; i < 21; ++i) {
                values[0] = this.states[i];
                int part = i / 3 * 3;
                if (!this.emote.usesBodyPart(part)) continue;
                ModelAccessor.INSTANCE.setValues(model, i, values);
            }
        }
    }

    public void rotateAndOffset(PlayerEntity player) {
        if (this.states.length == 0) {
            return;
        }
        float rotX = this.states[18];
        float rotY = this.states[19];
        float rotZ = this.states[20];
        float height = player.func_213302_cg();
        RenderSystem.translatef((float)0.0f, (float)(height / 2.0f), (float)0.0f);
        if (rotY != 0.0f) {
            RenderSystem.rotatef((float)(rotY * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotX != 0.0f) {
            RenderSystem.rotatef((float)(rotX * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rotZ != 0.0f) {
            RenderSystem.rotatef((float)(rotZ * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        RenderSystem.translatef((float)0.0f, (float)(-height / 2.0f), (float)0.0f);
    }
}

