/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tools.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlintRenderType {
    public static Map<Integer, RenderType> glintColorMap = new HashMap<Integer, RenderType>(){
        {
            for (DyeColor color : DyeColor.values()) {
                this.put(color.func_196059_a(), GlintRenderType.buildGlintRenderType(color.func_176610_l()));
            }
            this.put(16, GlintRenderType.buildGlintRenderType("rainbow"));
        }
    };
    public static Map<Integer, RenderType> entityGlintColorMap = new HashMap<Integer, RenderType>(){
        {
            for (DyeColor color : DyeColor.values()) {
                this.put(color.func_196059_a(), GlintRenderType.buildEntityGlintRenderType(color.func_176610_l()));
            }
            this.put(16, GlintRenderType.buildEntityGlintRenderType("rainbow"));
        }
    };

    public static void addGlintTypes(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> map) {
        glintColorMap.forEach((color, renderType) -> {
            if (!map.containsKey(renderType)) {
                map.put(renderType, (Object)new BufferBuilder(renderType.func_228662_o_()));
            }
        });
        entityGlintColorMap.forEach((color, renderType) -> {
            if (!map.containsKey(renderType)) {
                map.put(renderType, (Object)new BufferBuilder(renderType.func_228662_o_()));
            }
        });
    }

    private static RenderType buildGlintRenderType(String name) {
        ResourceLocation res = new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
        return RenderType.func_228632_a_((String)("glint_" + name), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(res, true, false)).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228715_a_(RenderState.field_228493_C_).func_228726_a_(RenderState.field_228513_e_).func_228725_a_(RenderState.field_228526_r_).func_228728_a_(false));
    }

    private static RenderType buildEntityGlintRenderType(String name) {
        ResourceLocation res = new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
        return RenderType.func_228632_a_((String)("entity_glint_" + name), (VertexFormat)DefaultVertexFormats.field_181707_g, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(res, true, false)).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228715_a_(RenderState.field_228493_C_).func_228726_a_(RenderState.field_228513_e_).func_228725_a_(RenderState.field_228527_s_).func_228728_a_(false));
    }
}

