/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.nbt;

import com.google.gson.JsonElement;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import com.terraforged.core.util.serialization.serializer.Serializer;
import com.terraforged.mod.util.nbt.NBTReader;
import com.terraforged.mod.util.nbt.NBTWriter;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;

public class NBTHelper {
    public static JsonElement toJson(CompoundNBT tag) {
        Dynamic input = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag);
        Dynamic output = input.convert((DynamicOps)JsonOps.INSTANCE);
        return (JsonElement)output.getValue();
    }

    public static CompoundNBT fromJson(JsonElement json) {
        Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
        Dynamic output = input.convert((DynamicOps)NBTDynamicOps.field_210820_a);
        return (CompoundNBT)output.getValue();
    }

    public static Stream<CompoundNBT> stream(CompoundNBT tag) {
        return tag.func_150296_c().stream().map(arg_0 -> ((CompoundNBT)tag).func_74775_l(arg_0)).sorted(Comparator.comparing(t -> t.func_74762_e("#order")));
    }

    public static CompoundNBT serialize(Object object) {
        try {
            NBTWriter writer = new NBTWriter();
            writer.readFrom(object);
            return writer.compound();
        }
        catch (IllegalAccessException e) {
            return new CompoundNBT();
        }
    }

    public static CompoundNBT serializeCompact(Object object) {
        try {
            NBTWriter writer = new NBTWriter();
            writer.readFrom(object);
            return NBTHelper.stripMetadata(writer.compound());
        }
        catch (IllegalAccessException e) {
            return new CompoundNBT();
        }
    }

    public static CompoundNBT readCompact(Object object) {
        try {
            NBTWriter writer = new NBTWriter();
            writer.readFrom(object);
            new Serializer().serialize(object, writer);
            return writer.compound();
        }
        catch (IllegalAccessException e) {
            return new CompoundNBT();
        }
    }

    public static <T extends INBT> T stripMetadata(T tag) {
        block4: {
            block3: {
                if (!(tag instanceof CompoundNBT)) break block3;
                CompoundNBT compound = (CompoundNBT)tag;
                LinkedList keys = new LinkedList(compound.func_150296_c());
                for (String key : keys) {
                    if (key.charAt(0) == '#') {
                        compound.func_82580_o(key);
                        continue;
                    }
                    NBTHelper.stripMetadata(compound.func_74781_a(key));
                }
                break block4;
            }
            if (!(tag instanceof ListNBT)) break block4;
            ListNBT list = (ListNBT)tag;
            for (int i = 0; i < list.size(); ++i) {
                NBTHelper.stripMetadata(list.get(i));
            }
        }
        return tag;
    }

    public static void deserialize(CompoundNBT settings, Object object) {
        try {
            NBTReader reader = new NBTReader((INBT)settings);
            reader.writeTo(object);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

