/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui.preview;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.terrain.Terrain;
import java.awt.Color;
import me.dags.noise.util.NoiseUtil;

public enum RenderMode {
    BIOME_TYPE{

        @Override
        public int getColor(Cell<Terrain> cell, float scale, float bias) {
            Color color = cell.biomeType.getColor();
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
            return 1.rgba(hsb[0], hsb[1], hsb[2] * scale + bias);
        }
    }
    ,
    TEMPERATURE{

        @Override
        public int getColor(Cell<Terrain> cell, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return 2.rgba(RenderMode.step(1.0f - cell.temperature, 8) * 0.65f, saturation, brightness);
        }
    }
    ,
    MOISTURE{

        @Override
        public int getColor(Cell<Terrain> cell, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return 3.rgba(RenderMode.step(cell.moisture, 8) * 0.65f, saturation, brightness);
        }
    }
    ,
    BIOME_SHAPE{

        @Override
        public int getColor(Cell<Terrain> cell, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return 4.rgba(cell.biome, saturation, brightness);
        }
    }
    ,
    TERRAIN_TYPE{

        @Override
        public int getColor(Cell<Terrain> cell, float scale, float bias) {
            float saturation = 0.7f;
            float brightness = 0.8f;
            return 5.rgba(cell.region, saturation, brightness);
        }
    };


    public int getColor(Cell<Terrain> cell, Levels levels) {
        float baseHeight = levels.water;
        if (cell.value < baseHeight) {
            return RenderMode.rgba(40, 140, 200);
        }
        float bands = 10.0f;
        float alpha = 0.2f;
        float elevation = (cell.value - baseHeight) / (1.0f - baseHeight);
        int band = NoiseUtil.round(elevation * bands);
        float scale = 1.0f - alpha;
        float bias = alpha * ((float)band / bands);
        return this.getColor(cell, scale, bias);
    }

    public abstract int getColor(Cell<Terrain> var1, float var2, float var3);

    private static float step(float value, int steps) {
        return (float)NoiseUtil.round(value * (float)steps) / (float)steps;
    }

    public static int rgba(float h, float s, float b) {
        int argb = Color.HSBtoRGB(h, s, b);
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        return RenderMode.rgba(red, green, blue);
    }

    public static int rgba(int r, int g, int b) {
        return r + (g << 8) + (b << 16) + -16777216;
    }
}

