/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.rivermap.river;

import com.terraforged.core.world.heightmap.Levels;
import me.dags.noise.util.NoiseUtil;

public class RiverConfig {
    public final boolean main;
    public final int bedWidth;
    public final int bankWidth;
    public final float bedHeight;
    public final float minBankHeight;
    public final float maxBankHeight;
    public final int length2;
    public final double fade;

    private RiverConfig(Builder builder) {
        this.main = builder.main;
        this.bedWidth = builder.bedWidth;
        this.bankWidth = builder.bankWidth;
        this.bedHeight = builder.levels.water(-builder.bedDepth);
        this.minBankHeight = builder.levels.water(builder.minBankHeight);
        this.maxBankHeight = builder.levels.water(builder.maxBankHeight);
        this.length2 = builder.length * builder.length;
        this.fade = builder.fade;
    }

    private RiverConfig(boolean main, int bedWidth, int bankWidth, float bedHeight, float minBankHeight, float maxBankHeight, int length2, double fade) {
        this.main = main;
        this.bedWidth = bedWidth;
        this.bankWidth = bankWidth;
        this.bedHeight = bedHeight;
        this.minBankHeight = minBankHeight;
        this.maxBankHeight = maxBankHeight;
        this.length2 = length2;
        this.fade = fade;
    }

    public RiverConfig createFork(float connectWidth) {
        if ((float)this.bankWidth < connectWidth) {
            return this;
        }
        float scale = (float)this.bankWidth / connectWidth;
        return new RiverConfig(false, NoiseUtil.round((float)this.bedWidth / scale), NoiseUtil.round((float)this.bankWidth / scale), this.bedHeight, this.minBankHeight, this.maxBankHeight, this.length2, this.fade);
    }

    public static Builder builder(Levels levels) {
        return new Builder(levels);
    }

    public static class Builder {
        private boolean main = false;
        private int bedWidth = 4;
        private int bankWidth = 15;
        private int bedDepth = 5;
        private int maxBankHeight = 1;
        private int minBankHeight = 1;
        private int length = 1000;
        private double fade = 0.2;
        private final Levels levels;

        private Builder(Levels levels) {
            this.levels = levels;
        }

        public Builder main(boolean value) {
            this.main = value;
            return this;
        }

        public Builder bedWidth(int value) {
            this.bedWidth = value;
            return this;
        }

        public Builder bankWidth(int value) {
            this.bankWidth = value;
            return this;
        }

        public Builder bedDepth(int depth) {
            this.bedDepth = depth;
            return this;
        }

        public Builder bankHeight(int min, int max) {
            this.minBankHeight = Math.min(min, max);
            this.maxBankHeight = Math.max(min, max);
            return this;
        }

        public Builder length(int value) {
            this.length = value;
            return this;
        }

        public Builder fade(double value) {
            this.fade = value;
            return this;
        }

        public RiverConfig build() {
            return new RiverConfig(this);
        }
    }
}

