/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.heightmap;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.cell.Populator;
import com.terraforged.core.module.Blender;
import com.terraforged.core.settings.GeneratorSettings;
import com.terraforged.core.settings.Settings;
import com.terraforged.core.util.Seed;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.climate.Climate;
import com.terraforged.core.world.continent.ContinentLerper2;
import com.terraforged.core.world.continent.ContinentLerper3;
import com.terraforged.core.world.continent.ContinentModule;
import com.terraforged.core.world.heightmap.Heightmap;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.core.world.heightmap.RegionConfig;
import com.terraforged.core.world.rivermap.RiverMap;
import com.terraforged.core.world.rivermap.RiverRegionList;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.TerrainPopulator;
import com.terraforged.core.world.terrain.Terrains;
import com.terraforged.core.world.terrain.provider.TerrainProvider;
import com.terraforged.core.world.terrain.region.RegionLerper;
import com.terraforged.core.world.terrain.region.RegionModule;
import com.terraforged.core.world.terrain.region.RegionSelector;
import me.dags.noise.Module;
import me.dags.noise.Source;
import me.dags.noise.func.EdgeFunc;
import me.dags.noise.func.Interpolation;

public class WorldHeightmap
implements Heightmap {
    private static final float DEEP_OCEAN_VALUE = 0.2f;
    private static final float OCEAN_VALUE = 0.3f;
    private static final float BEACH_VALUE = 0.34f;
    private static final float COAST_VALUE = 0.4f;
    private static final float INLAND_VALUE = 0.6f;
    private final Levels levels;
    private final Terrains terrain;
    private final Settings settings;
    private final Populator continentModule;
    private final Populator regionModule;
    private final Climate climate;
    private final Populator root;
    private final RiverMap riverMap;
    private final TerrainProvider terrainProvider;

    public WorldHeightmap(GeneratorContext context) {
        context = context.copy();
        this.levels = context.levels;
        this.terrain = context.terrain;
        this.settings = context.settings;
        this.climate = new Climate(context);
        Seed seed = context.seed;
        Levels levels = context.levels;
        GeneratorSettings genSettings = context.settings.generator;
        Seed regionSeed = seed.nextSeed();
        Seed regionWarp = seed.nextSeed();
        int regionWarpScale = 400;
        int regionWarpStrength = 200;
        RegionConfig regionConfig = new RegionConfig(regionSeed.get(), context.settings.generator.land.regionSize, Source.simplex(regionWarp.next(), regionWarpScale, 1), Source.simplex(regionWarp.next(), regionWarpScale, 1), regionWarpStrength);
        this.regionModule = new RegionModule(regionConfig);
        Module mountainShapeBase = Source.cellEdge(seed.next(), genSettings.land.mountainScale, EdgeFunc.DISTANCE_2_ADD).add(Source.cubic(seed.next(), genSettings.land.mountainScale, 1).scale(-0.05));
        Module mountainShape = mountainShapeBase.curve(Interpolation.CURVE3).clamp(0.0, 0.9).map(0.0, 1.0);
        this.terrainProvider = context.terrainFactory.create(context, regionConfig, this);
        RegionSelector terrainRegions = new RegionSelector(this.terrainProvider.getPopulators());
        TerrainPopulator terrainRegionBorders = new TerrainPopulator(this.terrainProvider.getLandforms().plains(seed), context.terrain.steppe);
        RegionLerper terrain = new RegionLerper(terrainRegionBorders, terrainRegions);
        TerrainPopulator mountains = this.register(this.terrainProvider.getLandforms().mountains(seed), context.terrain.mountains);
        this.continentModule = new ContinentModule(seed, this.settings.generator);
        Blender land = new Blender(mountainShape, terrain, mountains, 0.1f, 0.9f, 0.6f);
        ContinentLerper3 oceans = new ContinentLerper3(this.climate, this.register(this.terrainProvider.getLandforms().deepOcean(seed.next()), context.terrain.deepOcean), this.register(Source.constant(levels.water(-7)), context.terrain.ocean), this.register(Source.constant(levels.water), context.terrain.coast), 0.2f, 0.3f, 0.4f);
        this.root = new ContinentLerper2(oceans, land, 0.3f, 0.6f, 0.4f, 0.35f);
        this.riverMap = new RiverMap(this, context);
    }

    @Override
    public void visit(Cell<Terrain> cell, float x, float z) {
        this.continentModule.apply(cell, x, z);
        this.regionModule.apply(cell, x, z);
        this.root.apply(cell, x, z);
    }

    @Override
    public void apply(Cell<Terrain> cell, float x, float z) {
        this.applyBase(cell, x, z);
        this.applyRivers(cell, x, z, this.riverMap.getRivers((int)x, (int)z));
        this.applyClimate(cell, x, z);
    }

    @Override
    public void applyBase(Cell<Terrain> cell, float x, float z) {
        cell.tag = this.terrain.steppe;
        this.continentModule.apply(cell, x, z);
        this.regionModule.apply(cell, x, z);
        this.root.apply(cell, x, z);
    }

    @Override
    public void applyRivers(Cell<Terrain> cell, float x, float z, RiverRegionList rivers) {
        rivers.apply(cell, x, z);
    }

    @Override
    public void applyClimate(Cell<Terrain> cell, float x, float z) {
        if (cell.value <= this.levels.water) {
            this.climate.apply(cell, x, z, false);
            if (cell.tag == this.terrain.coast) {
                cell.tag = this.terrain.ocean;
            }
        } else {
            int range = this.settings.generator.biomeEdgeNoise.strength;
            float dx = this.climate.getOffsetX(x, z, range);
            float dz = this.climate.getOffsetZ(x, z, range);
            float px = x + dx;
            float pz = z + dz;
            this.tag(cell, px, pz);
            this.climate.apply(cell, px, pz, false);
            this.climate.apply(cell, x, z, true);
        }
    }

    @Override
    public void tag(Cell<Terrain> cell, float x, float z) {
        this.continentModule.apply(cell, x, z);
        this.regionModule.apply(cell, x, z);
        this.root.tag(cell, x, z);
    }

    @Override
    public Climate getClimate() {
        return this.climate;
    }

    @Override
    public RiverMap getRiverMap() {
        return this.riverMap;
    }

    public Populator getPopulator(Terrain terrain) {
        return this.terrainProvider.getPopulator(terrain);
    }

    private TerrainPopulator register(Module module, Terrain terrain) {
        TerrainPopulator populator = new TerrainPopulator(module, terrain);
        this.terrainProvider.registerMixable(populator);
        return populator;
    }
}

