/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world;

import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.WorldDecorators;
import com.terraforged.core.world.WorldFilters;
import com.terraforged.core.world.WorldGenerator;
import com.terraforged.core.world.climate.Climate;
import com.terraforged.core.world.heightmap.Heightmap;
import com.terraforged.core.world.heightmap.WorldHeightmap;
import java.util.function.Supplier;

public class WorldGeneratorFactory
implements Supplier<WorldGenerator> {
    private final GeneratorContext context;
    private final Heightmap heightmap;
    private final WorldDecorators decorators;

    public WorldGeneratorFactory(GeneratorContext context) {
        this.context = context;
        this.heightmap = new WorldHeightmap(context);
        this.decorators = new WorldDecorators(context);
    }

    public WorldGeneratorFactory(GeneratorContext context, Heightmap heightmap) {
        this.context = context;
        this.heightmap = heightmap;
        this.decorators = new WorldDecorators(context);
    }

    public Heightmap getHeightmap() {
        return this.heightmap;
    }

    public Climate getClimate() {
        return this.getHeightmap().getClimate();
    }

    public WorldDecorators getDecorators() {
        return this.decorators;
    }

    public WorldFilters getFilters() {
        return new WorldFilters(this.context);
    }

    @Override
    public WorldGenerator get() {
        return new WorldGenerator(this.heightmap, this.decorators, this.getFilters());
    }
}

