/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.entity;

import com.teammetallurgy.aquaculture.entity.FishType;
import com.teammetallurgy.aquaculture.entity.ai.goal.FollowTypeSchoolLeaderGoal;
import com.teammetallurgy.aquaculture.init.AquaItems;
import java.util.HashMap;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.FollowSchoolLeaderGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class AquaFishEntity
extends AbstractGroupFishEntity {
    public static HashMap<EntityType<AquaFishEntity>, Item> BUCKETS = new HashMap();
    public static HashMap<EntityType<AquaFishEntity>, FishType> TYPES = new HashMap();

    public AquaFishEntity(EntityType<? extends AbstractGroupFishEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.field_220892_d.forEach(prioritizedGoal -> {
            if (prioritizedGoal.func_220772_j().getClass() == FollowSchoolLeaderGoal.class) {
                this.field_70714_bg.func_85156_a(prioritizedGoal.func_220772_j());
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowTypeSchoolLeaderGoal(this));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.func_203707_dx();
    }

    @Nonnull
    protected ItemStack func_203707_dx() {
        return new ItemStack((IItemProvider)BUCKETS.get(this.func_200600_R()));
    }

    @Nonnull
    protected SoundEvent func_203701_dz() {
        if (TYPES.get(this.func_200600_R()) == FishType.JELLYFISH) {
            return SoundEvents.field_187888_ft;
        }
        return SoundEvents.field_203818_az;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203815_ax;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_203813_aA;
    }

    @Nonnull
    public EntitySize func_213305_a(@Nonnull Pose pose) {
        return super.func_213305_a(pose);
    }

    public void func_70100_b_(@Nonnull PlayerEntity player) {
        super.func_70100_b_(player);
        if (Objects.equals(this.func_200600_R().getRegistryName(), AquaItems.JELLYFISH.getRegistryName()) && this.func_70089_S() && this.func_70068_e((Entity)player) < 1.0 && player.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 0.5f)) {
            this.func_184185_a(SoundEvents.field_187870_fk, 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_174815_a((LivingEntity)this, (Entity)player);
        }
    }

    public static boolean canSpawnHere(EntityType<? extends AbstractFishEntity> fish, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        boolean isAllNeighborsSource = AquaFishEntity.isSourceBlock(world, pos.func_177978_c()) && AquaFishEntity.isSourceBlock(world, pos.func_177968_d()) && AquaFishEntity.isSourceBlock(world, pos.func_177976_e()) && AquaFishEntity.isSourceBlock(world, pos.func_177974_f());
        return AquaFishEntity.isSourceBlock(world, pos) && isAllNeighborsSource;
    }

    private static boolean isSourceBlock(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c() instanceof FlowingFluidBlock && world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a) && (Integer)state.func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0;
    }
}

