/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class PipeRenderer
extends TileEntityRenderer<PipeTileEntity> {
    private final Random random = new Random();

    public PipeRenderer(TileEntityRendererDispatcher disp) {
        super(disp);
    }

    public void render(PipeTileEntity tile, float v, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int k, int i1) {
        if (tile.getItems().isEmpty()) {
            return;
        }
        matrixStack.func_227860_a_();
        BlockPos tilePos = tile.func_174877_v();
        matrixStack.func_227861_a_((double)(-tilePos.func_177958_n()), (double)(-tilePos.func_177956_o()), (double)(-tilePos.func_177952_p()));
        for (PipeItem item : tile.getItems()) {
            float scale;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)MathHelper.func_219799_g((float)v, (float)item.lastX, (float)item.x), (double)MathHelper.func_219799_g((float)v, (float)item.lastY, (float)item.y), (double)MathHelper.func_219799_g((float)v, (float)item.lastZ, (float)item.z));
            if (item.stack.func_77973_b() instanceof BlockItem) {
                scale = 0.7f;
                matrixStack.func_227862_a_(scale, scale, scale);
                matrixStack.func_227861_a_(0.0, (double)-0.2f, 0.0);
            } else {
                scale = 0.45f;
                matrixStack.func_227862_a_(scale, scale, scale);
                matrixStack.func_227861_a_(0.0, (double)-0.1f, 0.0);
            }
            this.random.setSeed(Item.func_150891_b((Item)item.stack.func_77973_b()) + item.stack.func_77952_i());
            int amount = this.getModelCount(item.stack);
            for (int i = 0; i < amount; ++i) {
                matrixStack.func_227860_a_();
                if (amount > 1) {
                    matrixStack.func_227861_a_((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f), (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f), (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f));
                }
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(item.stack, ItemCameraTransforms.TransformType.GROUND, k, i1, matrixStack, iRenderTypeBuffer);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    protected int getModelCount(ItemStack stack) {
        int i = 1;
        if (stack.func_190916_E() > 48) {
            i = 5;
        } else if (stack.func_190916_E() > 32) {
            i = 4;
        } else if (stack.func_190916_E() > 16) {
            i = 3;
        } else if (stack.func_190916_E() > 1) {
            i = 2;
        }
        return i;
    }
}

