/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.common.network.client.CPacketDestroyCurios;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;
import top.theillusivec4.curios.common.network.client.CPacketOpenVanilla;
import top.theillusivec4.curios.common.network.client.CPacketScrollCurios;
import top.theillusivec4.curios.common.network.server.SPacketBreakCurio;
import top.theillusivec4.curios.common.network.server.SPacketGrabbedItem;
import top.theillusivec4.curios.common.network.server.SPacketScrollCurios;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncActive;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncContents;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncContentsWithTag;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncMap;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncSize;

public class NetworkHandler {
    private static final String PTC_VERSION = "1";
    public static SimpleChannel INSTANCE;
    private static int id;

    public static void register() {
        INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("curios", "main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        NetworkHandler.register(CPacketOpenCurios.class, CPacketOpenCurios::encode, CPacketOpenCurios::decode, CPacketOpenCurios::handle);
        NetworkHandler.register(CPacketOpenVanilla.class, CPacketOpenVanilla::encode, CPacketOpenVanilla::decode, CPacketOpenVanilla::handle);
        NetworkHandler.register(CPacketScrollCurios.class, CPacketScrollCurios::encode, CPacketScrollCurios::decode, CPacketScrollCurios::handle);
        NetworkHandler.register(CPacketDestroyCurios.class, CPacketDestroyCurios::encode, CPacketDestroyCurios::decode, CPacketDestroyCurios::handle);
        NetworkHandler.register(SPacketSyncContents.class, SPacketSyncContents::encode, SPacketSyncContents::decode, SPacketSyncContents::handle);
        NetworkHandler.register(SPacketScrollCurios.class, SPacketScrollCurios::encode, SPacketScrollCurios::decode, SPacketScrollCurios::handle);
        NetworkHandler.register(SPacketSyncActive.class, SPacketSyncActive::encode, SPacketSyncActive::decode, SPacketSyncActive::handle);
        NetworkHandler.register(SPacketSyncSize.class, SPacketSyncSize::encode, SPacketSyncSize::decode, SPacketSyncSize::handle);
        NetworkHandler.register(SPacketSyncMap.class, SPacketSyncMap::encode, SPacketSyncMap::decode, SPacketSyncMap::handle);
        NetworkHandler.register(SPacketSyncContentsWithTag.class, SPacketSyncContentsWithTag::encode, SPacketSyncContentsWithTag::decode, SPacketSyncContentsWithTag::handle);
        NetworkHandler.register(SPacketBreakCurio.class, SPacketBreakCurio::encode, SPacketBreakCurio::decode, SPacketBreakCurio::handle);
        NetworkHandler.register(SPacketGrabbedItem.class, SPacketGrabbedItem::encode, SPacketGrabbedItem::decode, SPacketGrabbedItem::handle);
        CuriosAPI.brokenCurioConsumer = (id, index, livingEntity) -> INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), (Object)new SPacketBreakCurio(livingEntity.func_145782_y(), (String)id, (int)index));
    }

    private static <M> void register(Class<M> messageType, BiConsumer<M, PacketBuffer> encoder, Function<PacketBuffer, M> decoder, BiConsumer<M, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(id++, messageType, encoder, decoder, messageConsumer);
    }

    static {
        id = 0;
    }
}

