/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import top.theillusivec4.curios.common.CuriosConfig;

public class CuriosLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public CuriosLayer(IEntityRenderer<T, M> renderer) {
        super(renderer);
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer renderTypeBuffer, int light, @Nonnull T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((Boolean)CuriosConfig.CLIENT.renderCurios.get()).booleanValue()) {
            return;
        }
        matrixStack.func_227860_a_();
        CuriosAPI.getCuriosHandler(livingEntity).ifPresent(handler -> {
            SortedMap<String, CurioStackHandler> curios = handler.getCurioMap();
            for (String id : curios.keySet()) {
                CurioStackHandler stackHandler = (CurioStackHandler)((Object)((Object)curios.get(id)));
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    CuriosAPI.getCurio(stack).ifPresent(curio -> {
                        if (curio.hasRender(id, (LivingEntity)livingEntity)) {
                            matrixStack.func_227860_a_();
                            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            curio.render(id, matrixStack, renderTypeBuffer, light, (LivingEntity)livingEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                            matrixStack.func_227865_b_();
                        }
                    });
                }
            }
        });
        matrixStack.func_227865_b_();
    }
}

