/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import org.jetbrains.annotations.NotNull;

public class PropDouble
extends PropBase<Double> {
    public static final PropDoubleParser PARSER = new PropDoubleParser();
    protected double min;
    protected double max;

    public PropDouble(double value, double min, double max) {
        super(value);
        this.min = min;
        this.max = max;
    }

    public PropDouble(double value) {
        this(value, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    @Override
    public String getExtra() {
        return "[" + this.min + "~" + this.max + "]";
    }

    @Override
    protected Double validateData(Double data) {
        return MathUtil.clamp(data, this.min, this.max);
    }

    @Override
    public PropParserBase getParser() {
        return PARSER;
    }

    protected static class PropDoubleParser
    extends PropParserBase<PropDouble> {
        public PropDoubleParser() {
            super("do");
        }

        @Override
        public PropDouble fromJson(@NotNull JsonElement json) throws Exception {
            return new PropDouble(json.getAsDouble());
        }

        @Override
        public JsonElement toJson(@NotNull PropDouble prop) throws Exception {
            return new JsonPrimitive((Number)prop.getValue());
        }
    }
}

