/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtHeight64;
import net.minecraft.world.gen.placement.AtSurface;
import net.minecraft.world.gen.placement.AtSurfaceRandomCount;
import net.minecraft.world.gen.placement.AtSurfaceWithChance;
import net.minecraft.world.gen.placement.AtSurfaceWithChanceMultiple;
import net.minecraft.world.gen.placement.AtSurfaceWithExtra;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.CaveEdge;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ChanceRange;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.ChorusPlant;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.CountRange;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DarkOakTreePlacement;
import net.minecraft.world.gen.placement.DepthAverage;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.DungeonRoom;
import net.minecraft.world.gen.placement.EndGateway;
import net.minecraft.world.gen.placement.EndIsland;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.Height4To32;
import net.minecraft.world.gen.placement.HeightBiasedRange;
import net.minecraft.world.gen.placement.HeightVeryBiasedRange;
import net.minecraft.world.gen.placement.HeightWithChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.IcebergPlacement;
import net.minecraft.world.gen.placement.LakeLava;
import net.minecraft.world.gen.placement.LakeWater;
import net.minecraft.world.gen.placement.NetherFire;
import net.minecraft.world.gen.placement.NetherGlowstone;
import net.minecraft.world.gen.placement.NetherMagma;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Passthrough;
import net.minecraft.world.gen.placement.RandomCountWithRange;
import net.minecraft.world.gen.placement.SurfacePlus32;
import net.minecraft.world.gen.placement.SurfacePlus32WithNoise;
import net.minecraft.world.gen.placement.TopSolid;
import net.minecraft.world.gen.placement.TopSolidOnce;
import net.minecraft.world.gen.placement.TopSolidRange;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.placement.TopSolidWithChance;
import net.minecraft.world.gen.placement.TopSolidWithNoise;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraft.world.gen.placement.TwiceSurface;
import net.minecraft.world.gen.placement.TwiceSurfaceWithChance;
import net.minecraft.world.gen.placement.TwiceSurfaceWithChanceMultiple;
import net.minecraft.world.gen.placement.TwiceSurfaceWithNoise;
import net.minecraft.world.gen.placement.WithChance;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Placement<DC extends IPlacementConfig>
extends ForgeRegistryEntry<Placement<?>> {
    public static final Placement<NoPlacementConfig> field_215022_h = Placement.func_214999_a("nope", new Passthrough(NoPlacementConfig::func_214735_a));
    public static final Placement<FrequencyConfig> field_215015_a = Placement.func_214999_a("count_heightmap", new AtSurface(FrequencyConfig::func_214721_a));
    public static final Placement<FrequencyConfig> field_215016_b = Placement.func_214999_a("count_top_solid", new TopSolid(FrequencyConfig::func_214721_a));
    public static final Placement<FrequencyConfig> field_215017_c = Placement.func_214999_a("count_heightmap_32", new SurfacePlus32(FrequencyConfig::func_214721_a));
    public static final Placement<FrequencyConfig> field_215018_d = Placement.func_214999_a("count_heightmap_double", new TwiceSurface(FrequencyConfig::func_214721_a));
    public static final Placement<FrequencyConfig> field_215019_e = Placement.func_214999_a("count_height_64", new AtHeight64(FrequencyConfig::func_214721_a));
    public static final Placement<NoiseDependant> field_215020_f = Placement.func_214999_a("noise_heightmap_32", new SurfacePlus32WithNoise(NoiseDependant::func_214734_a));
    public static final Placement<NoiseDependant> field_215021_g = Placement.func_214999_a("noise_heightmap_double", new TwiceSurfaceWithNoise(NoiseDependant::func_214734_a));
    public static final Placement<ChanceConfig> field_215023_i = Placement.func_214999_a("chance_heightmap", new AtSurfaceWithChance(ChanceConfig::func_214722_a));
    public static final Placement<ChanceConfig> field_215024_j = Placement.func_214999_a("chance_heightmap_double", new TwiceSurfaceWithChance(ChanceConfig::func_214722_a));
    public static final Placement<ChanceConfig> field_215025_k = Placement.func_214999_a("chance_passthrough", new WithChance(ChanceConfig::func_214722_a));
    public static final Placement<ChanceConfig> field_215026_l = Placement.func_214999_a("chance_top_solid_heightmap", new TopSolidWithChance(ChanceConfig::func_214722_a));
    public static final Placement<AtSurfaceWithExtraConfig> field_215027_m = Placement.func_214999_a("count_extra_heightmap", new AtSurfaceWithExtra(AtSurfaceWithExtraConfig::func_214723_a));
    public static final Placement<CountRangeConfig> field_215028_n = Placement.func_214999_a("count_range", new CountRange(CountRangeConfig::func_214733_a));
    public static final Placement<CountRangeConfig> field_215029_o = Placement.func_214999_a("count_biased_range", new HeightBiasedRange(CountRangeConfig::func_214733_a));
    public static final Placement<CountRangeConfig> field_215030_p = Placement.func_214999_a("count_very_biased_range", new HeightVeryBiasedRange(CountRangeConfig::func_214733_a));
    public static final Placement<CountRangeConfig> field_215031_q = Placement.func_214999_a("random_count_range", new RandomCountWithRange(CountRangeConfig::func_214733_a));
    public static final Placement<ChanceRangeConfig> field_215032_r = Placement.func_214999_a("chance_range", new ChanceRange(ChanceRangeConfig::func_214732_a));
    public static final Placement<HeightWithChanceConfig> field_215033_s = Placement.func_214999_a("count_chance_heightmap", new AtSurfaceWithChanceMultiple(HeightWithChanceConfig::func_214724_a));
    public static final Placement<HeightWithChanceConfig> field_215034_t = Placement.func_214999_a("count_chance_heightmap_double", new TwiceSurfaceWithChanceMultiple(HeightWithChanceConfig::func_214724_a));
    public static final Placement<DepthAverageConfig> field_215035_u = Placement.func_214999_a("count_depth_average", new DepthAverage(DepthAverageConfig::func_214729_a));
    public static final Placement<NoPlacementConfig> field_215036_v = Placement.func_214999_a("top_solid_heightmap", new TopSolidOnce(NoPlacementConfig::func_214735_a));
    public static final Placement<TopSolidRangeConfig> field_215037_w = Placement.func_214999_a("top_solid_heightmap_range", new TopSolidRange(TopSolidRangeConfig::func_214725_a));
    public static final Placement<TopSolidWithNoiseConfig> field_215038_x = Placement.func_214999_a("top_solid_heightmap_noise_biased", new TopSolidWithNoise(TopSolidWithNoiseConfig::func_214726_a));
    public static final Placement<CaveEdgeConfig> field_215039_y = Placement.func_214999_a("carving_mask", new CaveEdge(CaveEdgeConfig::func_214720_a));
    public static final Placement<FrequencyConfig> field_215040_z = Placement.func_214999_a("forest_rock", new AtSurfaceRandomCount(FrequencyConfig::func_214721_a));
    public static final Placement<FrequencyConfig> field_215002_A = Placement.func_214999_a("hell_fire", new NetherFire(FrequencyConfig::func_214721_a));
    public static final Placement<FrequencyConfig> field_215003_B = Placement.func_214999_a("magma", new NetherMagma(FrequencyConfig::func_214721_a));
    public static final Placement<NoPlacementConfig> field_215004_C = Placement.func_214999_a("emerald_ore", new Height4To32(NoPlacementConfig::func_214735_a));
    public static final Placement<ChanceConfig> field_215005_D = Placement.func_214999_a("lava_lake", new LakeLava(ChanceConfig::func_214722_a));
    public static final Placement<ChanceConfig> field_215006_E = Placement.func_214999_a("water_lake", new LakeWater(ChanceConfig::func_214722_a));
    public static final Placement<ChanceConfig> field_215007_F = Placement.func_214999_a("dungeons", new DungeonRoom(ChanceConfig::func_214722_a));
    public static final Placement<NoPlacementConfig> field_215008_G = Placement.func_214999_a("dark_oak_tree", new DarkOakTreePlacement(NoPlacementConfig::func_214735_a));
    public static final Placement<ChanceConfig> field_215009_H = Placement.func_214999_a("iceberg", new IcebergPlacement(ChanceConfig::func_214722_a));
    public static final Placement<FrequencyConfig> field_215010_I = Placement.func_214999_a("light_gem_chance", new NetherGlowstone(FrequencyConfig::func_214721_a));
    public static final Placement<NoPlacementConfig> field_215011_J = Placement.func_214999_a("end_island", new EndIsland(NoPlacementConfig::func_214735_a));
    public static final Placement<NoPlacementConfig> field_215012_K = Placement.func_214999_a("chorus_plant", new ChorusPlant(NoPlacementConfig::func_214735_a));
    public static final Placement<NoPlacementConfig> field_215013_L = Placement.func_214999_a("end_gateway", new EndGateway(NoPlacementConfig::func_214735_a));
    private final Function<Dynamic<?>, ? extends DC> field_215014_M;

    private static <T extends IPlacementConfig, G extends Placement<T>> G func_214999_a(String key, G p_214999_1_) {
        return (G)((Object)Registry.func_218325_a(Registry.field_218380_r, key, p_214999_1_));
    }

    public Placement(Function<Dynamic<?>, ? extends DC> configFactoryIn) {
        this.field_215014_M = configFactoryIn;
    }

    public DC func_215001_a(Dynamic<?> p_215001_1_) {
        return (DC)((IPlacementConfig)this.field_215014_M.apply(p_215001_1_));
    }

    public ConfiguredPlacement<DC> func_227446_a_(DC p_227446_1_) {
        return new ConfiguredPlacement(this, p_227446_1_);
    }

    protected <FC extends IFeatureConfig, F extends Feature<FC>> boolean func_214998_a(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> p_214998_2_, Random random, BlockPos pos, DC p_214998_5_, ConfiguredFeature<FC, F> p_214998_6_) {
        AtomicBoolean atomicboolean = new AtomicBoolean(false);
        this.func_212848_a_(worldIn, p_214998_2_, random, p_214998_5_, pos).forEach(p_215000_5_ -> {
            boolean flag = p_214998_6_.func_222734_a(worldIn, p_214998_2_, random, p_215000_5_);
            atomicboolean.set(atomicboolean.get() || flag);
        });
        return atomicboolean.get();
    }

    public abstract Stream<BlockPos> func_212848_a_(IWorld var1, ChunkGenerator<? extends GenerationSettings> var2, Random var3, DC var4, BlockPos var5);

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    }
}

