/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.resources.SimpleResource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenshotEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ScreenShotHelper {
    private static final Logger field_148261_a = LogManager.getLogger();
    private static final DateFormat field_74295_a = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public static void func_148260_a(File gameDirectory, int width, int height, Framebuffer buffer, Consumer<ITextComponent> messageConsumer) {
        ScreenShotHelper.func_148259_a(gameDirectory, null, width, height, buffer, messageConsumer);
    }

    public static void func_148259_a(File gameDirectory, @Nullable String screenshotName, int width, int height, Framebuffer buffer, Consumer<ITextComponent> messageConsumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> ScreenShotHelper.func_228051_b_(gameDirectory, screenshotName, width, height, buffer, messageConsumer));
        } else {
            ScreenShotHelper.func_228051_b_(gameDirectory, screenshotName, width, height, buffer, messageConsumer);
        }
    }

    private static void func_228051_b_(File gameDirectory, @Nullable String screenshotName, int width, int height, Framebuffer buffer, Consumer<ITextComponent> messageConsumer) {
        NativeImage nativeimage = ScreenShotHelper.func_198052_a(width, height, buffer);
        File file1 = new File(gameDirectory, "screenshots");
        file1.mkdir();
        File file2 = screenshotName == null ? ScreenShotHelper.func_74290_a(file1) : new File(file1, screenshotName);
        ScreenshotEvent event = ForgeHooksClient.onScreenshot((NativeImage)nativeimage, (File)file2);
        if (event.isCanceled()) {
            messageConsumer.accept(event.getCancelMessage());
            return;
        }
        File target = event.getScreenshotFile();
        SimpleResource.field_199031_a.execute(() -> {
            try {
                nativeimage.func_209271_a(target);
                ITextComponent itextcomponent = new StringTextComponent(target.getName()).func_211708_a(TextFormatting.UNDERLINE).func_211710_a(p_228050_1_ -> p_228050_1_.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, target.getAbsolutePath())));
                if (event.getResultMessage() != null) {
                    messageConsumer.accept(event.getResultMessage());
                } else {
                    messageConsumer.accept((ITextComponent)new TranslationTextComponent("screenshot.success", itextcomponent));
                }
            }
            catch (Exception exception) {
                field_148261_a.warn("Couldn't save screenshot", (Throwable)exception);
                messageConsumer.accept((ITextComponent)new TranslationTextComponent("screenshot.failure", exception.getMessage()));
            }
            finally {
                nativeimage.close();
            }
        });
    }

    public static NativeImage func_198052_a(int width, int height, Framebuffer framebufferIn) {
        width = framebufferIn.field_147622_a;
        height = framebufferIn.field_147620_b;
        NativeImage nativeimage = new NativeImage(width, height, false);
        RenderSystem.bindTexture((int)framebufferIn.field_147617_g);
        nativeimage.func_195717_a(0, true);
        nativeimage.func_195710_e();
        return nativeimage;
    }

    private static File func_74290_a(File gameDirectory) {
        String s = field_74295_a.format(new Date());
        int i = 1;
        File file1;
        while ((file1 = new File(gameDirectory, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }
}

