/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class BucketItem
extends Item {
    private final Fluid field_77876_a;
    private final Supplier<? extends Fluid> fluidSupplier;

    @Deprecated
    public BucketItem(Fluid containedFluidIn, Item.Properties builder) {
        super(builder);
        this.field_77876_a = containedFluidIn;
        this.fluidSupplier = containedFluidIn.delegate;
    }

    public BucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(builder);
        this.field_77876_a = null;
        this.fluidSupplier = supplier;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        RayTraceResult raytraceresult;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)itemstack, (RayTraceResult)(raytraceresult = BucketItem.func_219968_a(worldIn, playerIn, this.field_77876_a == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE)));
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)((Object)itemstack));
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)((Object)itemstack));
        }
        BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        Direction direction = blockraytraceresult.func_216354_b();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (this.field_77876_a == Fluids.field_204541_a) {
                Fluid fluid;
                BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                if (blockstate1.func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)blockstate1.func_177230_c()).func_204508_a((IWorld)worldIn, blockpos, blockstate1)) != Fluids.field_204541_a) {
                    playerIn.func_71029_a(Stats.field_75929_E.func_199076_b(this));
                    SoundEvent soundevent = this.field_77876_a.getAttributes().getEmptySound();
                    if (soundevent == null) {
                        soundevent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    }
                    playerIn.func_184185_a(soundevent, 1.0f, 1.0f);
                    ItemStack itemstack1 = this.func_150910_a(itemstack, playerIn, fluid.func_204524_b());
                    if (!worldIn.field_72995_K) {
                        CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerIn, new ItemStack(fluid.func_204524_b()));
                    }
                    return ActionResult.func_226248_a_((Object)((Object)itemstack1));
                }
                return ActionResult.func_226251_d_((Object)((Object)itemstack));
            }
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(worldIn, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.func_180616_a(playerIn, worldIn, blockpos2, blockraytraceresult)) {
                this.func_203792_a(worldIn, itemstack, blockpos2);
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockpos2, itemstack);
                }
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b(this));
                return ActionResult.func_226248_a_((Object)((Object)this.func_203790_a(itemstack, playerIn)));
            }
            return ActionResult.func_226251_d_((Object)((Object)itemstack));
        }
        return ActionResult.func_226251_d_((Object)((Object)itemstack));
    }

    protected ItemStack func_203790_a(ItemStack p_203790_1_, PlayerEntity p_203790_2_) {
        return !p_203790_2_.field_71075_bZ.field_75098_d ? new ItemStack(Items.field_151133_ar) : p_203790_1_;
    }

    public void func_203792_a(World worldIn, ItemStack p_203792_2_, BlockPos pos) {
    }

    private ItemStack func_150910_a(ItemStack emptyBuckets, PlayerEntity player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        emptyBuckets.func_190918_g(1);
        if (emptyBuckets.func_190926_b()) {
            return new ItemStack(fullBucket);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(fullBucket))) {
            player.func_71019_a(new ItemStack(fullBucket), false);
        }
        return emptyBuckets;
    }

    public boolean func_180616_a(@Nullable PlayerEntity player, World worldIn, BlockPos posIn, @Nullable BlockRayTraceResult p_180616_4_) {
        if (!(this.field_77876_a instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(posIn);
        Material material = blockstate.func_185904_a();
        boolean flag = blockstate.func_227032_a_(this.field_77876_a);
        boolean canContainFluid = this.canBlockContainFluid(worldIn, posIn, blockstate);
        if (blockstate.func_196958_f() || flag || canContainFluid) {
            if (worldIn.field_73011_w.func_177500_n() && this.field_77876_a.func_207185_a(FluidTags.field_206959_a)) {
                int i = posIn.func_177958_n();
                int j = posIn.func_177956_o();
                int k = posIn.func_177952_p();
                worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (canContainFluid) {
                if (((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, blockstate, ((FlowingFluid)this.field_77876_a).func_207204_a(false))) {
                    this.func_203791_b(player, worldIn, posIn);
                }
            } else {
                if (!worldIn.field_72995_K && flag && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                this.func_203791_b(player, worldIn, posIn);
                worldIn.func_180501_a(posIn, this.field_77876_a.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return p_180616_4_ == null ? false : this.func_180616_a(player, worldIn, p_180616_4_.func_216350_a().func_177972_a(p_180616_4_.func_216354_b()), null);
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        SoundEvent soundevent = this.field_77876_a.getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = this.field_77876_a.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        worldIn.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (((Object)((Object)this)).getClass() == BucketItem.class) {
            return new FluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public Fluid getFluid() {
        return this.fluidSupplier.get();
    }

    private boolean canBlockContainFluid(World worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)((Object)worldIn), posIn, blockstate, this.field_77876_a);
    }
}

